import { module, test } from 'qunit';
import validateVideoFile from 'web-client/utilities/video-uploader/validate-video-file';
import {
  FILE_SIZE_LIMIT,
  FILE_SIZE_ERROR_MESSAGE,
  FILE_TYPE_ERROR_MESSAGE
} from 'web-client/utilities/video-uploader/validate-video-file';

module('Unit | Utilities | video-uploader | validate-video-file');

test('errors with a file that is too large', function(assert) {
  let file = {type : 'video/mp4', size: FILE_SIZE_LIMIT + 1};

  assert.equal(
    validateVideoFile(file),
    FILE_SIZE_ERROR_MESSAGE,
    'returns the correct error message'
  );
});

test('errors with a file that is not the correct mime-type', function(assert) {
  let file = {type : 'text/plain', size: 100};

  assert.equal(
    validateVideoFile(file),
    FILE_TYPE_ERROR_MESSAGE,
    'returns the correct error message'
  );
});
