package s3

import (
	"fmt"

	"code.justin.tv/vodsvc/aws/awsconfig"
	"github.com/aws/aws-sdk-go/aws"
	s3pkg "github.com/aws/aws-sdk-go/service/s3"
	"github.com/aws/aws-sdk-go/service/s3/s3manager"
)

func (s *s3) BatchDeletePrefix(prefix string, maxKeys int64) error {
	if len(prefix) == 0 {
		return fmt.Errorf("prefix length should be greater than zero: %v", prefix)
	}

	deleter := s3manager.NewBatchDelete(awsconfig.Session)
	input := &s3pkg.ListObjectsInput{
		Bucket:  aws.String(s.Bucket),
		Prefix:  aws.String(prefix),
		MaxKeys: aws.Int64(maxKeys),
	}
	iter := s3manager.NewDeleteListIterator(s.client, input)
	return deleter.Delete(aws.BackgroundContext(), iter)
}
