package main

import (
	"context"
	"encoding/base64"
	"fmt"
	"os"

	"code.justin.tv/vodsvc/aws/awsconfig"
	"github.com/aws/aws-lambda-go/cfn"
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/kms"
)

func encrypt(ctx context.Context, event cfn.Event) (physicalResourceID string, data map[string]interface{}, err error) {

	physicalResourceID = "secret"
	data = map[string]interface{}{}

	if event.RequestType == cfn.RequestDelete {
		return
	}

	secret, ok := event.ResourceProperties["Secret"].(string)
	if !ok {
		err = fmt.Errorf("'Secret' is a required parameter")
		return
	}

	client := kms.New(awsconfig.Session)
	kmsKey := os.Getenv("KMS_KEY")

	input := &kms.EncryptInput{
		KeyId:     aws.String(kmsKey),
		Plaintext: []byte(secret),
	}

	output, err := client.Encrypt(input)
	if err != nil {
		err = fmt.Errorf("Error encrypting secret key: %v", err)
		return
	}

	cipher := base64.StdEncoding.EncodeToString(output.CiphertextBlob)
	data = map[string]interface{}{
		"Ciphertext": cipher,
	}

	return
}

func main() {
	lambda.Start(cfn.LambdaWrap(encrypt))
}
