package awsconfig

import (
	"fmt"
	"os"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/session"
)

var Logger aws.Logger
var Session *session.Session

func init() {
	Logger = aws.NewDefaultLogger()
	Session = NewSession()
}

func SetLogger(f func(...interface{})) {
	Logger = aws.LoggerFunc(f)
}

func NewSession() *session.Session {
	s := session.Must(session.NewSession())
	debug := os.Getenv("AWS_DEBUG")
	trace := os.Getenv("AWS_TRACE")

	if len(trace) > 0 {
		s.Handlers.Unmarshal.PushFront(func(r *request.Request) {
			Logger.Log(fmt.Sprintf("AWS Request: %v/%v, Duration: %v, Status: %v, Params: %v",
				r.ClientInfo.ServiceName, r.Operation.Name, time.Now().Sub(r.Time), r.HTTPResponse.StatusCode, r.Params))
		})
	} else if len(debug) > 0 {
		s.Handlers.Unmarshal.PushFront(func(r *request.Request) {
			Logger.Log(fmt.Sprintf("AWS Request: %v/%v, Duration: %v, Status: %v",
				r.ClientInfo.ServiceName, r.Operation.Name, time.Now().Sub(r.Time), r.HTTPResponse.StatusCode))
		})
	}

	return s
}
