package s3

import (
	"code.justin.tv/vodsvc/aws/awsconfig"
	"github.com/aws/aws-sdk-go/aws"
	s3pkg "github.com/aws/aws-sdk-go/service/s3"
	"github.com/aws/aws-sdk-go/service/s3/s3iface"
)

type S3 interface {
	InitiateMultipartUpload(key string) (string, error)
	UploadPart(input *UploadPartInput) (string, error)
	CompleteMultipartUpload(key, uploadId string, parts map[string]string) error
	ObjectExists(key string) (bool, error)
	CacheObject(key, path string) error
	GetObject(key string) ([]byte, error)
	BucketName() string
}

func New(bucket string) S3 {
	return &s3{
		Bucket: bucket,
		client: s3pkg.New(awsconfig.NewSession()),
		logger: awsconfig.Logger,
	}
}

type s3 struct {
	Bucket string
	client s3iface.S3API
	logger aws.Logger
}

func (s *s3) BucketName() string {
	return s.Bucket
}
