package httpserver

import (
	"fmt"
	"os"

	log "go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

var logger *log.SugaredLogger

func DefaultLogger() *log.Logger {
	c := log.Config{
		Level:             log.NewAtomicLevelAt(log.DebugLevel),
		Development:       false,
		DisableCaller:     true,
		DisableStacktrace: true,
		Encoding:          "console",
		EncoderConfig:     log.NewProductionEncoderConfig(),
		OutputPaths:       []string{"stdout"},
		ErrorOutputPaths:  []string{"stderr"},
		Sampling:          nil,
	}
	c.EncoderConfig.EncodeTime = zapcore.ISO8601TimeEncoder

	l, err := c.Build()
	if err != nil {
		fmt.Println("Error building logging config: " + err.Error())
		os.Exit(1)
	}
	return l
}

func ConfigureLogging() {
	logger = DefaultLogger().Sugar()
}
