package httpserver

import (
	"net/http"

	"github.com/satori/go.uuid"
)

const RequestIDHeader = "X-Request-ID"

func RequestID(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		id := r.Header.Get(RequestIDHeader)
		if id == "" {
			id = uuid.NewV4().String()
			r.Header.Add(RequestIDHeader, id)
		}
		w.Header().Add(RequestIDHeader, id)
		h.ServeHTTP(w, r)
	})
}
