package jwt

import (
	"io/ioutil"
	"testing"

	"code.justin.tv/common/jwt"
	jwtgo "github.com/dgrijalva/jwt-go"
)

type claimsT struct {
	Name string
}

var secret = []byte("secret")
var vHS512 = jwt.HS512(secret[:])
var vHeader = jwt.NewHeader(vHS512)

func BenchmarkStreamEncode(b *testing.B) {
	for i := 0; i < b.N; i++ {
		streamEncode(vHeader, claimsT{Name: "lel"}, vHS512, ioutil.Discard)
	}
}

func BenchmarkStreamBlockEncode(b *testing.B) {
	for i := 0; i < b.N; i++ {
		streamBlockEncode(vHeader, claimsT{Name: "lel"}, vHS512, ioutil.Discard)
	}
}

func BenchmarkJwtgoEncode(b *testing.B) {
	for i := 0; i < b.N; i++ {
		t := jwtgo.New(jwtgo.SigningMethodHS256)

		t.Claims["Name"] = "lel"

		tokenString, _ := t.SignedString(secret)

		ioutil.Discard.Write([]byte(tokenString))
	}

}
