GoTranscodeWorker
============

[![codecov](https://codecov.internal.justin.tv/ghe/video/gotranscoder/branch/master/graph/badge.svg)](https://codecov.internal.justin.tv/ghe/video/gotranscoder)

![qml-level-3](https://s3-us-west-2.amazonaws.com/qml-private-static/level3.png)

# Overview

HLS transcode worker in Go. This will take an RTMP stream, setup all it's properties in usher. Launch libavtwitch to generate video segments, and coordinate the live stream, serve video playlists.

# Architecture Overview
 [Video Architecture Overview](https://docs.google.com/a/justin.tv/document/d/1YZjom1M1A3ttBGcDj7ddKQP98MVylqIVqeSQl3yQBGY/edit?usp=sharing)

TODO - overall architecture of transcoder

# Documentation Links

## Tech Spec
The technical specification doc

[Gdocs spec](https://docs.google.com/a/justin.tv/document/d/1lkzUYiaWESaM4jELQdzHT6QPjQ8FbmBdAYZM5ZR5wS8/edit)

# Use
 Usage of gotranscoder is done locally via makefile commands (for simplicity)
 ```powershell
 make exec_channel twitchmedia2
 ```

This command is an alias to build, query digestion for the rtmp endpoint of a channel, and start a local transcode.
the transcoded output will be written to /tmp

## Prerequisites

* Go 1.7 installed on the local machine
* godeps
* video/avtools installed on the local machine
* the output of avtools: TwitchTranscoder , copies to /opt/TwitchTranscoder for local Development

## Local Development Setup

```powershell
        export GoPath=<GoTranscoder Path>
        cd <gopath>/src/git-aws.internal.justin.tv/video/gotranscoder
        go install ./...
        cp <TwitchTranscoderBinary> /opt/TwitchTranscoder
```

then in order to run gotranscoder locally:

```powershell
        make test # This executes the test cases
        make exec_channel # this transcodes a channel locally
```


## Configuring for Production
Configuration values are/should be saved in `config/default_config.json`
config/config.go needs to be updated as well when making changes to the configuration schema.

Gotranscoder can be run with the flag `--gotranscoder_config="filename"` to override the configuration


### Encoding Profiles

Configuring the transcode stack is done via passing a parameter into GoTranscoder.

The profile definitions are defined in `config/transcode_profiles.json` and `config/transcode_qualities.json`

A transcode *quality* defines a single transcode configuration mix. I.E. This is the quality of the video produced.

```json
        "High30Baseline" : {
                "label" : "high",
                "profile" : "baseline",
                "preset" : "veryfast",
                "max_fps" : 30,
                "height" : 720,
                "bitrate" : 1600000,
                "optimize_ts": false,
                "validate": true,
                "file_name_prefix": "index"
        }
```
A *Profile* defines a name, and a list of transcode qualities to generate on a trancode. This would be the stack of qualities to make.


```json
        "Twitch2015Base" : {
                "description" : "2015 default stack: Everything 30fps and using baseline",
                "transcode_keys" : ["High30Baseline","Medium30Baseline","Low30Baseline","Mobile30Baseline"]
        }
```

## Dependencies

This project depends on TwitchTranscoder/LibAvtwitch. video/LibAvTwitch should be cloned and built with ./install.sh , and also video/transcoder. transcoder produces the TwitchTranscoder executable which is just a C++ wrapper over libavtwitch, to be called by Go. Be sure to place TwitchTranscoder in /opt or where config/localdev_config.json specifies

## Building

Deploy the code into a golang workspace


```bash
{$GOPATH}/src/git-aws.internal.justin.tv/video/gotranscoder
make
```

or

```bash
go build ./...
or use the alias
make
```

## Testing

### Automated tests
This is a shortcut to execute all automated tests in all packages. This is the same as go test ./... ,but it is here as a shortcuts for other make commands.

```bash
make test
```
Tests are also executed on every execution via `Make Run`, to stop GoTranscoder from running
(while developing locally) without all test cases passing.

### Jenkins
Tests with code coverage are run on builds via Jenkins. the `deploy.groovy` file contains the run command
or the tests. Failing to pass all tests will cause the build to fail, and be marked as fail on github.


### Code Coverage
This shortcut will execute all tests, save and merge the coverage report for all packages in
the project, and launch the code coverage viewer in a browser window.

```bash
make cover
```

### Local BVT (basic verification test)

* Video Stream: Point OBS, FFMPEG or another tool into the staging stream server: RTMP://video999.sfo01.justin.tv/app
* Start streaming on your own channel/strream_key combo *(Do not test on a live channel like streamerhouse)*.
* Start GoTranscoder with a transcoder configuration, channel name, and job key
        * Run ```./bin/gotranscoder --gotranscoder_config config/localdev_config.json --channel im_test --job_key 0```
* the folder config/ contais the set of configuration. Localdev will point to only staging resources and it's meant for debugging.
* job key is the ID of the job as assigned by USHER when launched and posted into RabbitMQ. It's ok to use zero for local developments

_All parameters for the stream will be downloaded and updated on usher. The address of the usher instance is in the gotranscoder config_


## Deploying
### Deploying to production
Currently gotranscoder is deployed along video/workers to production. This is due to both code having the need to run side by side. In order to deploy, the following steps need to be done:
*
*

### Library Dependencies Beta

Dependencies (like x264, libav, etc) compiled into LibAVTwitch can have mutliple versions. All deps are deployed side by side in `[target]/video_deps/[beta|stable]`

DBOptions are used to toggle between the beta and stable version of the dependencies


* The toggle to use the Beta version of TwitchTranscoder is set via DBOptions.
```JSON
        POST http://usher.twitch.tv/dboption/set BODY: [{"transcoder_beta_ratio": 0.0}]
```




## Monitoring
All monitoring for Gotranscoder is done ia kibana/elastic search. The main dashboard can be found here:

[GoTranscoder Dashboard](http://link.twitch.tv/gotranscoder)

## Alerting
Main alerting for transcode processes is executed via

[video nagios] (https://video-nagios.internal.justin.tv)

Our main alert is done via checking the transcode daemon (/etc/service/hls_t*) is executing on the servers , and not spinning. There are also load, cpu, memory ,and network alerts for the hosts. Any spike in CPU utilization indicates issues in a box.

## Certifications

N/A -
## Authentication

N/A - Gotranscoder does not require Authentication

## Production Checklist (link)
[quicksync transcoder playbook](https://twitchtv.atlassian.net/wiki/display/VID/Quicksync+Transcoder+Playbook)
