package main

import (
	"fmt"
	"log"

	"code.justin.tv/video/gotranscoder/pkg/avdata"
	"code.justin.tv/video/gotranscoder/pkg/usher"
)

// CodecHandler Plugin interface to handle incoming segments
type CodecHandler struct{}

// Name describes this plugin, as as processor tag
func (ch CodecHandler) Name() string {
	return "CodecInfoStreamUpdater"
}

// Initialize the codec handler
func (ch CodecHandler) Initialize() {
	log.Println("[CodecPlugin]  New codec information plugin")
}

// Process an incoming codec info message and post an update to usher on it.
// This populates the broadcast quality tag in the broadcaster dashboard.
// Additionally, video codec channel properties are used by Kraken to filter streams
// given not all platforms can play all stream types.
func (ch CodecHandler) Process(codecInfo interface{}, timeoutCallback <-chan struct{}) error {

	codec, ok := codecInfo.(avdata.Codec)
	if !ok {
		log.Println("Error casting codec info in codec plugin handler")
		return nil
	}

	if codec.Label != "chunked" {
		return nil
	}

	streamUpdate := usher.StreamCodec{
		Channel:   *channel,
		ChannelID: *channelID,
	}

	//Information about Audio only
	if len(codec.AudioCodec) > 0 {
		streamUpdate.SampleRate = codec.SampleRate
		streamUpdate.AudioCodec = codec.AudioCodec
		streamUpdate.Channels = int(codec.Channels)
	}

	// Information about Video Codec only
	if len(codec.VideoCodec) > 0 {
		streamUpdate.VideoCodec = codec.VideoCodec
		streamUpdate.AvcProfile = codec.Profile
		streamUpdate.AvcLevel = fmt.Sprintf("%d", codec.Level)
		streamUpdate.Width = int(codec.Width)
		streamUpdate.Height = int(codec.Height)
		streamUpdate.TargetFps = codec.Fps
		streamUpdate.Vfr = codec.Vfr

		//Update the ProbeResult struct which holds the Video data with the resolution data
		//We use this data to dynamically update the mux data
		if int(codec.Height) > 0 && int(codec.Width) > 0 {
			ProbeResult.ProbeAV.Video.Height = float32(codec.Height)
			ProbeResult.ProbeAV.Video.Width = float32(codec.Width)
		}
	}

	log.Printf("[CodecPlugin]  Posting codec information to usher - for broadcaster stats : %+v\n", streamUpdate)

	err := usherCfg.UpdateStreamProperties(channelPropertyID, &streamUpdate)
	if err != nil {
		log.Printf("Error pushing codec info to usher %s\n", err)
		return err
	}

	return nil

}
