package main

import (
	"os"
	"path"

	"code.justin.tv/video/protocols/common"
)

func newStream(channel, quality string, id int) (*common.Stream, error) {
	host, err := os.Hostname()
	if err != nil {
		return nil, err
	}

	stream := &common.Stream{
		BroadcastId:        []byte(sessionID),
		UsherStreamId:      int64(id),
		Quality:            quality,
		Channel:            channel,
		OriginResourcePath: path.Join(host, transcodesFolder),
	}

	return stream, nil
}
