package main

// TranscodeProfile for audio only encodings
type TranscodeProfile struct {
	Description   string   `json:"description"`
	TranscodeKeys []string `json:"transcode_keys"`
}

// TranscodeQualitySettings for individual quality options
type TranscodeQualitySettings struct {
	Label              string `json:"label"`
	DisplayName        string `json:"display_name"`
	PlaylistPreference int    `json:"playlist_preference"`

	// H264 settings
	Profile         string `json:"profile"`
	Preset          string `json:"preset"`
	CodecString     string `json:"codec_string,omitempty"`
	MaxFps          int32  `json:"max_fps"`
	Height          int32  `json:"height"`
	Bitrate         int32  `json:"bitrate"`
	Muxrate         int32  `json:"muxrate,omitempty"`
	SwsFlags        string `json:"sws_flags,omitempty"`
	AudioBitrate    int32  `json:"audio_bitrate,omitempty"`
	AudioChannels   int32  `json:"audio_channels,omitempty"`
	EncoderThreads  int32  `json:"encoder_threads"`
	LookaheadWindow int32  `json:"lookahead_window,omitempty"`

	// Transcoding settings
	FileBase           string `json:"file_base"`
	Prefix             string `json:"file_name_prefix"`
	OptimizeTs         bool   `json:"optimize_ts"`
	Validate           bool   `json:"validate"`
	PlaylistGeneration bool   `json:"playlist_generation"`
}

// EncodingSettings for the general encoder settings
type EncodingSettings struct {
}

// AudioEncoderSettings for audio only encodings
type AudioEncoderSettings struct {
	Label         string `json:"label"`
	Path          string `json:"file_base"`
	Prefix        string `json:"file_name_prefix"`
	OptimizeTs    bool   `json:"optimize_ts"`
	HlsValidation bool   `json:"validate"`
}

// ThumbnailerSettings for stream thumbnail generation
type ThumbnailerSettings struct {
	Label          string `json:"label"`
	Path           string `json:"file_base"`
	FileNamePrefix string `json:"file_name_prefix"`
	Delay          int32  `json:"delay"`
	Interval       int32  `json:"interval"`
}

// *** Aggregates *** //

// EncoderConfig is an aggregate Struct. This contains the complete encoding config passed to LibAvTwitch
type EncoderConfig struct {
	// This settings have to be passed as top level objects to LibAvTwitch
	Label               string `json:"label"`
	GenerateHlsPlaylist bool   `json:"playlist_generation"`
	HlsValidation       bool   `json:"validate"`
	QualityMetrics      bool   `json:"quality_metrics"`
	EncoderMetrics      bool   `json:"encoder_metrics"`
	SegmentMinDuration  int    `json:"segment_min_duration"`
	SegmentMaxDuration  int    `json:"segment_max_duration"`
	PlaylistWindowSize  int32  `json:"playlist_window_size"`
	RtmpURL             string `json:"rtmp_url"`
	Prefix              string `json:"file_name_prefix"`
	Path                string `json:"file_base"`
	EncoderType         string `json:"encoder_type"`
	Broadcaster         string `json:"broadcaster"`

	Audio      AudioEncoderSettings       `json:"audio_only"`
	Thumbs     ThumbnailerSettings        `json:"thumbnail"`
	Transcodes []TranscodeQualitySettings `json:"transcodes"`
}

// TranscodeProfiles contains the list of available transcode stack profiles
type TranscodeProfiles struct {
	Profiles map[string]TranscodeProfile `json:"transcode_profiles"`
}

// TranscodeQualities contains the list of available transcoding quality settings
type TranscodeQualities struct {
	Qualities map[string]TranscodeQualitySettings `json:"transcode_qualities"`
}
