/*Mock twitch transcoder

Used to aid in testing - echoes whatever is inputed into the process

Usage:

   mocktwitchtranscoder [args]

Test Hooks:

   Force Exit Code: If the channel parameter is set to exitcode , the encoder config param
   can be used to for an exit code
*/
package main

import (
	"fmt"
	"log"
	"os"
	"strconv"
	"strings"

	_ "github.com/aws/aws-sdk-go/service/sts"
	_ "github.com/go-ini/ini"
	_ "github.com/jessevdk/go-flags"
	_ "golang.org/x/crypto/ssh/terminal"
	_ "golang.org/x/net/http2"
)

// This binary is built at the time tests are run from Testmain in ttprocess
// Launch and echo parameters passed into mocktwitchtranscoder
func main() {
	fmt.Println(strings.Join(os.Args[1:], " "))

	// Test hook to simulate an exit code
	if len(os.Args[1:]) >= 5 {

		if os.Args[4] == "exitcode" {
			code, err := strconv.Atoi(os.Args[6])
			if err == nil {
				os.Exit(code)
			}
		}
	}

	l := log.New(os.Stderr, "", 0)
	l.Println("")
}
