job {
	name "video-gotranscoder"
	using 'TEMPLATE-autobuild'

	scm {
		git {
			remote {
				github 'video/gotranscoder', 'ssh', 'git-aws.internal.justin.tv'
					credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'rm -rf .manta_precise/'
		shell 'manta -v -proxy'
		saveDeployArtifact 'video/gotranscoder', '.manta'
	}
	wrappers {
		colorizeOutput()
			credentialsBinding {
				file('COURIERD_PRIVATE_KEY', 'courierd')
					file('AWS_CONFIG_FILE', 'aws_config')
					string 'AWS_ACCESS_KEY_ID', 'core-deploy-artifacts-access-key'
					string 'AWS_SECRET_ACCESS_KEY', 'core-deploy-artifacts-secret-key'
			}
	}
	publishers {
		flexiblePublish {
			conditionalAction {
				condition { alwaysRun() }
				steps {
					reportCodeCoverage('video/gotranscoder', '.manta', '*.out')
				}
			}
		}
		archiveArtifacts('.manta/test_report.xml', 'codecov_coverage.json')
		archiveJunit('.manta/test_report.xml')
	}
}

job {
	name 'video-gotranscoder-deploy'
	using 'TEMPLATE-deploy'

	steps {
		downloadDeployArtifact "video/gotranscoder"
		shell 'courier deploy --repo video/gotranscoder --dir /opt/twitch/gotranscoder --skip-restart'
	}
	wrappers {
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
				string 'AWS_ACCESS_KEY_ID', 'core-deploy-artifacts-access-key'
				string 'AWS_SECRET_ACCESS_KEY', 'core-deploy-artifacts-secret-key'
		}
		colorizeOutput()
	}
}
