package digestion

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

var liveDigestion = Settings{
	BaseURL: "http://digestion.video.justin.tv",
}

var mockDigestion = Settings{
	BaseURL: "http://127.0.0.1:1234",
}

var testChannel = `twitchmedia2`

func TestStreamInfo(t *testing.T) {
	assert := assert.New(t)
	response, err := liveDigestion.StreamInfo(testChannel)
	assert.Nil(err)
	assert.NotNil(response)
	assert.NotEmpty(response)
	assert.Equal(response.Channel, testChannel)
}

func TestNegativeStreamInfo(t *testing.T) {
	assert := assert.New(t)
	response, err := liveDigestion.StreamInfo("")

	assert.NotNil(err)
	assert.Empty(response)

	response, err = mockDigestion.StreamInfo(testChannel)

	assert.NotNil(err)
	assert.Empty(response)
}
