// Package m3u8 tags per the spec definition.
// Utilizing version 3 of the spec
// https://developer.apple.com/library/ios/technotes/tn2288/_index.html
package m3u8

// constants for each M3U8 playlist tags
// TODO: support the remaining tags in the V3 spec
// TODO: support newer versions of the m3u8 playlists
const (
	HeaderFileHdr           = "#EXTM3U\n"
	HeaderVersion           = "#EXT-X-VERSION:3\n"
	HeaderTargetDuration    = "#EXT-X-TARGETDURATION:%d\n"
	HeaderEquivTdtg         = "#ID3-EQUIV-TDTG:%s\n"
	HeaderPlaylistTypeVod   = "#EXT-X-PLAYLIST-TYPE:VOD\n"
	HeaderPlaylistTypeEvent = "#EXT-X-PLAYLIST-TYPE:EVENT\n"
	MarkerSegment           = "#EXTINF:%.3f,\n%s\n"
	MarkerDiscontinuity     = "#EXT-X-DISCONTINUITY\n"
	MarkerPlaylistEnd       = "#EXT-X-ENDLIST\n"
	MarkerMediaSequence     = "#EXT-X-MEDIA-SEQUENCE:%d\n"
	MarkerProgramDateTime   = "#EXT-X-PROGRAM-DATE-TIME:%s\n"

	// Twitch HLS extensions

	// TwitchTotalSeconds Receives the total stream uptime
	TwitchTotalSeconds = "#EXT-X-TWITCH-TOTAL-SECS:%.3f\n"
	// TwitchElapsedSeconds is the total duration of passed chunks
	TwitchElapsedSeconds = "#EXT-X-TWITCH-ELAPSED-SECS:%.3f\n"
	// TwitchMarkerDiscontinuity Receives the lenght of the discontinuity
	TwitchMarkerDiscontinuity = "#EXT-X-TWITCH-DISCONTINUITY\n"
)
