package notify

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/video/gotranscoder/pkg/notify/fakes"
)

var fixture = NotifySettings{
	ChannelID:    322,
	Channel:      "notifications_test",
	StreamID:     123,
	SessionID:    "test-session",
	BroadcastTag: "broadcast-tag",
}

var topicArn = "fake-topic-arn"

func TestStreamReady(t *testing.T) {
	assert := assert.New(t)
	fakeSNS := &fakes.FakeSNSAPI{}
	notifier := Init(fixture.Channel, fixture.ChannelID, fixture.StreamID, fixture.SessionID, fixture.BroadcastTag, topicArn, fakeSNS)
	err := notifier.NotifyStreamReady()
	assert.Nil(err)
	assert.Equal(fakeSNS.PublishCallCount(), 2)
	var oldResult NotifySettings
	var newResult NotificationsMessage

	// first check old integration
	params := fakeSNS.PublishArgsForCall(0)
	msg, subject, topic := *params.Message, *params.Subject, *params.TopicArn
	err = json.Unmarshal([]byte(msg), &oldResult)
	assert.Nil(err)
	assert.Equal(subject, streamReadySubject)
	assert.Equal(topic, streamReadyTopicARN)
	assert.Equal(oldResult.ChannelID, fixture.ChannelID)
	assert.Equal(oldResult.Channel, fixture.Channel)
	assert.Equal(oldResult.StreamID, fixture.StreamID)
	assert.Equal(oldResult.SessionID, fixture.SessionID)
	assert.Equal(oldResult.BroadcastTag, fixture.BroadcastTag)

	// then check new integration
	params = fakeSNS.PublishArgsForCall(1)
	msg, subject, topic = *params.Message, *params.Subject, *params.TopicArn
	err = json.Unmarshal([]byte(msg), &newResult)
	assert.Nil(err)
	assert.Equal(subject, notificationsStreamEventSubject)
	assert.Equal(topic, topicArn)
	assert.Equal(newResult.ChannelID, fixture.ChannelID)
	assert.Equal(newResult.Channel, fixture.Channel)
	assert.Equal(newResult.StreamID, fixture.StreamID)
	assert.Equal(newResult.SessionID, fixture.SessionID)
	assert.Equal(newResult.BroadcastTag, fixture.BroadcastTag)
	assert.Equal(newResult.Event, notificationsStreamReadyEvent)
}

func TestStreamDown(t *testing.T) {
	assert := assert.New(t)
	fakeSNS := &fakes.FakeSNSAPI{}
	notifier := Init(fixture.Channel, fixture.ChannelID, fixture.StreamID, fixture.SessionID, fixture.BroadcastTag, topicArn, fakeSNS)
	err := notifier.NotifyStreamDown()
	assert.Nil(err)
	assert.Equal(fakeSNS.PublishCallCount(), 2)
	var oldResult NotifySettings
	var newResult NotificationsMessage

	// first check old integration
	params := fakeSNS.PublishArgsForCall(0)
	msg, subject, topic := *params.Message, *params.Subject, *params.TopicArn
	err = json.Unmarshal([]byte(msg), &oldResult)
	assert.Nil(err)
	assert.Equal(subject, streamDownSubject)
	assert.Equal(topic, streamDownTopicARN)
	assert.Equal(oldResult.ChannelID, fixture.ChannelID)
	assert.Equal(oldResult.Channel, fixture.Channel)
	assert.Equal(oldResult.StreamID, fixture.StreamID)
	assert.Equal(oldResult.SessionID, fixture.SessionID)
	assert.Equal(oldResult.BroadcastTag, fixture.BroadcastTag)

	// then check new integration
	params = fakeSNS.PublishArgsForCall(1)
	msg, subject, topic = *params.Message, *params.Subject, *params.TopicArn
	err = json.Unmarshal([]byte(msg), &newResult)
	assert.Nil(err)
	assert.Equal(subject, notificationsStreamEventSubject)
	assert.Equal(topic, topicArn)
	assert.Equal(newResult.ChannelID, fixture.ChannelID)
	assert.Equal(newResult.Channel, fixture.Channel)
	assert.Equal(newResult.StreamID, fixture.StreamID)
	assert.Equal(newResult.SessionID, fixture.SessionID)
	assert.Equal(newResult.BroadcastTag, fixture.BroadcastTag)
	assert.Equal(newResult.Event, notificationsStreamDownEvent)
}
