package util

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

// Test MDS5 hashing does return a base 10 big integer
func TestMD5Hashing(t *testing.T) {
	assert := assert.New(t)

	var tests = []struct {
		text         string
		expectedHash string
	}{
		{"", "281949768489412648962353822266799178366"},
		{"A", "169836834567204038179966570894283554345"},
		{"TEST", "4298436732392476415310423737386284479"},
		{"123456123456", "311414969766531460844422556050951003284"},
	}

	for _, test := range tests {
		assert.Equal(GetBase10MD5Hash(test.text), test.expectedHash)
	}
}

// Hash multiple times to check the hashing is consistent
func TestConsistentHash(t *testing.T) {
	assert := assert.New(t)

	assert.Equal(ConsistentHash("shouldbeconsistent", 1000), 0.144)
	assert.Equal(ConsistentHash("shouldbeconsistent", 1000), 0.144)
	assert.Equal(ConsistentHash("shouldbeconsistent", 1000), 0.144)
}

// Hash multiple times to check the hashing is consistent
func TestConsistentHashModulusResolution(t *testing.T) {
	assert := assert.New(t)

	assert.Equal(ConsistentHash("shouldbeconsistent", 10), 0.4)
	assert.Equal(ConsistentHash("shouldbeconsistent", 100), 0.44)
	assert.Equal(ConsistentHash("shouldbeconsistent", 10000), 0.8144)
}
