package vod

import (
	"bytes"

	"fmt"

	"code.justin.tv/video/gotranscoder/pkg/usher"
)

//Manifest related constants

const (
	manifestHeader       = "#EXTM3U"
	renditionData        = "#EXT-X-MEDIA:TYPE=%s,GROUP-ID=\"%s\",NAME=\"%s\",AUTOSELECT=%s,DEFAULT=YES"
	variantData          = "#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=%d,CODECS=\"%s\",RESOLUTION=\"%s\",VIDEO=\"%s\""
	YES                  = "YES"
	NO                   = "NO"
	PLAYLIST_NAME        = "index-dvr.m3u8"
	PLAYLIST_PATH_FORMAT = "%s/%s/%s/%s"
	RESOLUTION_FORMAT    = "%dx%d"
	AUDIO_MEDIA_TYPE     = "AUDIO"
	VIDEO_MEDIA_TYPE     = "VIDEO"
	AUDIO_ONLY_FORMAT    = "audio_only"
)

func GenerateVODManifest(muxData []usher.MuxInfo, distributionBaseUrl string, pathPrefix string) []byte {
	var buffer bytes.Buffer
	//Write Header
	buffer.WriteString(manifestHeader)
	//Iterate through all the renditions and write the manifest
	for _, muxInfo := range muxData {
		buffer.WriteString("\n")
		mediaType := VIDEO_MEDIA_TYPE
		autoSelectTag := YES
		if muxInfo.GroupID == AUDIO_ONLY_FORMAT {
			mediaType = AUDIO_MEDIA_TYPE
			autoSelectTag = NO
		}
		renditonData := fmt.Sprintf(renditionData, mediaType, muxInfo.GroupID, muxInfo.DisplayLabel, autoSelectTag)
		buffer.WriteString(renditonData)
		buffer.WriteString("\n")
		variantPlaylistData := fmt.Sprintf(variantData, muxInfo.MuxRate, muxInfo.Codecs,
			fmt.Sprintf(RESOLUTION_FORMAT, muxInfo.VideoWidth, muxInfo.VideoHeight), muxInfo.GroupID)
		buffer.WriteString(variantPlaylistData)
		buffer.WriteString("\n")
		//Write URL for variant playlist
		buffer.WriteString(fmt.Sprintf(PLAYLIST_PATH_FORMAT, distributionBaseUrl, pathPrefix, muxInfo.GroupID, PLAYLIST_NAME))
	}

	return buffer.Bytes()
}
