#!/bin/bash

SRCDIRS=$(go list ./... | grep -v /vendor/)

set -e
set -o pipefail

OUT=$1
if [ ! -d "$OUT" ]; then
  mkdir "$OUT"
fi

test_path=${OUT}/test_results
coverage_path=${test_path}/coverage
results_path=${test_path}/results

mkdir -p ${coverage_path}
mkdir -p ${results_path}

exitCode=0
for pkg in $SRCDIRS; do
  echo "Testing and generating coverage for: ${pkg}"
  pkg_name=${pkg//\//_}
  coverage_filename=${coverage_path}/${pkg_name}.out
  report_filename=${results_path}/${pkg_name}.xml
  set +e
  go test -race -coverprofile=${coverage_filename} ${pkg} -v | go-junit-report -set-exit-code > ${report_filename}
  ret=$?
  if [[ "$ret" -ne "0" ]]; then
	echo "We failed for pkg=\"${pkg}\" - return code=${ret}"
	exitCode=1
  fi
  set -e
  if [[ -f ${coverage_filename} ]]; then
    go tool cover -func=${coverage_filename}
  fi
done
mv gotranscoder_test_result.xml ${report_filename}

retool do twerk get-tests ${test_path} --output ${OUT}

exit $exitCode
