package httpserver

import (
	"net/http"
)

func InternalServerError(err error) *HTTPError {
	return &HTTPError{
		Code:    http.StatusInternalServerError,
		Err:     "InternalServerError",
		Message: "There was an error processing the request",
		Cause:   err.Error(),
	}
}

func Unauthorized() *HTTPError {
	return &HTTPError{
		Code:    http.StatusUnauthorized,
		Err:     "Unauthorized",
		Message: "The request could not be authorized",
	}
}

func BadRequest(msg string) *HTTPError {
	return &HTTPError{
		Code:    http.StatusBadRequest,
		Err:     "BadRequest",
		Message: msg,
	}
}

func NotFound(msg string) *HTTPError {
	return &HTTPError{
		Code:    http.StatusNotFound,
		Err:     "NotFound",
		Message: msg,
	}
}
