package httpserver

import (
	"net/http"
	"time"
)

type loggingResponseWriter struct {
	http.ResponseWriter
	statusCode int
}

func newLoggingResponseWriter(w http.ResponseWriter) *loggingResponseWriter {
	return &loggingResponseWriter{w, http.StatusOK}
}

func (lrw *loggingResponseWriter) WriteHeader(code int) {
	lrw.statusCode = code
	lrw.ResponseWriter.WriteHeader(code)
}

func RequestLog(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		startTime := time.Now()
		lrw := newLoggingResponseWriter(w)
		h.ServeHTTP(lrw, r)
		endTime := time.Now()
		query := ""
		if len(r.URL.RawQuery) > 0 {
			query = "?" + r.URL.RawQuery
		}
		logger.Infof("HTTP Request; %v %v%v, status=%v, duration=%v",
			r.Method, r.URL.Path, query, lrw.statusCode, endTime.Sub(startTime))
	})
}
