package httpserver

import (
	"net/http"
)

var DefaultRequestSizeLimiter = RequestSizeLimiter{1 << 16}.Handler

type RequestSizeLimiter struct {
	Limit int64
}

func (rsl RequestSizeLimiter) Handler(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		r.Body = http.MaxBytesReader(w, r.Body, rsl.Limit)
		h.ServeHTTP(w, r)
	})
}
