package api

import (
	"os"

	"code.justin.tv/vodsvc/aws/awsconfig"
	"code.justin.tv/vodsvc/aws/cloudwatch"
	"code.justin.tv/vodsvc/aws/s3"
	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/hls"
	"code.justin.tv/vodsvc/vhs/src/transcode"

	log "go.uber.org/zap"
)

type API struct {
	uploadTable  dynamodb.UploadTable
	videoTable   dynamodb.VideoTable
	uploadBucket s3.S3
	videoBucket  s3.S3
	cloudwatch   cloudwatch.CloudWatch
	logger       *log.SugaredLogger
	transcoder   transcode.Transcoder
	hls          *hls.HLS
}

func New() *API {
	logger := httpserver.DefaultLogger().Sugar()
	awsconfig.SetLogger(logger.Debug)
	videoBucket := os.Getenv("VIDEO_BUCKET")
	videoTable := os.Getenv("VIDEO_TABLE")
	uploadBucket := os.Getenv("UPLOAD_BUCKET")
	uploadTable := os.Getenv("UPLOAD_TABLE")
	jobDefinition := os.Getenv("TRANSCODE_JOB_DEFINITION")
	jobQueue := os.Getenv("TRANSCODE_JOB_QUEUE")
	cloudFrontDomain := os.Getenv("CLOUDFRONT_DOMAIN")
	hls, err := hls.New(hls.Config{CloudFrontDomain: cloudFrontDomain})
	if err != nil {
		panic(err) // FIXME
	}

	api := &API{
		logger:       logger,
		cloudwatch:   cloudwatch.New(logger),
		uploadTable:  dynamodb.New(uploadTable, logger),
		videoTable:   dynamodb.New(videoTable, logger),
		uploadBucket: s3.New(uploadBucket),
		videoBucket:  s3.New(videoBucket),
		transcoder:   transcode.New(jobQueue, jobDefinition, logger),
		hls:          hls,
	}
	return api
}
