package api

import (
	"context"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-lambda-go/events"
)

func (a *API) CompleteUpload(ctx context.Context, e events.S3Event) {
	for _, r := range e.Records {
		uploadId := r.S3.Object.Key[0:36]
		uploadTable := a.uploadTable.TableName()

		u, err := a.uploadTable.GetUpload(uploadId)
		if err != nil {
			a.logger.Errorw("Cannot retrieve upload from DynamoDB",
				"id", uploadId, "uploadTable", uploadTable, "err", err)
			return
		}
		if u.Id == "" {
			a.logger.Errorw("UploadId not found",
				"id", uploadId, "uploadTable", uploadTable)
			return
		}

		if u.Status != types.StatusCreated {
			a.logger.Warnw("Upload has already started processing",
				"id", uploadId, "uploadTable", uploadTable)
			return
		}

		if err := a.transcoder.StartTranscode(uploadId, uploadTable); err != nil {
			a.logger.Errorw("Error starting transcode job",
				"id", uploadId, "uploadTable", uploadTable, "err", err)
			if err := a.uploadTable.SetFailed(uploadId, types.ErrInternalFailure); err != nil {
				a.logger.Errorw("Error setting upload status",
					"id", uploadId, "uploadTable", uploadTable, "err", err)
				return
			}
		}

		if err := a.uploadTable.SetStatus(uploadId, types.StatusPendingTranscode); err != nil {
			a.logger.Errorw("Error setting upload status",
				"id", uploadId, "uploadTable", uploadTable, "err", err)
		}
	}
}
