package api

import (
	"errors"
	"net/http"

	"code.justin.tv/vodsvc/httpserver"
)

func (a *API) DeleteVideo(r *http.Request, params map[string]string) (interface{}, *httpserver.HTTPError) {
	id, ok := params["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	err := a.videoTable.DeleteVideo(id)
	if err != nil {
		return nil, httpserver.InternalServerError(errors.New("unable to delete video record"))
	}

	return nil, nil
}
