package api

import (
	"context"
	"net/http"
	"strings"

	"github.com/aws/aws-lambda-go/events"
)

// GetManifest generate the master manifest for a video
func (a *API) GetManifest(c context.Context, r events.APIGatewayProxyRequest) (events.APIGatewayProxyResponse, error) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return respondError(http.StatusBadRequest)
	}

	id = strings.TrimSuffix(id, ".m3u8")

	video, err := a.videoTable.GetVideo(id)
	if err != nil {
		return respondError(http.StatusInternalServerError)
	}
	if video.Id == "" {
		return respondError(http.StatusNotFound)
	}

	manifest, err := a.hls.WriteMasterManifest(video)
	if err != nil {
		return respondError(http.StatusInternalServerError)
	}

	response := events.APIGatewayProxyResponse{
		StatusCode: http.StatusOK,
		Headers:    map[string]string{"Content-Type": "application/vnd.apple.mpegurl"},
		Body:       manifest,
	}
	return response, nil
}

func respondError(code int) (events.APIGatewayProxyResponse, error) {
	return events.APIGatewayProxyResponse{Body: http.StatusText(code), StatusCode: code}, nil
}
