package api

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-lambda-go/events"
)

func (a *API) GetUpload(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	return a.getUpload(id)
}

func (a *API) getUpload(id string) (types.Upload, *httpserver.HTTPError) {
	upload, err := a.uploadTable.GetUpload(id)
	if err != nil {
		return upload, httpserver.InternalServerError(err)
	}

	if upload.Id == "" {
		return upload, httpserver.NotFound("Upload not found: id=" + id)
	}

	return upload, nil
}
