package api

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-lambda-go/events"
)

func (a *API) GetVideo(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	return a.getVideo(id)
}

func (a *API) getVideo(id string) (types.Video, *httpserver.HTTPError) {
	video, err := a.videoTable.GetVideo(id)
	if err != nil {
		return video, httpserver.InternalServerError(err)
	}

	if video.Id == "" {
		return video, httpserver.NotFound("Video not found: id=" + id)
	}

	return video, nil
}
