package api

import (
	"net/http"

	"code.justin.tv/vodsvc/httpserver"
	"github.com/satori/go.uuid"
)

const sourceFile = "source"

func generateVideoId() string {
	return uuid.NewV4().String()
}

func generateS3Prefix(id string) string {
	return id + "/" + uuid.NewV4().String()
}

func sourceKey(s3Prefix string) string {
	return s3Prefix + "/" + sourceFile
}

func s3URI(bucket, key string) string {
	return "s3://" + bucket + "/" + key
}

func authorizeUpload(r *http.Request, uploadToken string) *httpserver.HTTPError {
	authorization := r.Header.Get("Authorization")
	if authorization[0:6] != "Bearer" && authorization[0:6] != "bearer" {
		return httpserver.Unauthorized()
	}

	if uploadToken == "" || uploadToken != authorization[7:] {
		return httpserver.Unauthorized()
	}

	return nil
}
