package api

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-lambda-go/events"
)

type ListUploadsResponse struct {
	Uploads         []types.Upload `json:"uploads"`
	PaginationToken string         `json:"paginationToken"`
	Count           int            `json:"count"`
}

func (a *API) ListUploads(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	paginationToken := r.QueryStringParameters["paginationToken"]

	uploads, lastKey, err := a.uploadTable.ListUploads(paginationToken)
	if err != nil {
		return nil, httpserver.InternalServerError(err)
	}

	return &ListUploadsResponse{Uploads: uploads, PaginationToken: lastKey, Count: len(uploads)}, nil
}
