package api

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-lambda-go/events"
)

type ListVideosResponse struct {
	Videos          []*types.Video `json:"videos"`
	PaginationToken string         `json:"paginationToken"`
	Count           int            `json:"count"`
}

func (a *API) ListVideos(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	paginationToken := r.QueryStringParameters["paginationToken"]

	videos, lastKey, err := a.videoTable.ListVideos(paginationToken)
	if err != nil {
		return nil, httpserver.InternalServerError(err)
	}

	return &ListVideosResponse{Videos: videos, PaginationToken: lastKey, Count: len(videos)}, nil
}
