package dynamodb

import (
	"strconv"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (d *ddb) AddEtag(id string, part int, etag string, size int) error {
	input := &dynamodb.UpdateItemInput{
		TableName:        aws.String(d.table),
		Key:              map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		UpdateExpression: aws.String("SET ETags.#part = :ETag, #status = :Status, LastUpdated = :Time ADD #size :Size"),
		ExpressionAttributeValues: map[string]*dynamodb.AttributeValue{
			":ETag":   {S: aws.String(etag)},
			":Status": {S: aws.String(types.StatusUploading)},
			":Time":   {S: aws.String(now3339())},
			":Size":   {N: aws.String(strconv.Itoa(size))},
		},
		ExpressionAttributeNames: map[string]*string{
			"#status": aws.String("Status"),
			"#part":   aws.String(strconv.Itoa(part)),
			"#size":   aws.String("Size"),
		},
	}

	_, err := d.client.UpdateItem(input)
	return err
}
