package dynamodb

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (d *ddb) DeleteVideo(id string) error {
	input := &dynamodb.DeleteItemInput{
		TableName: aws.String(d.table),
		Key:       map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
	}

	_, err := d.client.DeleteItem(input)
	if err != nil {
		return err
	}

	return nil
}
