package dynamodb

import (
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) GetUpload(id string) (types.Upload, error) {
	input := &dynamodb.GetItemInput{
		TableName:      aws.String(d.table),
		Key:            map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		ConsistentRead: aws.Bool(true),
	}

	upload := types.Upload{}
	out, err := d.client.GetItem(input)
	if err != nil {
		return upload, err
	}

	if err := dynamodbattribute.UnmarshalMap(out.Item, &upload); err != nil {
		return upload, err
	}

	return upload, nil
}
