package dynamodb

import (
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) GetVideo(id string) (types.Video, error) {
	input := &dynamodb.GetItemInput{
		TableName:      aws.String(d.table),
		Key:            map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		ConsistentRead: aws.Bool(true),
	}

	video := types.Video{}
	out, err := d.client.GetItem(input)
	if err != nil {
		return video, err
	}

	if err := dynamodbattribute.UnmarshalMap(out.Item, &video); err != nil {
		return video, err
	}

	return video, nil
}
