package dynamodb

import (
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) ListUploads(startKey string) ([]types.Upload, string, error) {
	input := &dynamodb.ScanInput{
		TableName: aws.String(d.table),
		Limit:     aws.Int64(ScanLimit),
	}

	if len(startKey) > 0 {
		input.ExclusiveStartKey = map[string]*dynamodb.AttributeValue{
			"Id": {S: aws.String(startKey)},
		}
	}

	out, err := d.client.Scan(input)
	if err != nil {
		return []types.Upload{}, "", err
	}

	uploads := []types.Upload{}

	if err := dynamodbattribute.UnmarshalListOfMaps(out.Items, &uploads); err != nil {
		return []types.Upload{}, "", err
	}

	lastEvaluatedKey, ok := out.LastEvaluatedKey["Id"]
	if !ok {
		return uploads, "", nil
	}

	return uploads, *lastEvaluatedKey.S, nil
}
