package transcode

import (
	"code.justin.tv/vodsvc/aws/awsconfig"
	sts "code.justin.tv/vodsvc/sts/src/transcoder"
	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/service/batch"
	log "go.uber.org/zap"
)

// Transcoder interface for submitting a transcoding request
type Transcoder interface {
	StartTranscode(uploadId, uploadTable string) error
	ParseManifest(video types.Video, manifest sts.Video) types.Video
}

type transcoder struct {
	batch         *batch.Batch
	logger        *log.SugaredLogger
	jobQueue      string
	jobDefinition string
}

// New instantiate a transcoder client object
func New(jobQueue, jobDefinition string, logger *log.SugaredLogger) Transcoder {
	return &transcoder{
		batch:         batch.New(awsconfig.Session),
		logger:        logger,
		jobQueue:      jobQueue,
		jobDefinition: jobDefinition,
	}
}
