package transcode

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/batch"
)

// InitiateTranscode submits a transcode batch job
func (t *transcoder) StartTranscode(uploadId, uploadTable string) error {
	jobInput := &batch.SubmitJobInput{
		JobDefinition: aws.String(t.jobDefinition),
		JobQueue:      aws.String(t.jobQueue),
		JobName:       aws.String(uploadId),
		Parameters: map[string]*string{
			"UploadId":    aws.String(uploadId),
			"UploadTable": aws.String(uploadTable),
		},
	}

	jobOutput, err := t.batch.SubmitJob(jobInput)
	if err != nil {
		return fmt.Errorf("Error submitting Batch job: " + err.Error())
	}

	t.logger.Infof("Submitted Transcoder Job request; uploadId=%v, jobId=%v, jobName=%v",
		uploadId, *jobOutput.JobId, *jobOutput.JobName)

	return nil
}
