package types

import (
	"time"
)

const (
	StatusCreated          = "created"
	StatusUploading        = "uploading"
	StatusPendingTranscode = "pendingTranscode"
	StatusTranscoding      = "transcoding"
	StatusFailed           = "failed"
	StatusProcessed        = "processed"
	StatusCancelled        = "cancelled"
)

const (
	TypeUpload = "upload"
)

const (
	ErrInternalFailure = "INTERNAL_FAILURE"
)

type Upload struct {
	Id            string      `json:"id" dynamodbav:"Id"`
	S3Bucket      string      `json:"s3Bucket" dynamodbav:"S3Bucket"`
	S3Prefix      string      `json:"s3Prefix" dynamodbav:"S3Prefix"`
	VideoBucket   string      `json:"-" dynamodbav:"VideoBucket"`
	Size          int         `json:"size" dynamodbav:"Size"`
	Status        string      `json:"status" dynamodbav:"Status"`
	FailureReason string      `json:"failureReason,omitempty" dynamodbav:"FailureReason"`
	StatusTimes   StatusTimes `json:"statusTimes" dynamodbav:"StatusTimes"`
	LastUpdated   time.Time   `json:"-" dynamodbav:"LastUpdated"`
	SourceFile    string      `json:"-" dynamodbav:"SourceFile"`
	Video         *Video      `json:"-" dynamodbav:"-"`
}

type Video struct {
	CreateTime      time.Time   `json:"createTime" dynamodbav:"CreateTime"`
	Duration        int         `json:"duration" dynamodbav:"Duration"`
	Id              string      `json:"id" dynamodbav:"Id"`
	PendingDeletion bool        `json:"pendingDeletion" dynamodbav:"PendingDeletion"`
	S3Bucket        string      `json:"s3Bucket" dynamodbav:"S3Bucket"`
	S3Prefix        string      `json:"s3Prefix" dynamodbav:"S3Prefix"`
	VideoType       string      `json:"videoType" dynamodbav:"VideoType"`
	Renditions      []Rendition `json:"renditions" dynamodbav:"Renditions"`
	Thumbnails      []Thumbnail `json:"thumbnails" dynamodbav:"Thumbnails"`
}

type Rendition struct {
	AudioCodec string `json:"audioCodec" dynamodbav:"AudioCodec"`
	VideoCodec string `json:"videoCodec" dynamodbav:"VideoCodec"`
	Bitrate    int32  `json:"bitrate" dynamodbav:"Bitrate"`
	Height     int32  `json:"height" dynamodbav:"Height"`
	Width      int32  `json:"width" dynamodbav:"Width"`
	FPS        string `json:"fps" dynamodbav:"FPS"`
	Label      string `json:"label" dynamodbav:"Label"`
	Manifest   string `json:"manifest" dynamodbav:"Manifest"`
}

type Thumbnail struct {
	Path   string  `json:"path" dynamodbav:"Path"`
	Offset float64 `json:"offset" dynamodbav:"Offset"`
}

type StatusTimes map[string]time.Time
