// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package alexaforbusinessiface provides an interface to enable mocking the Alexa For Business service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package alexaforbusinessiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/alexaforbusiness"
)

// AlexaForBusinessAPI provides an interface to enable mocking the
// alexaforbusiness.AlexaForBusiness service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Alexa For Business.
//    func myFunc(svc alexaforbusinessiface.AlexaForBusinessAPI) bool {
//        // Make svc.AssociateDeviceWithRoom request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := alexaforbusiness.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAlexaForBusinessClient struct {
//        alexaforbusinessiface.AlexaForBusinessAPI
//    }
//    func (m *mockAlexaForBusinessClient) AssociateDeviceWithRoom(input *alexaforbusiness.AssociateDeviceWithRoomInput) (*alexaforbusiness.AssociateDeviceWithRoomOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAlexaForBusinessClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AlexaForBusinessAPI interface {
	AssociateDeviceWithRoom(*alexaforbusiness.AssociateDeviceWithRoomInput) (*alexaforbusiness.AssociateDeviceWithRoomOutput, error)
	AssociateDeviceWithRoomWithContext(aws.Context, *alexaforbusiness.AssociateDeviceWithRoomInput, ...request.Option) (*alexaforbusiness.AssociateDeviceWithRoomOutput, error)
	AssociateDeviceWithRoomRequest(*alexaforbusiness.AssociateDeviceWithRoomInput) (*request.Request, *alexaforbusiness.AssociateDeviceWithRoomOutput)

	AssociateSkillGroupWithRoom(*alexaforbusiness.AssociateSkillGroupWithRoomInput) (*alexaforbusiness.AssociateSkillGroupWithRoomOutput, error)
	AssociateSkillGroupWithRoomWithContext(aws.Context, *alexaforbusiness.AssociateSkillGroupWithRoomInput, ...request.Option) (*alexaforbusiness.AssociateSkillGroupWithRoomOutput, error)
	AssociateSkillGroupWithRoomRequest(*alexaforbusiness.AssociateSkillGroupWithRoomInput) (*request.Request, *alexaforbusiness.AssociateSkillGroupWithRoomOutput)

	CreateProfile(*alexaforbusiness.CreateProfileInput) (*alexaforbusiness.CreateProfileOutput, error)
	CreateProfileWithContext(aws.Context, *alexaforbusiness.CreateProfileInput, ...request.Option) (*alexaforbusiness.CreateProfileOutput, error)
	CreateProfileRequest(*alexaforbusiness.CreateProfileInput) (*request.Request, *alexaforbusiness.CreateProfileOutput)

	CreateRoom(*alexaforbusiness.CreateRoomInput) (*alexaforbusiness.CreateRoomOutput, error)
	CreateRoomWithContext(aws.Context, *alexaforbusiness.CreateRoomInput, ...request.Option) (*alexaforbusiness.CreateRoomOutput, error)
	CreateRoomRequest(*alexaforbusiness.CreateRoomInput) (*request.Request, *alexaforbusiness.CreateRoomOutput)

	CreateSkillGroup(*alexaforbusiness.CreateSkillGroupInput) (*alexaforbusiness.CreateSkillGroupOutput, error)
	CreateSkillGroupWithContext(aws.Context, *alexaforbusiness.CreateSkillGroupInput, ...request.Option) (*alexaforbusiness.CreateSkillGroupOutput, error)
	CreateSkillGroupRequest(*alexaforbusiness.CreateSkillGroupInput) (*request.Request, *alexaforbusiness.CreateSkillGroupOutput)

	CreateUser(*alexaforbusiness.CreateUserInput) (*alexaforbusiness.CreateUserOutput, error)
	CreateUserWithContext(aws.Context, *alexaforbusiness.CreateUserInput, ...request.Option) (*alexaforbusiness.CreateUserOutput, error)
	CreateUserRequest(*alexaforbusiness.CreateUserInput) (*request.Request, *alexaforbusiness.CreateUserOutput)

	DeleteProfile(*alexaforbusiness.DeleteProfileInput) (*alexaforbusiness.DeleteProfileOutput, error)
	DeleteProfileWithContext(aws.Context, *alexaforbusiness.DeleteProfileInput, ...request.Option) (*alexaforbusiness.DeleteProfileOutput, error)
	DeleteProfileRequest(*alexaforbusiness.DeleteProfileInput) (*request.Request, *alexaforbusiness.DeleteProfileOutput)

	DeleteRoom(*alexaforbusiness.DeleteRoomInput) (*alexaforbusiness.DeleteRoomOutput, error)
	DeleteRoomWithContext(aws.Context, *alexaforbusiness.DeleteRoomInput, ...request.Option) (*alexaforbusiness.DeleteRoomOutput, error)
	DeleteRoomRequest(*alexaforbusiness.DeleteRoomInput) (*request.Request, *alexaforbusiness.DeleteRoomOutput)

	DeleteRoomSkillParameter(*alexaforbusiness.DeleteRoomSkillParameterInput) (*alexaforbusiness.DeleteRoomSkillParameterOutput, error)
	DeleteRoomSkillParameterWithContext(aws.Context, *alexaforbusiness.DeleteRoomSkillParameterInput, ...request.Option) (*alexaforbusiness.DeleteRoomSkillParameterOutput, error)
	DeleteRoomSkillParameterRequest(*alexaforbusiness.DeleteRoomSkillParameterInput) (*request.Request, *alexaforbusiness.DeleteRoomSkillParameterOutput)

	DeleteSkillGroup(*alexaforbusiness.DeleteSkillGroupInput) (*alexaforbusiness.DeleteSkillGroupOutput, error)
	DeleteSkillGroupWithContext(aws.Context, *alexaforbusiness.DeleteSkillGroupInput, ...request.Option) (*alexaforbusiness.DeleteSkillGroupOutput, error)
	DeleteSkillGroupRequest(*alexaforbusiness.DeleteSkillGroupInput) (*request.Request, *alexaforbusiness.DeleteSkillGroupOutput)

	DeleteUser(*alexaforbusiness.DeleteUserInput) (*alexaforbusiness.DeleteUserOutput, error)
	DeleteUserWithContext(aws.Context, *alexaforbusiness.DeleteUserInput, ...request.Option) (*alexaforbusiness.DeleteUserOutput, error)
	DeleteUserRequest(*alexaforbusiness.DeleteUserInput) (*request.Request, *alexaforbusiness.DeleteUserOutput)

	DisassociateDeviceFromRoom(*alexaforbusiness.DisassociateDeviceFromRoomInput) (*alexaforbusiness.DisassociateDeviceFromRoomOutput, error)
	DisassociateDeviceFromRoomWithContext(aws.Context, *alexaforbusiness.DisassociateDeviceFromRoomInput, ...request.Option) (*alexaforbusiness.DisassociateDeviceFromRoomOutput, error)
	DisassociateDeviceFromRoomRequest(*alexaforbusiness.DisassociateDeviceFromRoomInput) (*request.Request, *alexaforbusiness.DisassociateDeviceFromRoomOutput)

	DisassociateSkillGroupFromRoom(*alexaforbusiness.DisassociateSkillGroupFromRoomInput) (*alexaforbusiness.DisassociateSkillGroupFromRoomOutput, error)
	DisassociateSkillGroupFromRoomWithContext(aws.Context, *alexaforbusiness.DisassociateSkillGroupFromRoomInput, ...request.Option) (*alexaforbusiness.DisassociateSkillGroupFromRoomOutput, error)
	DisassociateSkillGroupFromRoomRequest(*alexaforbusiness.DisassociateSkillGroupFromRoomInput) (*request.Request, *alexaforbusiness.DisassociateSkillGroupFromRoomOutput)

	GetDevice(*alexaforbusiness.GetDeviceInput) (*alexaforbusiness.GetDeviceOutput, error)
	GetDeviceWithContext(aws.Context, *alexaforbusiness.GetDeviceInput, ...request.Option) (*alexaforbusiness.GetDeviceOutput, error)
	GetDeviceRequest(*alexaforbusiness.GetDeviceInput) (*request.Request, *alexaforbusiness.GetDeviceOutput)

	GetProfile(*alexaforbusiness.GetProfileInput) (*alexaforbusiness.GetProfileOutput, error)
	GetProfileWithContext(aws.Context, *alexaforbusiness.GetProfileInput, ...request.Option) (*alexaforbusiness.GetProfileOutput, error)
	GetProfileRequest(*alexaforbusiness.GetProfileInput) (*request.Request, *alexaforbusiness.GetProfileOutput)

	GetRoom(*alexaforbusiness.GetRoomInput) (*alexaforbusiness.GetRoomOutput, error)
	GetRoomWithContext(aws.Context, *alexaforbusiness.GetRoomInput, ...request.Option) (*alexaforbusiness.GetRoomOutput, error)
	GetRoomRequest(*alexaforbusiness.GetRoomInput) (*request.Request, *alexaforbusiness.GetRoomOutput)

	GetRoomSkillParameter(*alexaforbusiness.GetRoomSkillParameterInput) (*alexaforbusiness.GetRoomSkillParameterOutput, error)
	GetRoomSkillParameterWithContext(aws.Context, *alexaforbusiness.GetRoomSkillParameterInput, ...request.Option) (*alexaforbusiness.GetRoomSkillParameterOutput, error)
	GetRoomSkillParameterRequest(*alexaforbusiness.GetRoomSkillParameterInput) (*request.Request, *alexaforbusiness.GetRoomSkillParameterOutput)

	GetSkillGroup(*alexaforbusiness.GetSkillGroupInput) (*alexaforbusiness.GetSkillGroupOutput, error)
	GetSkillGroupWithContext(aws.Context, *alexaforbusiness.GetSkillGroupInput, ...request.Option) (*alexaforbusiness.GetSkillGroupOutput, error)
	GetSkillGroupRequest(*alexaforbusiness.GetSkillGroupInput) (*request.Request, *alexaforbusiness.GetSkillGroupOutput)

	ListSkills(*alexaforbusiness.ListSkillsInput) (*alexaforbusiness.ListSkillsOutput, error)
	ListSkillsWithContext(aws.Context, *alexaforbusiness.ListSkillsInput, ...request.Option) (*alexaforbusiness.ListSkillsOutput, error)
	ListSkillsRequest(*alexaforbusiness.ListSkillsInput) (*request.Request, *alexaforbusiness.ListSkillsOutput)

	ListSkillsPages(*alexaforbusiness.ListSkillsInput, func(*alexaforbusiness.ListSkillsOutput, bool) bool) error
	ListSkillsPagesWithContext(aws.Context, *alexaforbusiness.ListSkillsInput, func(*alexaforbusiness.ListSkillsOutput, bool) bool, ...request.Option) error

	ListTags(*alexaforbusiness.ListTagsInput) (*alexaforbusiness.ListTagsOutput, error)
	ListTagsWithContext(aws.Context, *alexaforbusiness.ListTagsInput, ...request.Option) (*alexaforbusiness.ListTagsOutput, error)
	ListTagsRequest(*alexaforbusiness.ListTagsInput) (*request.Request, *alexaforbusiness.ListTagsOutput)

	ListTagsPages(*alexaforbusiness.ListTagsInput, func(*alexaforbusiness.ListTagsOutput, bool) bool) error
	ListTagsPagesWithContext(aws.Context, *alexaforbusiness.ListTagsInput, func(*alexaforbusiness.ListTagsOutput, bool) bool, ...request.Option) error

	PutRoomSkillParameter(*alexaforbusiness.PutRoomSkillParameterInput) (*alexaforbusiness.PutRoomSkillParameterOutput, error)
	PutRoomSkillParameterWithContext(aws.Context, *alexaforbusiness.PutRoomSkillParameterInput, ...request.Option) (*alexaforbusiness.PutRoomSkillParameterOutput, error)
	PutRoomSkillParameterRequest(*alexaforbusiness.PutRoomSkillParameterInput) (*request.Request, *alexaforbusiness.PutRoomSkillParameterOutput)

	ResolveRoom(*alexaforbusiness.ResolveRoomInput) (*alexaforbusiness.ResolveRoomOutput, error)
	ResolveRoomWithContext(aws.Context, *alexaforbusiness.ResolveRoomInput, ...request.Option) (*alexaforbusiness.ResolveRoomOutput, error)
	ResolveRoomRequest(*alexaforbusiness.ResolveRoomInput) (*request.Request, *alexaforbusiness.ResolveRoomOutput)

	RevokeInvitation(*alexaforbusiness.RevokeInvitationInput) (*alexaforbusiness.RevokeInvitationOutput, error)
	RevokeInvitationWithContext(aws.Context, *alexaforbusiness.RevokeInvitationInput, ...request.Option) (*alexaforbusiness.RevokeInvitationOutput, error)
	RevokeInvitationRequest(*alexaforbusiness.RevokeInvitationInput) (*request.Request, *alexaforbusiness.RevokeInvitationOutput)

	SearchDevices(*alexaforbusiness.SearchDevicesInput) (*alexaforbusiness.SearchDevicesOutput, error)
	SearchDevicesWithContext(aws.Context, *alexaforbusiness.SearchDevicesInput, ...request.Option) (*alexaforbusiness.SearchDevicesOutput, error)
	SearchDevicesRequest(*alexaforbusiness.SearchDevicesInput) (*request.Request, *alexaforbusiness.SearchDevicesOutput)

	SearchDevicesPages(*alexaforbusiness.SearchDevicesInput, func(*alexaforbusiness.SearchDevicesOutput, bool) bool) error
	SearchDevicesPagesWithContext(aws.Context, *alexaforbusiness.SearchDevicesInput, func(*alexaforbusiness.SearchDevicesOutput, bool) bool, ...request.Option) error

	SearchProfiles(*alexaforbusiness.SearchProfilesInput) (*alexaforbusiness.SearchProfilesOutput, error)
	SearchProfilesWithContext(aws.Context, *alexaforbusiness.SearchProfilesInput, ...request.Option) (*alexaforbusiness.SearchProfilesOutput, error)
	SearchProfilesRequest(*alexaforbusiness.SearchProfilesInput) (*request.Request, *alexaforbusiness.SearchProfilesOutput)

	SearchProfilesPages(*alexaforbusiness.SearchProfilesInput, func(*alexaforbusiness.SearchProfilesOutput, bool) bool) error
	SearchProfilesPagesWithContext(aws.Context, *alexaforbusiness.SearchProfilesInput, func(*alexaforbusiness.SearchProfilesOutput, bool) bool, ...request.Option) error

	SearchRooms(*alexaforbusiness.SearchRoomsInput) (*alexaforbusiness.SearchRoomsOutput, error)
	SearchRoomsWithContext(aws.Context, *alexaforbusiness.SearchRoomsInput, ...request.Option) (*alexaforbusiness.SearchRoomsOutput, error)
	SearchRoomsRequest(*alexaforbusiness.SearchRoomsInput) (*request.Request, *alexaforbusiness.SearchRoomsOutput)

	SearchRoomsPages(*alexaforbusiness.SearchRoomsInput, func(*alexaforbusiness.SearchRoomsOutput, bool) bool) error
	SearchRoomsPagesWithContext(aws.Context, *alexaforbusiness.SearchRoomsInput, func(*alexaforbusiness.SearchRoomsOutput, bool) bool, ...request.Option) error

	SearchSkillGroups(*alexaforbusiness.SearchSkillGroupsInput) (*alexaforbusiness.SearchSkillGroupsOutput, error)
	SearchSkillGroupsWithContext(aws.Context, *alexaforbusiness.SearchSkillGroupsInput, ...request.Option) (*alexaforbusiness.SearchSkillGroupsOutput, error)
	SearchSkillGroupsRequest(*alexaforbusiness.SearchSkillGroupsInput) (*request.Request, *alexaforbusiness.SearchSkillGroupsOutput)

	SearchSkillGroupsPages(*alexaforbusiness.SearchSkillGroupsInput, func(*alexaforbusiness.SearchSkillGroupsOutput, bool) bool) error
	SearchSkillGroupsPagesWithContext(aws.Context, *alexaforbusiness.SearchSkillGroupsInput, func(*alexaforbusiness.SearchSkillGroupsOutput, bool) bool, ...request.Option) error

	SearchUsers(*alexaforbusiness.SearchUsersInput) (*alexaforbusiness.SearchUsersOutput, error)
	SearchUsersWithContext(aws.Context, *alexaforbusiness.SearchUsersInput, ...request.Option) (*alexaforbusiness.SearchUsersOutput, error)
	SearchUsersRequest(*alexaforbusiness.SearchUsersInput) (*request.Request, *alexaforbusiness.SearchUsersOutput)

	SearchUsersPages(*alexaforbusiness.SearchUsersInput, func(*alexaforbusiness.SearchUsersOutput, bool) bool) error
	SearchUsersPagesWithContext(aws.Context, *alexaforbusiness.SearchUsersInput, func(*alexaforbusiness.SearchUsersOutput, bool) bool, ...request.Option) error

	SendInvitation(*alexaforbusiness.SendInvitationInput) (*alexaforbusiness.SendInvitationOutput, error)
	SendInvitationWithContext(aws.Context, *alexaforbusiness.SendInvitationInput, ...request.Option) (*alexaforbusiness.SendInvitationOutput, error)
	SendInvitationRequest(*alexaforbusiness.SendInvitationInput) (*request.Request, *alexaforbusiness.SendInvitationOutput)

	StartDeviceSync(*alexaforbusiness.StartDeviceSyncInput) (*alexaforbusiness.StartDeviceSyncOutput, error)
	StartDeviceSyncWithContext(aws.Context, *alexaforbusiness.StartDeviceSyncInput, ...request.Option) (*alexaforbusiness.StartDeviceSyncOutput, error)
	StartDeviceSyncRequest(*alexaforbusiness.StartDeviceSyncInput) (*request.Request, *alexaforbusiness.StartDeviceSyncOutput)

	TagResource(*alexaforbusiness.TagResourceInput) (*alexaforbusiness.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *alexaforbusiness.TagResourceInput, ...request.Option) (*alexaforbusiness.TagResourceOutput, error)
	TagResourceRequest(*alexaforbusiness.TagResourceInput) (*request.Request, *alexaforbusiness.TagResourceOutput)

	UntagResource(*alexaforbusiness.UntagResourceInput) (*alexaforbusiness.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *alexaforbusiness.UntagResourceInput, ...request.Option) (*alexaforbusiness.UntagResourceOutput, error)
	UntagResourceRequest(*alexaforbusiness.UntagResourceInput) (*request.Request, *alexaforbusiness.UntagResourceOutput)

	UpdateDevice(*alexaforbusiness.UpdateDeviceInput) (*alexaforbusiness.UpdateDeviceOutput, error)
	UpdateDeviceWithContext(aws.Context, *alexaforbusiness.UpdateDeviceInput, ...request.Option) (*alexaforbusiness.UpdateDeviceOutput, error)
	UpdateDeviceRequest(*alexaforbusiness.UpdateDeviceInput) (*request.Request, *alexaforbusiness.UpdateDeviceOutput)

	UpdateProfile(*alexaforbusiness.UpdateProfileInput) (*alexaforbusiness.UpdateProfileOutput, error)
	UpdateProfileWithContext(aws.Context, *alexaforbusiness.UpdateProfileInput, ...request.Option) (*alexaforbusiness.UpdateProfileOutput, error)
	UpdateProfileRequest(*alexaforbusiness.UpdateProfileInput) (*request.Request, *alexaforbusiness.UpdateProfileOutput)

	UpdateRoom(*alexaforbusiness.UpdateRoomInput) (*alexaforbusiness.UpdateRoomOutput, error)
	UpdateRoomWithContext(aws.Context, *alexaforbusiness.UpdateRoomInput, ...request.Option) (*alexaforbusiness.UpdateRoomOutput, error)
	UpdateRoomRequest(*alexaforbusiness.UpdateRoomInput) (*request.Request, *alexaforbusiness.UpdateRoomOutput)

	UpdateSkillGroup(*alexaforbusiness.UpdateSkillGroupInput) (*alexaforbusiness.UpdateSkillGroupOutput, error)
	UpdateSkillGroupWithContext(aws.Context, *alexaforbusiness.UpdateSkillGroupInput, ...request.Option) (*alexaforbusiness.UpdateSkillGroupOutput, error)
	UpdateSkillGroupRequest(*alexaforbusiness.UpdateSkillGroupInput) (*request.Request, *alexaforbusiness.UpdateSkillGroupOutput)
}

var _ AlexaForBusinessAPI = (*alexaforbusiness.AlexaForBusiness)(nil)
