// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddCustomAttributes = "AddCustomAttributes"

// AddCustomAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AddCustomAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddCustomAttributes for more information on using the AddCustomAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddCustomAttributesRequest method.
//    req, resp := client.AddCustomAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes
func (c *CognitoIdentityProvider) AddCustomAttributesRequest(input *AddCustomAttributesInput) (req *request.Request, output *AddCustomAttributesOutput) {
	op := &request.Operation{
		Name:       opAddCustomAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCustomAttributesInput{}
	}

	output = &AddCustomAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddCustomAttributes API operation for Amazon Cognito Identity Provider.
//
// Adds additional user attributes to the user pool schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AddCustomAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserImportInProgressException "UserImportInProgressException"
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes
func (c *CognitoIdentityProvider) AddCustomAttributes(input *AddCustomAttributesInput) (*AddCustomAttributesOutput, error) {
	req, out := c.AddCustomAttributesRequest(input)
	return out, req.Send()
}

// AddCustomAttributesWithContext is the same as AddCustomAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AddCustomAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AddCustomAttributesWithContext(ctx aws.Context, input *AddCustomAttributesInput, opts ...request.Option) (*AddCustomAttributesOutput, error) {
	req, out := c.AddCustomAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminAddUserToGroup = "AdminAddUserToGroup"

// AdminAddUserToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AdminAddUserToGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminAddUserToGroup for more information on using the AdminAddUserToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminAddUserToGroupRequest method.
//    req, resp := client.AdminAddUserToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup
func (c *CognitoIdentityProvider) AdminAddUserToGroupRequest(input *AdminAddUserToGroupInput) (req *request.Request, output *AdminAddUserToGroupOutput) {
	op := &request.Operation{
		Name:       opAdminAddUserToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminAddUserToGroupInput{}
	}

	output = &AdminAddUserToGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminAddUserToGroup API operation for Amazon Cognito Identity Provider.
//
// Adds the specified user to the specified group.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminAddUserToGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup
func (c *CognitoIdentityProvider) AdminAddUserToGroup(input *AdminAddUserToGroupInput) (*AdminAddUserToGroupOutput, error) {
	req, out := c.AdminAddUserToGroupRequest(input)
	return out, req.Send()
}

// AdminAddUserToGroupWithContext is the same as AdminAddUserToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AdminAddUserToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminAddUserToGroupWithContext(ctx aws.Context, input *AdminAddUserToGroupInput, opts ...request.Option) (*AdminAddUserToGroupOutput, error) {
	req, out := c.AdminAddUserToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminConfirmSignUp = "AdminConfirmSignUp"

// AdminConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the AdminConfirmSignUp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminConfirmSignUp for more information on using the AdminConfirmSignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminConfirmSignUpRequest method.
//    req, resp := client.AdminConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp
func (c *CognitoIdentityProvider) AdminConfirmSignUpRequest(input *AdminConfirmSignUpInput) (req *request.Request, output *AdminConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opAdminConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminConfirmSignUpInput{}
	}

	output = &AdminConfirmSignUpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms user registration as an admin without using a confirmation code.
// Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminConfirmSignUp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyFailedAttemptsException "TooManyFailedAttemptsException"
//   This exception is thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp
func (c *CognitoIdentityProvider) AdminConfirmSignUp(input *AdminConfirmSignUpInput) (*AdminConfirmSignUpOutput, error) {
	req, out := c.AdminConfirmSignUpRequest(input)
	return out, req.Send()
}

// AdminConfirmSignUpWithContext is the same as AdminConfirmSignUp with the addition of
// the ability to pass a context and additional request options.
//
// See AdminConfirmSignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminConfirmSignUpWithContext(ctx aws.Context, input *AdminConfirmSignUpInput, opts ...request.Option) (*AdminConfirmSignUpOutput, error) {
	req, out := c.AdminConfirmSignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminCreateUser = "AdminCreateUser"

// AdminCreateUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminCreateUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminCreateUser for more information on using the AdminCreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminCreateUserRequest method.
//    req, resp := client.AdminCreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser
func (c *CognitoIdentityProvider) AdminCreateUserRequest(input *AdminCreateUserInput) (req *request.Request, output *AdminCreateUserOutput) {
	op := &request.Operation{
		Name:       opAdminCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminCreateUserInput{}
	}

	output = &AdminCreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminCreateUser API operation for Amazon Cognito Identity Provider.
//
// Creates a new user in the specified user pool.
//
// If MessageAction is not set, the default is to send a welcome message via
// email or phone (SMS).
//
// This message is based on a template that you configured in your call to or
// . This template includes your custom sign-up instructions and placeholders
// for user name and temporary password.
//
// Alternatively, you can call AdminCreateUser with “SUPPRESS” for the MessageAction
// parameter, and Amazon Cognito will not send any email.
//
// In either case, the user will be in the FORCE_CHANGE_PASSWORD state until
// they sign in and change their password.
//
// AdminCreateUser requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminCreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUsernameExistsException "UsernameExistsException"
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   This exception is thrown when a precondition is not met.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUnsupportedUserStateException "UnsupportedUserStateException"
//   The request failed because the user is in an unsupported state.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser
func (c *CognitoIdentityProvider) AdminCreateUser(input *AdminCreateUserInput) (*AdminCreateUserOutput, error) {
	req, out := c.AdminCreateUserRequest(input)
	return out, req.Send()
}

// AdminCreateUserWithContext is the same as AdminCreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminCreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminCreateUserWithContext(ctx aws.Context, input *AdminCreateUserInput, opts ...request.Option) (*AdminCreateUserOutput, error) {
	req, out := c.AdminCreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDeleteUser = "AdminDeleteUser"

// AdminDeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDeleteUser for more information on using the AdminDeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDeleteUserRequest method.
//    req, resp := client.AdminDeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser
func (c *CognitoIdentityProvider) AdminDeleteUserRequest(input *AdminDeleteUserInput) (req *request.Request, output *AdminDeleteUserOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserInput{}
	}

	output = &AdminDeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminDeleteUser API operation for Amazon Cognito Identity Provider.
//
// Deletes a user as an administrator. Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser
func (c *CognitoIdentityProvider) AdminDeleteUser(input *AdminDeleteUserInput) (*AdminDeleteUserOutput, error) {
	req, out := c.AdminDeleteUserRequest(input)
	return out, req.Send()
}

// AdminDeleteUserWithContext is the same as AdminDeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDeleteUserWithContext(ctx aws.Context, input *AdminDeleteUserInput, opts ...request.Option) (*AdminDeleteUserOutput, error) {
	req, out := c.AdminDeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDeleteUserAttributes = "AdminDeleteUserAttributes"

// AdminDeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUserAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDeleteUserAttributes for more information on using the AdminDeleteUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDeleteUserAttributesRequest method.
//    req, resp := client.AdminDeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes
func (c *CognitoIdentityProvider) AdminDeleteUserAttributesRequest(input *AdminDeleteUserAttributesInput) (req *request.Request, output *AdminDeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserAttributesInput{}
	}

	output = &AdminDeleteUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminDeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the user attributes in a user pool as an administrator. Works on
// any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes
func (c *CognitoIdentityProvider) AdminDeleteUserAttributes(input *AdminDeleteUserAttributesInput) (*AdminDeleteUserAttributesOutput, error) {
	req, out := c.AdminDeleteUserAttributesRequest(input)
	return out, req.Send()
}

// AdminDeleteUserAttributesWithContext is the same as AdminDeleteUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDeleteUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDeleteUserAttributesWithContext(ctx aws.Context, input *AdminDeleteUserAttributesInput, opts ...request.Option) (*AdminDeleteUserAttributesOutput, error) {
	req, out := c.AdminDeleteUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDisableProviderForUser = "AdminDisableProviderForUser"

// AdminDisableProviderForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDisableProviderForUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDisableProviderForUser for more information on using the AdminDisableProviderForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDisableProviderForUserRequest method.
//    req, resp := client.AdminDisableProviderForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser
func (c *CognitoIdentityProvider) AdminDisableProviderForUserRequest(input *AdminDisableProviderForUserInput) (req *request.Request, output *AdminDisableProviderForUserOutput) {
	op := &request.Operation{
		Name:       opAdminDisableProviderForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableProviderForUserInput{}
	}

	output = &AdminDisableProviderForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminDisableProviderForUser API operation for Amazon Cognito Identity Provider.
//
// Disables the user from signing in with the specified external (SAML or social)
// identity provider. If the user to disable is a Cognito User Pools native
// username + password user, they are not permitted to use their password to
// sign-in. If the user to disable is a linked external IdP user, any link between
// that user and an existing user is removed. The next time the external user
// (no longer attached to the previously linked DestinationUser) signs in, they
// must create a new user account. See .
//
// This action is enabled only for admin access and requires developer credentials.
//
// The ProviderName must match the value specified when creating an IdP for
// the pool.
//
// To disable a native username + password user, the ProviderName value must
// be Cognito and the ProviderAttributeName must be Cognito_Subject, with the
// ProviderAttributeValue being the name that is used in the user pool for the
// user.
//
// The ProviderAttributeName must always be Cognito_Subject for social identity
// providers. The ProviderAttributeValue must always be the exact subject that
// was used when the user was originally linked as a source user.
//
// For de-linking a SAML identity, there are two scenarios. If the linked identity
// has not yet been used to sign-in, the ProviderAttributeName and ProviderAttributeValue
// must be the same values that were used for the SourceUser when the identities
// were originally linked in the call. (If the linking was done with ProviderAttributeName
// set to Cognito_Subject, the same applies here). However, if the user has
// already signed in, the ProviderAttributeName must be Cognito_Subject and
// ProviderAttributeValue must be the subject of the SAML assertion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDisableProviderForUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser
func (c *CognitoIdentityProvider) AdminDisableProviderForUser(input *AdminDisableProviderForUserInput) (*AdminDisableProviderForUserOutput, error) {
	req, out := c.AdminDisableProviderForUserRequest(input)
	return out, req.Send()
}

// AdminDisableProviderForUserWithContext is the same as AdminDisableProviderForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDisableProviderForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDisableProviderForUserWithContext(ctx aws.Context, input *AdminDisableProviderForUserInput, opts ...request.Option) (*AdminDisableProviderForUserOutput, error) {
	req, out := c.AdminDisableProviderForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDisableUser = "AdminDisableUser"

// AdminDisableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDisableUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDisableUser for more information on using the AdminDisableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDisableUserRequest method.
//    req, resp := client.AdminDisableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser
func (c *CognitoIdentityProvider) AdminDisableUserRequest(input *AdminDisableUserInput) (req *request.Request, output *AdminDisableUserOutput) {
	op := &request.Operation{
		Name:       opAdminDisableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableUserInput{}
	}

	output = &AdminDisableUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminDisableUser API operation for Amazon Cognito Identity Provider.
//
// Disables the specified user as an administrator. Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDisableUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser
func (c *CognitoIdentityProvider) AdminDisableUser(input *AdminDisableUserInput) (*AdminDisableUserOutput, error) {
	req, out := c.AdminDisableUserRequest(input)
	return out, req.Send()
}

// AdminDisableUserWithContext is the same as AdminDisableUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDisableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDisableUserWithContext(ctx aws.Context, input *AdminDisableUserInput, opts ...request.Option) (*AdminDisableUserOutput, error) {
	req, out := c.AdminDisableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminEnableUser = "AdminEnableUser"

// AdminEnableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminEnableUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminEnableUser for more information on using the AdminEnableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminEnableUserRequest method.
//    req, resp := client.AdminEnableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser
func (c *CognitoIdentityProvider) AdminEnableUserRequest(input *AdminEnableUserInput) (req *request.Request, output *AdminEnableUserOutput) {
	op := &request.Operation{
		Name:       opAdminEnableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminEnableUserInput{}
	}

	output = &AdminEnableUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminEnableUser API operation for Amazon Cognito Identity Provider.
//
// Enables the specified user as an administrator. Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminEnableUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser
func (c *CognitoIdentityProvider) AdminEnableUser(input *AdminEnableUserInput) (*AdminEnableUserOutput, error) {
	req, out := c.AdminEnableUserRequest(input)
	return out, req.Send()
}

// AdminEnableUserWithContext is the same as AdminEnableUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminEnableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminEnableUserWithContext(ctx aws.Context, input *AdminEnableUserInput, opts ...request.Option) (*AdminEnableUserOutput, error) {
	req, out := c.AdminEnableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminForgetDevice = "AdminForgetDevice"

// AdminForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminForgetDevice operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminForgetDevice for more information on using the AdminForgetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminForgetDeviceRequest method.
//    req, resp := client.AdminForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice
func (c *CognitoIdentityProvider) AdminForgetDeviceRequest(input *AdminForgetDeviceInput) (req *request.Request, output *AdminForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminForgetDeviceInput{}
	}

	output = &AdminForgetDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the device, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminForgetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice
func (c *CognitoIdentityProvider) AdminForgetDevice(input *AdminForgetDeviceInput) (*AdminForgetDeviceOutput, error) {
	req, out := c.AdminForgetDeviceRequest(input)
	return out, req.Send()
}

// AdminForgetDeviceWithContext is the same as AdminForgetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See AdminForgetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminForgetDeviceWithContext(ctx aws.Context, input *AdminForgetDeviceInput, opts ...request.Option) (*AdminForgetDeviceOutput, error) {
	req, out := c.AdminForgetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminGetDevice = "AdminGetDevice"

// AdminGetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetDevice operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminGetDevice for more information on using the AdminGetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminGetDeviceRequest method.
//    req, resp := client.AdminGetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice
func (c *CognitoIdentityProvider) AdminGetDeviceRequest(input *AdminGetDeviceInput) (req *request.Request, output *AdminGetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetDeviceInput{}
	}

	output = &AdminGetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminGetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice
func (c *CognitoIdentityProvider) AdminGetDevice(input *AdminGetDeviceInput) (*AdminGetDeviceOutput, error) {
	req, out := c.AdminGetDeviceRequest(input)
	return out, req.Send()
}

// AdminGetDeviceWithContext is the same as AdminGetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See AdminGetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminGetDeviceWithContext(ctx aws.Context, input *AdminGetDeviceInput, opts ...request.Option) (*AdminGetDeviceOutput, error) {
	req, out := c.AdminGetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminGetUser = "AdminGetUser"

// AdminGetUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminGetUser for more information on using the AdminGetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminGetUserRequest method.
//    req, resp := client.AdminGetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser
func (c *CognitoIdentityProvider) AdminGetUserRequest(input *AdminGetUserInput) (req *request.Request, output *AdminGetUserOutput) {
	op := &request.Operation{
		Name:       opAdminGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetUserInput{}
	}

	output = &AdminGetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminGetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the specified user by user name in a user pool as an administrator.
// Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser
func (c *CognitoIdentityProvider) AdminGetUser(input *AdminGetUserInput) (*AdminGetUserOutput, error) {
	req, out := c.AdminGetUserRequest(input)
	return out, req.Send()
}

// AdminGetUserWithContext is the same as AdminGetUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminGetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminGetUserWithContext(ctx aws.Context, input *AdminGetUserInput, opts ...request.Option) (*AdminGetUserOutput, error) {
	req, out := c.AdminGetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminInitiateAuth = "AdminInitiateAuth"

// AdminInitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the AdminInitiateAuth operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminInitiateAuth for more information on using the AdminInitiateAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminInitiateAuthRequest method.
//    req, resp := client.AdminInitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth
func (c *CognitoIdentityProvider) AdminInitiateAuthRequest(input *AdminInitiateAuthInput) (req *request.Request, output *AdminInitiateAuthOutput) {
	op := &request.Operation{
		Name:       opAdminInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminInitiateAuthInput{}
	}

	output = &AdminInitiateAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminInitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminInitiateAuth for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeMFAMethodNotFoundException "MFAMethodNotFoundException"
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth
func (c *CognitoIdentityProvider) AdminInitiateAuth(input *AdminInitiateAuthInput) (*AdminInitiateAuthOutput, error) {
	req, out := c.AdminInitiateAuthRequest(input)
	return out, req.Send()
}

// AdminInitiateAuthWithContext is the same as AdminInitiateAuth with the addition of
// the ability to pass a context and additional request options.
//
// See AdminInitiateAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminInitiateAuthWithContext(ctx aws.Context, input *AdminInitiateAuthInput, opts ...request.Option) (*AdminInitiateAuthOutput, error) {
	req, out := c.AdminInitiateAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminLinkProviderForUser = "AdminLinkProviderForUser"

// AdminLinkProviderForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminLinkProviderForUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminLinkProviderForUser for more information on using the AdminLinkProviderForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminLinkProviderForUserRequest method.
//    req, resp := client.AdminLinkProviderForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser
func (c *CognitoIdentityProvider) AdminLinkProviderForUserRequest(input *AdminLinkProviderForUserInput) (req *request.Request, output *AdminLinkProviderForUserOutput) {
	op := &request.Operation{
		Name:       opAdminLinkProviderForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminLinkProviderForUserInput{}
	}

	output = &AdminLinkProviderForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminLinkProviderForUser API operation for Amazon Cognito Identity Provider.
//
// Links an existing user account in a user pool (DestinationUser) to an identity
// from an external identity provider (SourceUser) based on a specified attribute
// name and value from the external identity provider. This allows you to create
// a link from the existing user account to an external federated user identity
// that has not yet been used to sign in, so that the federated user identity
// can be used to sign in as the existing user account.
//
// For example, if there is an existing user with a username and password, this
// API links that user to a federated user identity, so that when the federated
// user identity is used, the user signs in as the existing user account.
//
// Because this API allows a user with an external federated identity to sign
// in as an existing user in the user pool, it is critical that it only be used
// with external identity providers and provider attributes that have been trusted
// by the application owner.
//
// See also .
//
// This action is enabled only for admin access and requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminLinkProviderForUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser
func (c *CognitoIdentityProvider) AdminLinkProviderForUser(input *AdminLinkProviderForUserInput) (*AdminLinkProviderForUserOutput, error) {
	req, out := c.AdminLinkProviderForUserRequest(input)
	return out, req.Send()
}

// AdminLinkProviderForUserWithContext is the same as AdminLinkProviderForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminLinkProviderForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminLinkProviderForUserWithContext(ctx aws.Context, input *AdminLinkProviderForUserInput, opts ...request.Option) (*AdminLinkProviderForUserOutput, error) {
	req, out := c.AdminLinkProviderForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminListDevices = "AdminListDevices"

// AdminListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the AdminListDevices operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListDevices for more information on using the AdminListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListDevicesRequest method.
//    req, resp := client.AdminListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices
func (c *CognitoIdentityProvider) AdminListDevicesRequest(input *AdminListDevicesInput) (req *request.Request, output *AdminListDevicesOutput) {
	op := &request.Operation{
		Name:       opAdminListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListDevicesInput{}
	}

	output = &AdminListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists devices, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListDevices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices
func (c *CognitoIdentityProvider) AdminListDevices(input *AdminListDevicesInput) (*AdminListDevicesOutput, error) {
	req, out := c.AdminListDevicesRequest(input)
	return out, req.Send()
}

// AdminListDevicesWithContext is the same as AdminListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListDevicesWithContext(ctx aws.Context, input *AdminListDevicesInput, opts ...request.Option) (*AdminListDevicesOutput, error) {
	req, out := c.AdminListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminListGroupsForUser = "AdminListGroupsForUser"

// AdminListGroupsForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminListGroupsForUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListGroupsForUser for more information on using the AdminListGroupsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListGroupsForUserRequest method.
//    req, resp := client.AdminListGroupsForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser
func (c *CognitoIdentityProvider) AdminListGroupsForUserRequest(input *AdminListGroupsForUserInput) (req *request.Request, output *AdminListGroupsForUserOutput) {
	op := &request.Operation{
		Name:       opAdminListGroupsForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListGroupsForUserInput{}
	}

	output = &AdminListGroupsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListGroupsForUser API operation for Amazon Cognito Identity Provider.
//
// Lists the groups that the user belongs to.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListGroupsForUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser
func (c *CognitoIdentityProvider) AdminListGroupsForUser(input *AdminListGroupsForUserInput) (*AdminListGroupsForUserOutput, error) {
	req, out := c.AdminListGroupsForUserRequest(input)
	return out, req.Send()
}

// AdminListGroupsForUserWithContext is the same as AdminListGroupsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListGroupsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListGroupsForUserWithContext(ctx aws.Context, input *AdminListGroupsForUserInput, opts ...request.Option) (*AdminListGroupsForUserOutput, error) {
	req, out := c.AdminListGroupsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminListUserAuthEvents = "AdminListUserAuthEvents"

// AdminListUserAuthEventsRequest generates a "aws/request.Request" representing the
// client's request for the AdminListUserAuthEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListUserAuthEvents for more information on using the AdminListUserAuthEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListUserAuthEventsRequest method.
//    req, resp := client.AdminListUserAuthEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents
func (c *CognitoIdentityProvider) AdminListUserAuthEventsRequest(input *AdminListUserAuthEventsInput) (req *request.Request, output *AdminListUserAuthEventsOutput) {
	op := &request.Operation{
		Name:       opAdminListUserAuthEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListUserAuthEventsInput{}
	}

	output = &AdminListUserAuthEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListUserAuthEvents API operation for Amazon Cognito Identity Provider.
//
// Lists a history of user activity and any risks detected as part of Amazon
// Cognito advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListUserAuthEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserPoolAddOnNotEnabledException "UserPoolAddOnNotEnabledException"
//   This exception is thrown when user pool add-ons are not enabled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents
func (c *CognitoIdentityProvider) AdminListUserAuthEvents(input *AdminListUserAuthEventsInput) (*AdminListUserAuthEventsOutput, error) {
	req, out := c.AdminListUserAuthEventsRequest(input)
	return out, req.Send()
}

// AdminListUserAuthEventsWithContext is the same as AdminListUserAuthEvents with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListUserAuthEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListUserAuthEventsWithContext(ctx aws.Context, input *AdminListUserAuthEventsInput, opts ...request.Option) (*AdminListUserAuthEventsOutput, error) {
	req, out := c.AdminListUserAuthEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminRemoveUserFromGroup = "AdminRemoveUserFromGroup"

// AdminRemoveUserFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the AdminRemoveUserFromGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminRemoveUserFromGroup for more information on using the AdminRemoveUserFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminRemoveUserFromGroupRequest method.
//    req, resp := client.AdminRemoveUserFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroupRequest(input *AdminRemoveUserFromGroupInput) (req *request.Request, output *AdminRemoveUserFromGroupOutput) {
	op := &request.Operation{
		Name:       opAdminRemoveUserFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminRemoveUserFromGroupInput{}
	}

	output = &AdminRemoveUserFromGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminRemoveUserFromGroup API operation for Amazon Cognito Identity Provider.
//
// Removes the specified user from the specified group.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminRemoveUserFromGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroup(input *AdminRemoveUserFromGroupInput) (*AdminRemoveUserFromGroupOutput, error) {
	req, out := c.AdminRemoveUserFromGroupRequest(input)
	return out, req.Send()
}

// AdminRemoveUserFromGroupWithContext is the same as AdminRemoveUserFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AdminRemoveUserFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroupWithContext(ctx aws.Context, input *AdminRemoveUserFromGroupInput, opts ...request.Option) (*AdminRemoveUserFromGroupOutput, error) {
	req, out := c.AdminRemoveUserFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminResetUserPassword = "AdminResetUserPassword"

// AdminResetUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the AdminResetUserPassword operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminResetUserPassword for more information on using the AdminResetUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminResetUserPasswordRequest method.
//    req, resp := client.AdminResetUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword
func (c *CognitoIdentityProvider) AdminResetUserPasswordRequest(input *AdminResetUserPasswordInput) (req *request.Request, output *AdminResetUserPasswordOutput) {
	op := &request.Operation{
		Name:       opAdminResetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminResetUserPasswordInput{}
	}

	output = &AdminResetUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminResetUserPassword API operation for Amazon Cognito Identity Provider.
//
// Resets the specified user's password in a user pool as an administrator.
// Works on any user.
//
// When a developer calls this API, the current password is invalidated, so
// it must be changed. If a user tries to sign in after the API is called, the
// app will get a PasswordResetRequiredException exception back and should direct
// the user down the flow to reset the password, which is the same as the forgot
// password flow. In addition, if the user pool has phone verification selected
// and a verified phone number exists for the user, or if email verification
// is selected and a verified email exists for the user, calling this API will
// also result in sending a message to the end user with the code to change
// their password.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminResetUserPassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword
func (c *CognitoIdentityProvider) AdminResetUserPassword(input *AdminResetUserPasswordInput) (*AdminResetUserPasswordOutput, error) {
	req, out := c.AdminResetUserPasswordRequest(input)
	return out, req.Send()
}

// AdminResetUserPasswordWithContext is the same as AdminResetUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See AdminResetUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminResetUserPasswordWithContext(ctx aws.Context, input *AdminResetUserPasswordInput, opts ...request.Option) (*AdminResetUserPasswordOutput, error) {
	req, out := c.AdminResetUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminRespondToAuthChallenge = "AdminRespondToAuthChallenge"

// AdminRespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the AdminRespondToAuthChallenge operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminRespondToAuthChallenge for more information on using the AdminRespondToAuthChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminRespondToAuthChallengeRequest method.
//    req, resp := client.AdminRespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge
func (c *CognitoIdentityProvider) AdminRespondToAuthChallengeRequest(input *AdminRespondToAuthChallengeInput) (req *request.Request, output *AdminRespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opAdminRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminRespondToAuthChallengeInput{}
	}

	output = &AdminRespondToAuthChallengeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminRespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to an authentication challenge, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminRespondToAuthChallenge for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeMFAMethodNotFoundException "MFAMethodNotFoundException"
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeSoftwareTokenMFANotFoundException "SoftwareTokenMFANotFoundException"
//   This exception is thrown when the software token TOTP multi-factor authentication
//   (MFA) is not enabled for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge
func (c *CognitoIdentityProvider) AdminRespondToAuthChallenge(input *AdminRespondToAuthChallengeInput) (*AdminRespondToAuthChallengeOutput, error) {
	req, out := c.AdminRespondToAuthChallengeRequest(input)
	return out, req.Send()
}

// AdminRespondToAuthChallengeWithContext is the same as AdminRespondToAuthChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See AdminRespondToAuthChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminRespondToAuthChallengeWithContext(ctx aws.Context, input *AdminRespondToAuthChallengeInput, opts ...request.Option) (*AdminRespondToAuthChallengeOutput, error) {
	req, out := c.AdminRespondToAuthChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminSetUserMFAPreference = "AdminSetUserMFAPreference"

// AdminSetUserMFAPreferenceRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserMFAPreference operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminSetUserMFAPreference for more information on using the AdminSetUserMFAPreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminSetUserMFAPreferenceRequest method.
//    req, resp := client.AdminSetUserMFAPreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference
func (c *CognitoIdentityProvider) AdminSetUserMFAPreferenceRequest(input *AdminSetUserMFAPreferenceInput) (req *request.Request, output *AdminSetUserMFAPreferenceOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserMFAPreferenceInput{}
	}

	output = &AdminSetUserMFAPreferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminSetUserMFAPreference API operation for Amazon Cognito Identity Provider.
//
// Sets the user's multi-factor authentication (MFA) preference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserMFAPreference for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference
func (c *CognitoIdentityProvider) AdminSetUserMFAPreference(input *AdminSetUserMFAPreferenceInput) (*AdminSetUserMFAPreferenceOutput, error) {
	req, out := c.AdminSetUserMFAPreferenceRequest(input)
	return out, req.Send()
}

// AdminSetUserMFAPreferenceWithContext is the same as AdminSetUserMFAPreference with the addition of
// the ability to pass a context and additional request options.
//
// See AdminSetUserMFAPreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminSetUserMFAPreferenceWithContext(ctx aws.Context, input *AdminSetUserMFAPreferenceInput, opts ...request.Option) (*AdminSetUserMFAPreferenceOutput, error) {
	req, out := c.AdminSetUserMFAPreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminSetUserSettings = "AdminSetUserSettings"

// AdminSetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminSetUserSettings for more information on using the AdminSetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminSetUserSettingsRequest method.
//    req, resp := client.AdminSetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings
func (c *CognitoIdentityProvider) AdminSetUserSettingsRequest(input *AdminSetUserSettingsInput) (req *request.Request, output *AdminSetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserSettingsInput{}
	}

	output = &AdminSetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminSetUserSettings API operation for Amazon Cognito Identity Provider.
//
// Sets all the user settings for a specified user name. Works on any user.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings
func (c *CognitoIdentityProvider) AdminSetUserSettings(input *AdminSetUserSettingsInput) (*AdminSetUserSettingsOutput, error) {
	req, out := c.AdminSetUserSettingsRequest(input)
	return out, req.Send()
}

// AdminSetUserSettingsWithContext is the same as AdminSetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AdminSetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminSetUserSettingsWithContext(ctx aws.Context, input *AdminSetUserSettingsInput, opts ...request.Option) (*AdminSetUserSettingsOutput, error) {
	req, out := c.AdminSetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateAuthEventFeedback = "AdminUpdateAuthEventFeedback"

// AdminUpdateAuthEventFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateAuthEventFeedback operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateAuthEventFeedback for more information on using the AdminUpdateAuthEventFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateAuthEventFeedbackRequest method.
//    req, resp := client.AdminUpdateAuthEventFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedbackRequest(input *AdminUpdateAuthEventFeedbackInput) (req *request.Request, output *AdminUpdateAuthEventFeedbackOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateAuthEventFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateAuthEventFeedbackInput{}
	}

	output = &AdminUpdateAuthEventFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminUpdateAuthEventFeedback API operation for Amazon Cognito Identity Provider.
//
// Provides feedback for an authentication event as to whether it was from a
// valid user. This feedback is used for improving the risk evaluation decision
// for the user pool as part of Amazon Cognito advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateAuthEventFeedback for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserPoolAddOnNotEnabledException "UserPoolAddOnNotEnabledException"
//   This exception is thrown when user pool add-ons are not enabled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedback(input *AdminUpdateAuthEventFeedbackInput) (*AdminUpdateAuthEventFeedbackOutput, error) {
	req, out := c.AdminUpdateAuthEventFeedbackRequest(input)
	return out, req.Send()
}

// AdminUpdateAuthEventFeedbackWithContext is the same as AdminUpdateAuthEventFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateAuthEventFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedbackWithContext(ctx aws.Context, input *AdminUpdateAuthEventFeedbackInput, opts ...request.Option) (*AdminUpdateAuthEventFeedbackOutput, error) {
	req, out := c.AdminUpdateAuthEventFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateDeviceStatus = "AdminUpdateDeviceStatus"

// AdminUpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateDeviceStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateDeviceStatus for more information on using the AdminUpdateDeviceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateDeviceStatusRequest method.
//    req, resp := client.AdminUpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatusRequest(input *AdminUpdateDeviceStatusInput) (req *request.Request, output *AdminUpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateDeviceStatusInput{}
	}

	output = &AdminUpdateDeviceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminUpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateDeviceStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatus(input *AdminUpdateDeviceStatusInput) (*AdminUpdateDeviceStatusOutput, error) {
	req, out := c.AdminUpdateDeviceStatusRequest(input)
	return out, req.Send()
}

// AdminUpdateDeviceStatusWithContext is the same as AdminUpdateDeviceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateDeviceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatusWithContext(ctx aws.Context, input *AdminUpdateDeviceStatusInput, opts ...request.Option) (*AdminUpdateDeviceStatusOutput, error) {
	req, out := c.AdminUpdateDeviceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateUserAttributes = "AdminUpdateUserAttributes"

// AdminUpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateUserAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateUserAttributes for more information on using the AdminUpdateUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateUserAttributesRequest method.
//    req, resp := client.AdminUpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes
func (c *CognitoIdentityProvider) AdminUpdateUserAttributesRequest(input *AdminUpdateUserAttributesInput) (req *request.Request, output *AdminUpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateUserAttributesInput{}
	}

	output = &AdminUpdateUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminUpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user's attributes, including developer attributes,
// as an administrator. Works on any user.
//
// For custom attributes, you must prepend the custom: prefix to the attribute
// name.
//
// In addition to updating user attributes, this API can also be used to mark
// phone and email as verified.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes
func (c *CognitoIdentityProvider) AdminUpdateUserAttributes(input *AdminUpdateUserAttributesInput) (*AdminUpdateUserAttributesOutput, error) {
	req, out := c.AdminUpdateUserAttributesRequest(input)
	return out, req.Send()
}

// AdminUpdateUserAttributesWithContext is the same as AdminUpdateUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateUserAttributesWithContext(ctx aws.Context, input *AdminUpdateUserAttributesInput, opts ...request.Option) (*AdminUpdateUserAttributesOutput, error) {
	req, out := c.AdminUpdateUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUserGlobalSignOut = "AdminUserGlobalSignOut"

// AdminUserGlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the AdminUserGlobalSignOut operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUserGlobalSignOut for more information on using the AdminUserGlobalSignOut
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUserGlobalSignOutRequest method.
//    req, resp := client.AdminUserGlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut
func (c *CognitoIdentityProvider) AdminUserGlobalSignOutRequest(input *AdminUserGlobalSignOutInput) (req *request.Request, output *AdminUserGlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opAdminUserGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUserGlobalSignOutInput{}
	}

	output = &AdminUserGlobalSignOutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminUserGlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices, as an administrator.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUserGlobalSignOut for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut
func (c *CognitoIdentityProvider) AdminUserGlobalSignOut(input *AdminUserGlobalSignOutInput) (*AdminUserGlobalSignOutOutput, error) {
	req, out := c.AdminUserGlobalSignOutRequest(input)
	return out, req.Send()
}

// AdminUserGlobalSignOutWithContext is the same as AdminUserGlobalSignOut with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUserGlobalSignOut for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUserGlobalSignOutWithContext(ctx aws.Context, input *AdminUserGlobalSignOutInput, opts ...request.Option) (*AdminUserGlobalSignOutOutput, error) {
	req, out := c.AdminUserGlobalSignOutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSoftwareToken = "AssociateSoftwareToken"

// AssociateSoftwareTokenRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSoftwareToken operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSoftwareToken for more information on using the AssociateSoftwareToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSoftwareTokenRequest method.
//    req, resp := client.AssociateSoftwareTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken
func (c *CognitoIdentityProvider) AssociateSoftwareTokenRequest(input *AssociateSoftwareTokenInput) (req *request.Request, output *AssociateSoftwareTokenOutput) {
	op := &request.Operation{
		Name:       opAssociateSoftwareToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSoftwareTokenInput{}
	}

	output = &AssociateSoftwareTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSoftwareToken API operation for Amazon Cognito Identity Provider.
//
// Returns a unique generated shared secret key code for the user account. The
// request takes an access token or a session string, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AssociateSoftwareToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeSoftwareTokenMFANotFoundException "SoftwareTokenMFANotFoundException"
//   This exception is thrown when the software token TOTP multi-factor authentication
//   (MFA) is not enabled for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken
func (c *CognitoIdentityProvider) AssociateSoftwareToken(input *AssociateSoftwareTokenInput) (*AssociateSoftwareTokenOutput, error) {
	req, out := c.AssociateSoftwareTokenRequest(input)
	return out, req.Send()
}

// AssociateSoftwareTokenWithContext is the same as AssociateSoftwareToken with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSoftwareToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AssociateSoftwareTokenWithContext(ctx aws.Context, input *AssociateSoftwareTokenInput, opts ...request.Option) (*AssociateSoftwareTokenOutput, error) {
	req, out := c.AssociateSoftwareTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChangePassword = "ChangePassword"

// ChangePasswordRequest generates a "aws/request.Request" representing the
// client's request for the ChangePassword operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChangePassword for more information on using the ChangePassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ChangePasswordRequest method.
//    req, resp := client.ChangePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword
func (c *CognitoIdentityProvider) ChangePasswordRequest(input *ChangePasswordInput) (req *request.Request, output *ChangePasswordOutput) {
	op := &request.Operation{
		Name:       opChangePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangePasswordInput{}
	}

	output = &ChangePasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ChangePassword API operation for Amazon Cognito Identity Provider.
//
// Changes the password for a specified user in a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ChangePassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword
func (c *CognitoIdentityProvider) ChangePassword(input *ChangePasswordInput) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	return out, req.Send()
}

// ChangePasswordWithContext is the same as ChangePassword with the addition of
// the ability to pass a context and additional request options.
//
// See ChangePassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ChangePasswordWithContext(ctx aws.Context, input *ChangePasswordInput, opts ...request.Option) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmDevice = "ConfirmDevice"

// ConfirmDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmDevice operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmDevice for more information on using the ConfirmDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmDeviceRequest method.
//    req, resp := client.ConfirmDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice
func (c *CognitoIdentityProvider) ConfirmDeviceRequest(input *ConfirmDeviceInput) (req *request.Request, output *ConfirmDeviceOutput) {
	op := &request.Operation{
		Name:       opConfirmDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmDeviceInput{}
	}

	output = &ConfirmDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmDevice API operation for Amazon Cognito Identity Provider.
//
// Confirms tracking of the device. This API call is the call that begins device
// tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeUsernameExistsException "UsernameExistsException"
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice
func (c *CognitoIdentityProvider) ConfirmDevice(input *ConfirmDeviceInput) (*ConfirmDeviceOutput, error) {
	req, out := c.ConfirmDeviceRequest(input)
	return out, req.Send()
}

// ConfirmDeviceWithContext is the same as ConfirmDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmDeviceWithContext(ctx aws.Context, input *ConfirmDeviceInput, opts ...request.Option) (*ConfirmDeviceOutput, error) {
	req, out := c.ConfirmDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmForgotPassword = "ConfirmForgotPassword"

// ConfirmForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmForgotPassword operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmForgotPassword for more information on using the ConfirmForgotPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmForgotPasswordRequest method.
//    req, resp := client.ConfirmForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword
func (c *CognitoIdentityProvider) ConfirmForgotPasswordRequest(input *ConfirmForgotPasswordInput) (req *request.Request, output *ConfirmForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opConfirmForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmForgotPasswordInput{}
	}

	output = &ConfirmForgotPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ConfirmForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Allows a user to enter a confirmation code to reset a forgotten password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmForgotPassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeTooManyFailedAttemptsException "TooManyFailedAttemptsException"
//   This exception is thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword
func (c *CognitoIdentityProvider) ConfirmForgotPassword(input *ConfirmForgotPasswordInput) (*ConfirmForgotPasswordOutput, error) {
	req, out := c.ConfirmForgotPasswordRequest(input)
	return out, req.Send()
}

// ConfirmForgotPasswordWithContext is the same as ConfirmForgotPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmForgotPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmForgotPasswordWithContext(ctx aws.Context, input *ConfirmForgotPasswordInput, opts ...request.Option) (*ConfirmForgotPasswordOutput, error) {
	req, out := c.ConfirmForgotPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmSignUp = "ConfirmSignUp"

// ConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmSignUp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmSignUp for more information on using the ConfirmSignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmSignUpRequest method.
//    req, resp := client.ConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp
func (c *CognitoIdentityProvider) ConfirmSignUpRequest(input *ConfirmSignUpInput) (req *request.Request, output *ConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSignUpInput{}
	}

	output = &ConfirmSignUpOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms registration of a user and handles the existing alias from a previous
// user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmSignUp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyFailedAttemptsException "TooManyFailedAttemptsException"
//   This exception is thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp
func (c *CognitoIdentityProvider) ConfirmSignUp(input *ConfirmSignUpInput) (*ConfirmSignUpOutput, error) {
	req, out := c.ConfirmSignUpRequest(input)
	return out, req.Send()
}

// ConfirmSignUpWithContext is the same as ConfirmSignUp with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmSignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmSignUpWithContext(ctx aws.Context, input *ConfirmSignUpInput, opts ...request.Option) (*ConfirmSignUpOutput, error) {
	req, out := c.ConfirmSignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup
func (c *CognitoIdentityProvider) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon Cognito Identity Provider.
//
// Creates a new group in the specified user pool.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeGroupExistsException "GroupExistsException"
//   This exception is thrown when Amazon Cognito encounters a group that already
//   exists in the user pool.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup
func (c *CognitoIdentityProvider) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdentityProvider = "CreateIdentityProvider"

// CreateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdentityProvider for more information on using the CreateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIdentityProviderRequest method.
//    req, resp := client.CreateIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider
func (c *CognitoIdentityProvider) CreateIdentityProviderRequest(input *CreateIdentityProviderInput) (req *request.Request, output *CreateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opCreateIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIdentityProviderInput{}
	}

	output = &CreateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Creates an identity provider for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateIdentityProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeDuplicateProviderException "DuplicateProviderException"
//   This exception is thrown when the provider is already supported by the user
//   pool.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider
func (c *CognitoIdentityProvider) CreateIdentityProvider(input *CreateIdentityProviderInput) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	return out, req.Send()
}

// CreateIdentityProviderWithContext is the same as CreateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateIdentityProviderWithContext(ctx aws.Context, input *CreateIdentityProviderInput, opts ...request.Option) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceServer = "CreateResourceServer"

// CreateResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceServer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceServer for more information on using the CreateResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceServerRequest method.
//    req, resp := client.CreateResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer
func (c *CognitoIdentityProvider) CreateResourceServerRequest(input *CreateResourceServerInput) (req *request.Request, output *CreateResourceServerOutput) {
	op := &request.Operation{
		Name:       opCreateResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceServerInput{}
	}

	output = &CreateResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceServer API operation for Amazon Cognito Identity Provider.
//
// Creates a new OAuth2.0 resource server and defines custom scopes in it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateResourceServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer
func (c *CognitoIdentityProvider) CreateResourceServer(input *CreateResourceServerInput) (*CreateResourceServerOutput, error) {
	req, out := c.CreateResourceServerRequest(input)
	return out, req.Send()
}

// CreateResourceServerWithContext is the same as CreateResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateResourceServerWithContext(ctx aws.Context, input *CreateResourceServerInput, opts ...request.Option) (*CreateResourceServerOutput, error) {
	req, out := c.CreateResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserImportJob = "CreateUserImportJob"

// CreateUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserImportJob for more information on using the CreateUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserImportJobRequest method.
//    req, resp := client.CreateUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob
func (c *CognitoIdentityProvider) CreateUserImportJobRequest(input *CreateUserImportJobInput) (req *request.Request, output *CreateUserImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserImportJobInput{}
	}

	output = &CreateUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Creates the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   This exception is thrown when a precondition is not met.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob
func (c *CognitoIdentityProvider) CreateUserImportJob(input *CreateUserImportJobInput) (*CreateUserImportJobOutput, error) {
	req, out := c.CreateUserImportJobRequest(input)
	return out, req.Send()
}

// CreateUserImportJobWithContext is the same as CreateUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserImportJobWithContext(ctx aws.Context, input *CreateUserImportJobInput, opts ...request.Option) (*CreateUserImportJobOutput, error) {
	req, out := c.CreateUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPool = "CreateUserPool"

// CreateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPool operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPool for more information on using the CreateUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolRequest method.
//    req, resp := client.CreateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool
func (c *CognitoIdentityProvider) CreateUserPoolRequest(input *CreateUserPoolInput) (req *request.Request, output *CreateUserPoolOutput) {
	op := &request.Operation{
		Name:       opCreateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolInput{}
	}

	output = &CreateUserPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPool API operation for Amazon Cognito Identity Provider.
//
// Creates a new Amazon Cognito user pool and sets the password policy for the
// pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserPoolTaggingException "UserPoolTaggingException"
//   This exception is thrown when a user pool tag cannot be set or updated.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool
func (c *CognitoIdentityProvider) CreateUserPool(input *CreateUserPoolInput) (*CreateUserPoolOutput, error) {
	req, out := c.CreateUserPoolRequest(input)
	return out, req.Send()
}

// CreateUserPoolWithContext is the same as CreateUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolWithContext(ctx aws.Context, input *CreateUserPoolInput, opts ...request.Option) (*CreateUserPoolOutput, error) {
	req, out := c.CreateUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPoolClient = "CreateUserPoolClient"

// CreateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPoolClient for more information on using the CreateUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolClientRequest method.
//    req, resp := client.CreateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient
func (c *CognitoIdentityProvider) CreateUserPoolClientRequest(input *CreateUserPoolClientInput) (req *request.Request, output *CreateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opCreateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolClientInput{}
	}

	output = &CreateUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Creates the user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeScopeDoesNotExistException "ScopeDoesNotExistException"
//   This exception is thrown when the specified scope does not exist.
//
//   * ErrCodeInvalidOAuthFlowException "InvalidOAuthFlowException"
//   This exception is thrown when the specified OAuth flow is invalid.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient
func (c *CognitoIdentityProvider) CreateUserPoolClient(input *CreateUserPoolClientInput) (*CreateUserPoolClientOutput, error) {
	req, out := c.CreateUserPoolClientRequest(input)
	return out, req.Send()
}

// CreateUserPoolClientWithContext is the same as CreateUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolClientWithContext(ctx aws.Context, input *CreateUserPoolClientInput, opts ...request.Option) (*CreateUserPoolClientOutput, error) {
	req, out := c.CreateUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPoolDomain = "CreateUserPoolDomain"

// CreateUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPoolDomain for more information on using the CreateUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolDomainRequest method.
//    req, resp := client.CreateUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain
func (c *CognitoIdentityProvider) CreateUserPoolDomainRequest(input *CreateUserPoolDomainInput) (req *request.Request, output *CreateUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opCreateUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolDomainInput{}
	}

	output = &CreateUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Creates a new domain for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPoolDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain
func (c *CognitoIdentityProvider) CreateUserPoolDomain(input *CreateUserPoolDomainInput) (*CreateUserPoolDomainOutput, error) {
	req, out := c.CreateUserPoolDomainRequest(input)
	return out, req.Send()
}

// CreateUserPoolDomainWithContext is the same as CreateUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolDomainWithContext(ctx aws.Context, input *CreateUserPoolDomainInput, opts ...request.Option) (*CreateUserPoolDomainOutput, error) {
	req, out := c.CreateUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup
func (c *CognitoIdentityProvider) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for Amazon Cognito Identity Provider.
//
// Deletes a group. Currently only groups with no members can be deleted.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup
func (c *CognitoIdentityProvider) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityProvider = "DeleteIdentityProvider"

// DeleteIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityProvider for more information on using the DeleteIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIdentityProviderRequest method.
//    req, resp := client.DeleteIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider
func (c *CognitoIdentityProvider) DeleteIdentityProviderRequest(input *DeleteIdentityProviderInput) (req *request.Request, output *DeleteIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityProviderInput{}
	}

	output = &DeleteIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Deletes an identity provider for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteIdentityProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnsupportedIdentityProviderException "UnsupportedIdentityProviderException"
//   This exception is thrown when the specified identifier is not supported.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider
func (c *CognitoIdentityProvider) DeleteIdentityProvider(input *DeleteIdentityProviderInput) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	return out, req.Send()
}

// DeleteIdentityProviderWithContext is the same as DeleteIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteIdentityProviderWithContext(ctx aws.Context, input *DeleteIdentityProviderInput, opts ...request.Option) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceServer = "DeleteResourceServer"

// DeleteResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceServer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceServer for more information on using the DeleteResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceServerRequest method.
//    req, resp := client.DeleteResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer
func (c *CognitoIdentityProvider) DeleteResourceServerRequest(input *DeleteResourceServerInput) (req *request.Request, output *DeleteResourceServerOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceServerInput{}
	}

	output = &DeleteResourceServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceServer API operation for Amazon Cognito Identity Provider.
//
// Deletes a resource server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteResourceServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer
func (c *CognitoIdentityProvider) DeleteResourceServer(input *DeleteResourceServerInput) (*DeleteResourceServerOutput, error) {
	req, out := c.DeleteResourceServerRequest(input)
	return out, req.Send()
}

// DeleteResourceServerWithContext is the same as DeleteResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteResourceServerWithContext(ctx aws.Context, input *DeleteResourceServerInput, opts ...request.Option) (*DeleteResourceServerOutput, error) {
	req, out := c.DeleteResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser
func (c *CognitoIdentityProvider) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// DeleteUser API operation for Amazon Cognito Identity Provider.
//
// Allows a user to delete himself or herself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser
func (c *CognitoIdentityProvider) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserAttributes = "DeleteUserAttributes"

// DeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserAttributes for more information on using the DeleteUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserAttributesRequest method.
//    req, resp := client.DeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes
func (c *CognitoIdentityProvider) DeleteUserAttributesRequest(input *DeleteUserAttributesInput) (req *request.Request, output *DeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserAttributesInput{}
	}

	output = &DeleteUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// DeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the attributes for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes
func (c *CognitoIdentityProvider) DeleteUserAttributes(input *DeleteUserAttributesInput) (*DeleteUserAttributesOutput, error) {
	req, out := c.DeleteUserAttributesRequest(input)
	return out, req.Send()
}

// DeleteUserAttributesWithContext is the same as DeleteUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserAttributesWithContext(ctx aws.Context, input *DeleteUserAttributesInput, opts ...request.Option) (*DeleteUserAttributesOutput, error) {
	req, out := c.DeleteUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPool = "DeleteUserPool"

// DeleteUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPool operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPool for more information on using the DeleteUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolRequest method.
//    req, resp := client.DeleteUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool
func (c *CognitoIdentityProvider) DeleteUserPoolRequest(input *DeleteUserPoolInput) (req *request.Request, output *DeleteUserPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolInput{}
	}

	output = &DeleteUserPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPool API operation for Amazon Cognito Identity Provider.
//
// Deletes the specified Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserImportInProgressException "UserImportInProgressException"
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool
func (c *CognitoIdentityProvider) DeleteUserPool(input *DeleteUserPoolInput) (*DeleteUserPoolOutput, error) {
	req, out := c.DeleteUserPoolRequest(input)
	return out, req.Send()
}

// DeleteUserPoolWithContext is the same as DeleteUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolWithContext(ctx aws.Context, input *DeleteUserPoolInput, opts ...request.Option) (*DeleteUserPoolOutput, error) {
	req, out := c.DeleteUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPoolClient = "DeleteUserPoolClient"

// DeleteUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPoolClient for more information on using the DeleteUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolClientRequest method.
//    req, resp := client.DeleteUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient
func (c *CognitoIdentityProvider) DeleteUserPoolClientRequest(input *DeleteUserPoolClientInput) (req *request.Request, output *DeleteUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolClientInput{}
	}

	output = &DeleteUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Allows the developer to delete the user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient
func (c *CognitoIdentityProvider) DeleteUserPoolClient(input *DeleteUserPoolClientInput) (*DeleteUserPoolClientOutput, error) {
	req, out := c.DeleteUserPoolClientRequest(input)
	return out, req.Send()
}

// DeleteUserPoolClientWithContext is the same as DeleteUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolClientWithContext(ctx aws.Context, input *DeleteUserPoolClientInput, opts ...request.Option) (*DeleteUserPoolClientOutput, error) {
	req, out := c.DeleteUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPoolDomain = "DeleteUserPoolDomain"

// DeleteUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPoolDomain for more information on using the DeleteUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolDomainRequest method.
//    req, resp := client.DeleteUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain
func (c *CognitoIdentityProvider) DeleteUserPoolDomainRequest(input *DeleteUserPoolDomainInput) (req *request.Request, output *DeleteUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolDomainInput{}
	}

	output = &DeleteUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Deletes a domain for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPoolDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain
func (c *CognitoIdentityProvider) DeleteUserPoolDomain(input *DeleteUserPoolDomainInput) (*DeleteUserPoolDomainOutput, error) {
	req, out := c.DeleteUserPoolDomainRequest(input)
	return out, req.Send()
}

// DeleteUserPoolDomainWithContext is the same as DeleteUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolDomainWithContext(ctx aws.Context, input *DeleteUserPoolDomainInput, opts ...request.Option) (*DeleteUserPoolDomainOutput, error) {
	req, out := c.DeleteUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityProvider = "DescribeIdentityProvider"

// DescribeIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityProvider for more information on using the DescribeIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityProviderRequest method.
//    req, resp := client.DescribeIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider
func (c *CognitoIdentityProvider) DescribeIdentityProviderRequest(input *DescribeIdentityProviderInput) (req *request.Request, output *DescribeIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityProviderInput{}
	}

	output = &DescribeIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Gets information about a specific identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeIdentityProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider
func (c *CognitoIdentityProvider) DescribeIdentityProvider(input *DescribeIdentityProviderInput) (*DescribeIdentityProviderOutput, error) {
	req, out := c.DescribeIdentityProviderRequest(input)
	return out, req.Send()
}

// DescribeIdentityProviderWithContext is the same as DescribeIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeIdentityProviderWithContext(ctx aws.Context, input *DescribeIdentityProviderInput, opts ...request.Option) (*DescribeIdentityProviderOutput, error) {
	req, out := c.DescribeIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceServer = "DescribeResourceServer"

// DescribeResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceServer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceServer for more information on using the DescribeResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceServerRequest method.
//    req, resp := client.DescribeResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer
func (c *CognitoIdentityProvider) DescribeResourceServerRequest(input *DescribeResourceServerInput) (req *request.Request, output *DescribeResourceServerOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceServerInput{}
	}

	output = &DescribeResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceServer API operation for Amazon Cognito Identity Provider.
//
// Describes a resource server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeResourceServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer
func (c *CognitoIdentityProvider) DescribeResourceServer(input *DescribeResourceServerInput) (*DescribeResourceServerOutput, error) {
	req, out := c.DescribeResourceServerRequest(input)
	return out, req.Send()
}

// DescribeResourceServerWithContext is the same as DescribeResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeResourceServerWithContext(ctx aws.Context, input *DescribeResourceServerInput, opts ...request.Option) (*DescribeResourceServerOutput, error) {
	req, out := c.DescribeResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRiskConfiguration = "DescribeRiskConfiguration"

// DescribeRiskConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRiskConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRiskConfiguration for more information on using the DescribeRiskConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRiskConfigurationRequest method.
//    req, resp := client.DescribeRiskConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration
func (c *CognitoIdentityProvider) DescribeRiskConfigurationRequest(input *DescribeRiskConfigurationInput) (req *request.Request, output *DescribeRiskConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeRiskConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRiskConfigurationInput{}
	}

	output = &DescribeRiskConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRiskConfiguration API operation for Amazon Cognito Identity Provider.
//
// Describes the risk configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeRiskConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserPoolAddOnNotEnabledException "UserPoolAddOnNotEnabledException"
//   This exception is thrown when user pool add-ons are not enabled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration
func (c *CognitoIdentityProvider) DescribeRiskConfiguration(input *DescribeRiskConfigurationInput) (*DescribeRiskConfigurationOutput, error) {
	req, out := c.DescribeRiskConfigurationRequest(input)
	return out, req.Send()
}

// DescribeRiskConfigurationWithContext is the same as DescribeRiskConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRiskConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeRiskConfigurationWithContext(ctx aws.Context, input *DescribeRiskConfigurationInput, opts ...request.Option) (*DescribeRiskConfigurationOutput, error) {
	req, out := c.DescribeRiskConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserImportJob = "DescribeUserImportJob"

// DescribeUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserImportJob for more information on using the DescribeUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserImportJobRequest method.
//    req, resp := client.DescribeUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob
func (c *CognitoIdentityProvider) DescribeUserImportJobRequest(input *DescribeUserImportJobInput) (req *request.Request, output *DescribeUserImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserImportJobInput{}
	}

	output = &DescribeUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Describes the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob
func (c *CognitoIdentityProvider) DescribeUserImportJob(input *DescribeUserImportJobInput) (*DescribeUserImportJobOutput, error) {
	req, out := c.DescribeUserImportJobRequest(input)
	return out, req.Send()
}

// DescribeUserImportJobWithContext is the same as DescribeUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserImportJobWithContext(ctx aws.Context, input *DescribeUserImportJobInput, opts ...request.Option) (*DescribeUserImportJobOutput, error) {
	req, out := c.DescribeUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPool = "DescribeUserPool"

// DescribeUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPool operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPool for more information on using the DescribeUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolRequest method.
//    req, resp := client.DescribeUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool
func (c *CognitoIdentityProvider) DescribeUserPoolRequest(input *DescribeUserPoolInput) (req *request.Request, output *DescribeUserPoolOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolInput{}
	}

	output = &DescribeUserPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPool API operation for Amazon Cognito Identity Provider.
//
// Returns the configuration information and metadata of the specified user
// pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserPoolTaggingException "UserPoolTaggingException"
//   This exception is thrown when a user pool tag cannot be set or updated.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool
func (c *CognitoIdentityProvider) DescribeUserPool(input *DescribeUserPoolInput) (*DescribeUserPoolOutput, error) {
	req, out := c.DescribeUserPoolRequest(input)
	return out, req.Send()
}

// DescribeUserPoolWithContext is the same as DescribeUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolWithContext(ctx aws.Context, input *DescribeUserPoolInput, opts ...request.Option) (*DescribeUserPoolOutput, error) {
	req, out := c.DescribeUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPoolClient = "DescribeUserPoolClient"

// DescribeUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPoolClient for more information on using the DescribeUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolClientRequest method.
//    req, resp := client.DescribeUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient
func (c *CognitoIdentityProvider) DescribeUserPoolClientRequest(input *DescribeUserPoolClientInput) (req *request.Request, output *DescribeUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolClientInput{}
	}

	output = &DescribeUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Client method for returning the configuration information and metadata of
// the specified user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient
func (c *CognitoIdentityProvider) DescribeUserPoolClient(input *DescribeUserPoolClientInput) (*DescribeUserPoolClientOutput, error) {
	req, out := c.DescribeUserPoolClientRequest(input)
	return out, req.Send()
}

// DescribeUserPoolClientWithContext is the same as DescribeUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolClientWithContext(ctx aws.Context, input *DescribeUserPoolClientInput, opts ...request.Option) (*DescribeUserPoolClientOutput, error) {
	req, out := c.DescribeUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPoolDomain = "DescribeUserPoolDomain"

// DescribeUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPoolDomain for more information on using the DescribeUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolDomainRequest method.
//    req, resp := client.DescribeUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain
func (c *CognitoIdentityProvider) DescribeUserPoolDomainRequest(input *DescribeUserPoolDomainInput) (req *request.Request, output *DescribeUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolDomainInput{}
	}

	output = &DescribeUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Gets information about a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPoolDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain
func (c *CognitoIdentityProvider) DescribeUserPoolDomain(input *DescribeUserPoolDomainInput) (*DescribeUserPoolDomainOutput, error) {
	req, out := c.DescribeUserPoolDomainRequest(input)
	return out, req.Send()
}

// DescribeUserPoolDomainWithContext is the same as DescribeUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolDomainWithContext(ctx aws.Context, input *DescribeUserPoolDomainInput, opts ...request.Option) (*DescribeUserPoolDomainOutput, error) {
	req, out := c.DescribeUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opForgetDevice = "ForgetDevice"

// ForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ForgetDevice operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ForgetDevice for more information on using the ForgetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ForgetDeviceRequest method.
//    req, resp := client.ForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice
func (c *CognitoIdentityProvider) ForgetDeviceRequest(input *ForgetDeviceInput) (req *request.Request, output *ForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgetDeviceInput{}
	}

	output = &ForgetDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the specified device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice
func (c *CognitoIdentityProvider) ForgetDevice(input *ForgetDeviceInput) (*ForgetDeviceOutput, error) {
	req, out := c.ForgetDeviceRequest(input)
	return out, req.Send()
}

// ForgetDeviceWithContext is the same as ForgetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ForgetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ForgetDeviceWithContext(ctx aws.Context, input *ForgetDeviceInput, opts ...request.Option) (*ForgetDeviceOutput, error) {
	req, out := c.ForgetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opForgotPassword = "ForgotPassword"

// ForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ForgotPassword operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ForgotPassword for more information on using the ForgotPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ForgotPasswordRequest method.
//    req, resp := client.ForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword
func (c *CognitoIdentityProvider) ForgotPasswordRequest(input *ForgotPasswordInput) (req *request.Request, output *ForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgotPasswordInput{}
	}

	output = &ForgotPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Calling this API causes a message to be sent to the end user with a confirmation
// code that is required to change the user's password. For the Username parameter,
// you can use the username or user alias. If a verified phone number exists
// for the user, the confirmation code is sent to the phone number. Otherwise,
// if a verified email exists, the confirmation code is sent to the email. If
// neither a verified phone number nor a verified email exists, InvalidParameterException
// is thrown. To use the confirmation code for resetting the password, call
// .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgotPassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword
func (c *CognitoIdentityProvider) ForgotPassword(input *ForgotPasswordInput) (*ForgotPasswordOutput, error) {
	req, out := c.ForgotPasswordRequest(input)
	return out, req.Send()
}

// ForgotPasswordWithContext is the same as ForgotPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ForgotPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ForgotPasswordWithContext(ctx aws.Context, input *ForgotPasswordInput, opts ...request.Option) (*ForgotPasswordOutput, error) {
	req, out := c.ForgotPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCSVHeader = "GetCSVHeader"

// GetCSVHeaderRequest generates a "aws/request.Request" representing the
// client's request for the GetCSVHeader operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCSVHeader for more information on using the GetCSVHeader
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCSVHeaderRequest method.
//    req, resp := client.GetCSVHeaderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader
func (c *CognitoIdentityProvider) GetCSVHeaderRequest(input *GetCSVHeaderInput) (req *request.Request, output *GetCSVHeaderOutput) {
	op := &request.Operation{
		Name:       opGetCSVHeader,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCSVHeaderInput{}
	}

	output = &GetCSVHeaderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCSVHeader API operation for Amazon Cognito Identity Provider.
//
// Gets the header information for the .csv file to be used as input for the
// user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetCSVHeader for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader
func (c *CognitoIdentityProvider) GetCSVHeader(input *GetCSVHeaderInput) (*GetCSVHeaderOutput, error) {
	req, out := c.GetCSVHeaderRequest(input)
	return out, req.Send()
}

// GetCSVHeaderWithContext is the same as GetCSVHeader with the addition of
// the ability to pass a context and additional request options.
//
// See GetCSVHeader for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetCSVHeaderWithContext(ctx aws.Context, input *GetCSVHeaderInput, opts ...request.Option) (*GetCSVHeaderOutput, error) {
	req, out := c.GetCSVHeaderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice
func (c *CognitoIdentityProvider) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice
func (c *CognitoIdentityProvider) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup
func (c *CognitoIdentityProvider) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for Amazon Cognito Identity Provider.
//
// Gets a group.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup
func (c *CognitoIdentityProvider) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityProviderByIdentifier = "GetIdentityProviderByIdentifier"

// GetIdentityProviderByIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityProviderByIdentifier operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityProviderByIdentifier for more information on using the GetIdentityProviderByIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIdentityProviderByIdentifierRequest method.
//    req, resp := client.GetIdentityProviderByIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifierRequest(input *GetIdentityProviderByIdentifierInput) (req *request.Request, output *GetIdentityProviderByIdentifierOutput) {
	op := &request.Operation{
		Name:       opGetIdentityProviderByIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityProviderByIdentifierInput{}
	}

	output = &GetIdentityProviderByIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityProviderByIdentifier API operation for Amazon Cognito Identity Provider.
//
// Gets the specified identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetIdentityProviderByIdentifier for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifier(input *GetIdentityProviderByIdentifierInput) (*GetIdentityProviderByIdentifierOutput, error) {
	req, out := c.GetIdentityProviderByIdentifierRequest(input)
	return out, req.Send()
}

// GetIdentityProviderByIdentifierWithContext is the same as GetIdentityProviderByIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityProviderByIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifierWithContext(ctx aws.Context, input *GetIdentityProviderByIdentifierInput, opts ...request.Option) (*GetIdentityProviderByIdentifierOutput, error) {
	req, out := c.GetIdentityProviderByIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningCertificate = "GetSigningCertificate"

// GetSigningCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningCertificate for more information on using the GetSigningCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningCertificateRequest method.
//    req, resp := client.GetSigningCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate
func (c *CognitoIdentityProvider) GetSigningCertificateRequest(input *GetSigningCertificateInput) (req *request.Request, output *GetSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opGetSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSigningCertificateInput{}
	}

	output = &GetSigningCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningCertificate API operation for Amazon Cognito Identity Provider.
//
// This method takes a user pool ID, and returns the signing certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetSigningCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate
func (c *CognitoIdentityProvider) GetSigningCertificate(input *GetSigningCertificateInput) (*GetSigningCertificateOutput, error) {
	req, out := c.GetSigningCertificateRequest(input)
	return out, req.Send()
}

// GetSigningCertificateWithContext is the same as GetSigningCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetSigningCertificateWithContext(ctx aws.Context, input *GetSigningCertificateInput, opts ...request.Option) (*GetSigningCertificateOutput, error) {
	req, out := c.GetSigningCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUICustomization = "GetUICustomization"

// GetUICustomizationRequest generates a "aws/request.Request" representing the
// client's request for the GetUICustomization operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUICustomization for more information on using the GetUICustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUICustomizationRequest method.
//    req, resp := client.GetUICustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization
func (c *CognitoIdentityProvider) GetUICustomizationRequest(input *GetUICustomizationInput) (req *request.Request, output *GetUICustomizationOutput) {
	op := &request.Operation{
		Name:       opGetUICustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUICustomizationInput{}
	}

	output = &GetUICustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUICustomization API operation for Amazon Cognito Identity Provider.
//
// Gets the UI Customization information for a particular app client's app UI,
// if there is something set. If nothing is set for the particular client, but
// there is an existing pool level customization (app clientId will be ALL),
// then that is returned. If nothing is present, then an empty shape is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUICustomization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization
func (c *CognitoIdentityProvider) GetUICustomization(input *GetUICustomizationInput) (*GetUICustomizationOutput, error) {
	req, out := c.GetUICustomizationRequest(input)
	return out, req.Send()
}

// GetUICustomizationWithContext is the same as GetUICustomization with the addition of
// the ability to pass a context and additional request options.
//
// See GetUICustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUICustomizationWithContext(ctx aws.Context, input *GetUICustomizationInput, opts ...request.Option) (*GetUICustomizationOutput, error) {
	req, out := c.GetUICustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser
func (c *CognitoIdentityProvider) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// GetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the user attributes and metadata for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser
func (c *CognitoIdentityProvider) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserAttributeVerificationCode = "GetUserAttributeVerificationCode"

// GetUserAttributeVerificationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetUserAttributeVerificationCode operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserAttributeVerificationCode for more information on using the GetUserAttributeVerificationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserAttributeVerificationCodeRequest method.
//    req, resp := client.GetUserAttributeVerificationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCodeRequest(input *GetUserAttributeVerificationCodeInput) (req *request.Request, output *GetUserAttributeVerificationCodeOutput) {
	op := &request.Operation{
		Name:       opGetUserAttributeVerificationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserAttributeVerificationCodeInput{}
	}

	output = &GetUserAttributeVerificationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// GetUserAttributeVerificationCode API operation for Amazon Cognito Identity Provider.
//
// Gets the user attribute verification code for the specified attribute name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUserAttributeVerificationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCode(input *GetUserAttributeVerificationCodeInput) (*GetUserAttributeVerificationCodeOutput, error) {
	req, out := c.GetUserAttributeVerificationCodeRequest(input)
	return out, req.Send()
}

// GetUserAttributeVerificationCodeWithContext is the same as GetUserAttributeVerificationCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserAttributeVerificationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCodeWithContext(ctx aws.Context, input *GetUserAttributeVerificationCodeInput, opts ...request.Option) (*GetUserAttributeVerificationCodeOutput, error) {
	req, out := c.GetUserAttributeVerificationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserPoolMfaConfig = "GetUserPoolMfaConfig"

// GetUserPoolMfaConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetUserPoolMfaConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserPoolMfaConfig for more information on using the GetUserPoolMfaConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserPoolMfaConfigRequest method.
//    req, resp := client.GetUserPoolMfaConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig
func (c *CognitoIdentityProvider) GetUserPoolMfaConfigRequest(input *GetUserPoolMfaConfigInput) (req *request.Request, output *GetUserPoolMfaConfigOutput) {
	op := &request.Operation{
		Name:       opGetUserPoolMfaConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserPoolMfaConfigInput{}
	}

	output = &GetUserPoolMfaConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserPoolMfaConfig API operation for Amazon Cognito Identity Provider.
//
// Gets the user pool multi-factor authentication (MFA) configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUserPoolMfaConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig
func (c *CognitoIdentityProvider) GetUserPoolMfaConfig(input *GetUserPoolMfaConfigInput) (*GetUserPoolMfaConfigOutput, error) {
	req, out := c.GetUserPoolMfaConfigRequest(input)
	return out, req.Send()
}

// GetUserPoolMfaConfigWithContext is the same as GetUserPoolMfaConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserPoolMfaConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserPoolMfaConfigWithContext(ctx aws.Context, input *GetUserPoolMfaConfigInput, opts ...request.Option) (*GetUserPoolMfaConfigOutput, error) {
	req, out := c.GetUserPoolMfaConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGlobalSignOut = "GlobalSignOut"

// GlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the GlobalSignOut operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GlobalSignOut for more information on using the GlobalSignOut
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GlobalSignOutRequest method.
//    req, resp := client.GlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut
func (c *CognitoIdentityProvider) GlobalSignOutRequest(input *GlobalSignOutInput) (req *request.Request, output *GlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GlobalSignOutInput{}
	}

	output = &GlobalSignOutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GlobalSignOut for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut
func (c *CognitoIdentityProvider) GlobalSignOut(input *GlobalSignOutInput) (*GlobalSignOutOutput, error) {
	req, out := c.GlobalSignOutRequest(input)
	return out, req.Send()
}

// GlobalSignOutWithContext is the same as GlobalSignOut with the addition of
// the ability to pass a context and additional request options.
//
// See GlobalSignOut for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GlobalSignOutWithContext(ctx aws.Context, input *GlobalSignOutInput, opts ...request.Option) (*GlobalSignOutOutput, error) {
	req, out := c.GlobalSignOutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateAuth = "InitiateAuth"

// InitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the InitiateAuth operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateAuth for more information on using the InitiateAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateAuthRequest method.
//    req, resp := client.InitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth
func (c *CognitoIdentityProvider) InitiateAuthRequest(input *InitiateAuthInput) (req *request.Request, output *InitiateAuthOutput) {
	op := &request.Operation{
		Name:       opInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateAuthInput{}
	}

	output = &InitiateAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation InitiateAuth for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth
func (c *CognitoIdentityProvider) InitiateAuth(input *InitiateAuthInput) (*InitiateAuthOutput, error) {
	req, out := c.InitiateAuthRequest(input)
	return out, req.Send()
}

// InitiateAuthWithContext is the same as InitiateAuth with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) InitiateAuthWithContext(ctx aws.Context, input *InitiateAuthInput, opts ...request.Option) (*InitiateAuthOutput, error) {
	req, out := c.InitiateAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices
func (c *CognitoIdentityProvider) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists the devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListDevices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices
func (c *CognitoIdentityProvider) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups
func (c *CognitoIdentityProvider) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon Cognito Identity Provider.
//
// Lists the groups associated with a user pool.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups
func (c *CognitoIdentityProvider) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentityProviders = "ListIdentityProviders"

// ListIdentityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviders operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviders for more information on using the ListIdentityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIdentityProvidersRequest method.
//    req, resp := client.ListIdentityProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders
func (c *CognitoIdentityProvider) ListIdentityProvidersRequest(input *ListIdentityProvidersInput) (req *request.Request, output *ListIdentityProvidersOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityProvidersInput{}
	}

	output = &ListIdentityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviders API operation for Amazon Cognito Identity Provider.
//
// Lists information about all identity providers for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListIdentityProviders for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders
func (c *CognitoIdentityProvider) ListIdentityProviders(input *ListIdentityProvidersInput) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	return out, req.Send()
}

// ListIdentityProvidersWithContext is the same as ListIdentityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListIdentityProvidersWithContext(ctx aws.Context, input *ListIdentityProvidersInput, opts ...request.Option) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceServers = "ListResourceServers"

// ListResourceServersRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceServers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceServers for more information on using the ListResourceServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceServersRequest method.
//    req, resp := client.ListResourceServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers
func (c *CognitoIdentityProvider) ListResourceServersRequest(input *ListResourceServersInput) (req *request.Request, output *ListResourceServersOutput) {
	op := &request.Operation{
		Name:       opListResourceServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceServersInput{}
	}

	output = &ListResourceServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceServers API operation for Amazon Cognito Identity Provider.
//
// Lists the resource servers for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListResourceServers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers
func (c *CognitoIdentityProvider) ListResourceServers(input *ListResourceServersInput) (*ListResourceServersOutput, error) {
	req, out := c.ListResourceServersRequest(input)
	return out, req.Send()
}

// ListResourceServersWithContext is the same as ListResourceServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListResourceServersWithContext(ctx aws.Context, input *ListResourceServersInput, opts ...request.Option) (*ListResourceServersOutput, error) {
	req, out := c.ListResourceServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserImportJobs = "ListUserImportJobs"

// ListUserImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserImportJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserImportJobs for more information on using the ListUserImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserImportJobsRequest method.
//    req, resp := client.ListUserImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs
func (c *CognitoIdentityProvider) ListUserImportJobsRequest(input *ListUserImportJobsInput) (req *request.Request, output *ListUserImportJobsOutput) {
	op := &request.Operation{
		Name:       opListUserImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserImportJobsInput{}
	}

	output = &ListUserImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserImportJobs API operation for Amazon Cognito Identity Provider.
//
// Lists the user import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs
func (c *CognitoIdentityProvider) ListUserImportJobs(input *ListUserImportJobsInput) (*ListUserImportJobsOutput, error) {
	req, out := c.ListUserImportJobsRequest(input)
	return out, req.Send()
}

// ListUserImportJobsWithContext is the same as ListUserImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserImportJobsWithContext(ctx aws.Context, input *ListUserImportJobsInput, opts ...request.Option) (*ListUserImportJobsOutput, error) {
	req, out := c.ListUserImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserPoolClients = "ListUserPoolClients"

// ListUserPoolClientsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPoolClients operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserPoolClients for more information on using the ListUserPoolClients
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserPoolClientsRequest method.
//    req, resp := client.ListUserPoolClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients
func (c *CognitoIdentityProvider) ListUserPoolClientsRequest(input *ListUserPoolClientsInput) (req *request.Request, output *ListUserPoolClientsOutput) {
	op := &request.Operation{
		Name:       opListUserPoolClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserPoolClientsInput{}
	}

	output = &ListUserPoolClientsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserPoolClients API operation for Amazon Cognito Identity Provider.
//
// Lists the clients that have been created for the specified user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPoolClients for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients
func (c *CognitoIdentityProvider) ListUserPoolClients(input *ListUserPoolClientsInput) (*ListUserPoolClientsOutput, error) {
	req, out := c.ListUserPoolClientsRequest(input)
	return out, req.Send()
}

// ListUserPoolClientsWithContext is the same as ListUserPoolClients with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserPoolClients for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolClientsWithContext(ctx aws.Context, input *ListUserPoolClientsInput, opts ...request.Option) (*ListUserPoolClientsOutput, error) {
	req, out := c.ListUserPoolClientsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserPools = "ListUserPools"

// ListUserPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPools operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserPools for more information on using the ListUserPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserPoolsRequest method.
//    req, resp := client.ListUserPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools
func (c *CognitoIdentityProvider) ListUserPoolsRequest(input *ListUserPoolsInput) (req *request.Request, output *ListUserPoolsOutput) {
	op := &request.Operation{
		Name:       opListUserPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserPoolsInput{}
	}

	output = &ListUserPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserPools API operation for Amazon Cognito Identity Provider.
//
// Lists the user pools associated with an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPools for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools
func (c *CognitoIdentityProvider) ListUserPools(input *ListUserPoolsInput) (*ListUserPoolsOutput, error) {
	req, out := c.ListUserPoolsRequest(input)
	return out, req.Send()
}

// ListUserPoolsWithContext is the same as ListUserPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolsWithContext(ctx aws.Context, input *ListUserPoolsInput, opts ...request.Option) (*ListUserPoolsOutput, error) {
	req, out := c.ListUserPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers
func (c *CognitoIdentityProvider) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Cognito Identity Provider.
//
// Lists the users in the Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers
func (c *CognitoIdentityProvider) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsersInGroup = "ListUsersInGroup"

// ListUsersInGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListUsersInGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsersInGroup for more information on using the ListUsersInGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersInGroupRequest method.
//    req, resp := client.ListUsersInGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup
func (c *CognitoIdentityProvider) ListUsersInGroupRequest(input *ListUsersInGroupInput) (req *request.Request, output *ListUsersInGroupOutput) {
	op := &request.Operation{
		Name:       opListUsersInGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsersInGroupInput{}
	}

	output = &ListUsersInGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsersInGroup API operation for Amazon Cognito Identity Provider.
//
// Lists the users in the specified group.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUsersInGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup
func (c *CognitoIdentityProvider) ListUsersInGroup(input *ListUsersInGroupInput) (*ListUsersInGroupOutput, error) {
	req, out := c.ListUsersInGroupRequest(input)
	return out, req.Send()
}

// ListUsersInGroupWithContext is the same as ListUsersInGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsersInGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersInGroupWithContext(ctx aws.Context, input *ListUsersInGroupInput, opts ...request.Option) (*ListUsersInGroupOutput, error) {
	req, out := c.ListUsersInGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResendConfirmationCode = "ResendConfirmationCode"

// ResendConfirmationCodeRequest generates a "aws/request.Request" representing the
// client's request for the ResendConfirmationCode operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResendConfirmationCode for more information on using the ResendConfirmationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResendConfirmationCodeRequest method.
//    req, resp := client.ResendConfirmationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode
func (c *CognitoIdentityProvider) ResendConfirmationCodeRequest(input *ResendConfirmationCodeInput) (req *request.Request, output *ResendConfirmationCodeOutput) {
	op := &request.Operation{
		Name:       opResendConfirmationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendConfirmationCodeInput{}
	}

	output = &ResendConfirmationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ResendConfirmationCode API operation for Amazon Cognito Identity Provider.
//
// Resends the confirmation (for confirmation of registration) to a specific
// user in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ResendConfirmationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode
func (c *CognitoIdentityProvider) ResendConfirmationCode(input *ResendConfirmationCodeInput) (*ResendConfirmationCodeOutput, error) {
	req, out := c.ResendConfirmationCodeRequest(input)
	return out, req.Send()
}

// ResendConfirmationCodeWithContext is the same as ResendConfirmationCode with the addition of
// the ability to pass a context and additional request options.
//
// See ResendConfirmationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ResendConfirmationCodeWithContext(ctx aws.Context, input *ResendConfirmationCodeInput, opts ...request.Option) (*ResendConfirmationCodeOutput, error) {
	req, out := c.ResendConfirmationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondToAuthChallenge = "RespondToAuthChallenge"

// RespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the RespondToAuthChallenge operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondToAuthChallenge for more information on using the RespondToAuthChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondToAuthChallengeRequest method.
//    req, resp := client.RespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge
func (c *CognitoIdentityProvider) RespondToAuthChallengeRequest(input *RespondToAuthChallengeInput) (req *request.Request, output *RespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondToAuthChallengeInput{}
	}

	output = &RespondToAuthChallengeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to the authentication challenge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation RespondToAuthChallenge for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeMFAMethodNotFoundException "MFAMethodNotFoundException"
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeSoftwareTokenMFANotFoundException "SoftwareTokenMFANotFoundException"
//   This exception is thrown when the software token TOTP multi-factor authentication
//   (MFA) is not enabled for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge
func (c *CognitoIdentityProvider) RespondToAuthChallenge(input *RespondToAuthChallengeInput) (*RespondToAuthChallengeOutput, error) {
	req, out := c.RespondToAuthChallengeRequest(input)
	return out, req.Send()
}

// RespondToAuthChallengeWithContext is the same as RespondToAuthChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See RespondToAuthChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) RespondToAuthChallengeWithContext(ctx aws.Context, input *RespondToAuthChallengeInput, opts ...request.Option) (*RespondToAuthChallengeOutput, error) {
	req, out := c.RespondToAuthChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetRiskConfiguration = "SetRiskConfiguration"

// SetRiskConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the SetRiskConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetRiskConfiguration for more information on using the SetRiskConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetRiskConfigurationRequest method.
//    req, resp := client.SetRiskConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration
func (c *CognitoIdentityProvider) SetRiskConfigurationRequest(input *SetRiskConfigurationInput) (req *request.Request, output *SetRiskConfigurationOutput) {
	op := &request.Operation{
		Name:       opSetRiskConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRiskConfigurationInput{}
	}

	output = &SetRiskConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetRiskConfiguration API operation for Amazon Cognito Identity Provider.
//
// Configures actions on detected risks. To delete the risk configuration for
// UserPoolId or ClientId, pass null values for all four configuration types.
//
// To enable Amazon Cognito advanced security features, update the user pool
// to include the UserPoolAddOns keyAdvancedSecurityMode.
//
// See .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetRiskConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserPoolAddOnNotEnabledException "UserPoolAddOnNotEnabledException"
//   This exception is thrown when user pool add-ons are not enabled.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration
func (c *CognitoIdentityProvider) SetRiskConfiguration(input *SetRiskConfigurationInput) (*SetRiskConfigurationOutput, error) {
	req, out := c.SetRiskConfigurationRequest(input)
	return out, req.Send()
}

// SetRiskConfigurationWithContext is the same as SetRiskConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See SetRiskConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetRiskConfigurationWithContext(ctx aws.Context, input *SetRiskConfigurationInput, opts ...request.Option) (*SetRiskConfigurationOutput, error) {
	req, out := c.SetRiskConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUICustomization = "SetUICustomization"

// SetUICustomizationRequest generates a "aws/request.Request" representing the
// client's request for the SetUICustomization operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUICustomization for more information on using the SetUICustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUICustomizationRequest method.
//    req, resp := client.SetUICustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization
func (c *CognitoIdentityProvider) SetUICustomizationRequest(input *SetUICustomizationInput) (req *request.Request, output *SetUICustomizationOutput) {
	op := &request.Operation{
		Name:       opSetUICustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUICustomizationInput{}
	}

	output = &SetUICustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetUICustomization API operation for Amazon Cognito Identity Provider.
//
// Sets the UI customization information for a user pool's built-in app UI.
//
// You can specify app UI customization settings for a single client (with a
// specific clientId) or for all clients (by setting the clientId to ALL). If
// you specify ALL, the default configuration will be used for every client
// that has no UI customization set previously. If you specify UI customization
// settings for a particular client, it will no longer fall back to the ALL
// configuration.
//
// To use this API, your user pool must have a domain associated with it. Otherwise,
// there is no place to host the app's pages, and the service will throw an
// error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUICustomization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization
func (c *CognitoIdentityProvider) SetUICustomization(input *SetUICustomizationInput) (*SetUICustomizationOutput, error) {
	req, out := c.SetUICustomizationRequest(input)
	return out, req.Send()
}

// SetUICustomizationWithContext is the same as SetUICustomization with the addition of
// the ability to pass a context and additional request options.
//
// See SetUICustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUICustomizationWithContext(ctx aws.Context, input *SetUICustomizationInput, opts ...request.Option) (*SetUICustomizationOutput, error) {
	req, out := c.SetUICustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserMFAPreference = "SetUserMFAPreference"

// SetUserMFAPreferenceRequest generates a "aws/request.Request" representing the
// client's request for the SetUserMFAPreference operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserMFAPreference for more information on using the SetUserMFAPreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserMFAPreferenceRequest method.
//    req, resp := client.SetUserMFAPreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference
func (c *CognitoIdentityProvider) SetUserMFAPreferenceRequest(input *SetUserMFAPreferenceInput) (req *request.Request, output *SetUserMFAPreferenceOutput) {
	op := &request.Operation{
		Name:       opSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserMFAPreferenceInput{}
	}

	output = &SetUserMFAPreferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetUserMFAPreference API operation for Amazon Cognito Identity Provider.
//
// Set the user's multi-factor authentication (MFA) method preference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserMFAPreference for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference
func (c *CognitoIdentityProvider) SetUserMFAPreference(input *SetUserMFAPreferenceInput) (*SetUserMFAPreferenceOutput, error) {
	req, out := c.SetUserMFAPreferenceRequest(input)
	return out, req.Send()
}

// SetUserMFAPreferenceWithContext is the same as SetUserMFAPreference with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserMFAPreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserMFAPreferenceWithContext(ctx aws.Context, input *SetUserMFAPreferenceInput, opts ...request.Option) (*SetUserMFAPreferenceOutput, error) {
	req, out := c.SetUserMFAPreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserPoolMfaConfig = "SetUserPoolMfaConfig"

// SetUserPoolMfaConfigRequest generates a "aws/request.Request" representing the
// client's request for the SetUserPoolMfaConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserPoolMfaConfig for more information on using the SetUserPoolMfaConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserPoolMfaConfigRequest method.
//    req, resp := client.SetUserPoolMfaConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig
func (c *CognitoIdentityProvider) SetUserPoolMfaConfigRequest(input *SetUserPoolMfaConfigInput) (req *request.Request, output *SetUserPoolMfaConfigOutput) {
	op := &request.Operation{
		Name:       opSetUserPoolMfaConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserPoolMfaConfigInput{}
	}

	output = &SetUserPoolMfaConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetUserPoolMfaConfig API operation for Amazon Cognito Identity Provider.
//
// Set the user pool MFA configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserPoolMfaConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig
func (c *CognitoIdentityProvider) SetUserPoolMfaConfig(input *SetUserPoolMfaConfigInput) (*SetUserPoolMfaConfigOutput, error) {
	req, out := c.SetUserPoolMfaConfigRequest(input)
	return out, req.Send()
}

// SetUserPoolMfaConfigWithContext is the same as SetUserPoolMfaConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserPoolMfaConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserPoolMfaConfigWithContext(ctx aws.Context, input *SetUserPoolMfaConfigInput, opts ...request.Option) (*SetUserPoolMfaConfigOutput, error) {
	req, out := c.SetUserPoolMfaConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserSettings = "SetUserSettings"

// SetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the SetUserSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserSettings for more information on using the SetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserSettingsRequest method.
//    req, resp := client.SetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings
func (c *CognitoIdentityProvider) SetUserSettingsRequest(input *SetUserSettingsInput) (req *request.Request, output *SetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserSettingsInput{}
	}

	output = &SetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// SetUserSettings API operation for Amazon Cognito Identity Provider.
//
// Sets the user settings like multi-factor authentication (MFA). If MFA is
// to be removed for a particular attribute pass the attribute with code delivery
// as null. If null list is passed, all MFA options are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings
func (c *CognitoIdentityProvider) SetUserSettings(input *SetUserSettingsInput) (*SetUserSettingsOutput, error) {
	req, out := c.SetUserSettingsRequest(input)
	return out, req.Send()
}

// SetUserSettingsWithContext is the same as SetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserSettingsWithContext(ctx aws.Context, input *SetUserSettingsInput, opts ...request.Option) (*SetUserSettingsOutput, error) {
	req, out := c.SetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignUp = "SignUp"

// SignUpRequest generates a "aws/request.Request" representing the
// client's request for the SignUp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignUp for more information on using the SignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SignUpRequest method.
//    req, resp := client.SignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp
func (c *CognitoIdentityProvider) SignUpRequest(input *SignUpInput) (req *request.Request, output *SignUpOutput) {
	op := &request.Operation{
		Name:       opSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignUpInput{}
	}

	output = &SignUpOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// SignUp API operation for Amazon Cognito Identity Provider.
//
// Registers the user in the specified user pool and creates a user name, password,
// and user attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SignUp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeUsernameExistsException "UsernameExistsException"
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp
func (c *CognitoIdentityProvider) SignUp(input *SignUpInput) (*SignUpOutput, error) {
	req, out := c.SignUpRequest(input)
	return out, req.Send()
}

// SignUpWithContext is the same as SignUp with the addition of
// the ability to pass a context and additional request options.
//
// See SignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SignUpWithContext(ctx aws.Context, input *SignUpInput, opts ...request.Option) (*SignUpOutput, error) {
	req, out := c.SignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartUserImportJob = "StartUserImportJob"

// StartUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartUserImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartUserImportJob for more information on using the StartUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartUserImportJobRequest method.
//    req, resp := client.StartUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob
func (c *CognitoIdentityProvider) StartUserImportJobRequest(input *StartUserImportJobInput) (req *request.Request, output *StartUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStartUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartUserImportJobInput{}
	}

	output = &StartUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Starts the user import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StartUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   This exception is thrown when a precondition is not met.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob
func (c *CognitoIdentityProvider) StartUserImportJob(input *StartUserImportJobInput) (*StartUserImportJobOutput, error) {
	req, out := c.StartUserImportJobRequest(input)
	return out, req.Send()
}

// StartUserImportJobWithContext is the same as StartUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) StartUserImportJobWithContext(ctx aws.Context, input *StartUserImportJobInput, opts ...request.Option) (*StartUserImportJobOutput, error) {
	req, out := c.StartUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopUserImportJob = "StopUserImportJob"

// StopUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StopUserImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopUserImportJob for more information on using the StopUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopUserImportJobRequest method.
//    req, resp := client.StopUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob
func (c *CognitoIdentityProvider) StopUserImportJobRequest(input *StopUserImportJobInput) (req *request.Request, output *StopUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStopUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopUserImportJobInput{}
	}

	output = &StopUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Stops the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StopUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   This exception is thrown when a precondition is not met.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob
func (c *CognitoIdentityProvider) StopUserImportJob(input *StopUserImportJobInput) (*StopUserImportJobOutput, error) {
	req, out := c.StopUserImportJobRequest(input)
	return out, req.Send()
}

// StopUserImportJobWithContext is the same as StopUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) StopUserImportJobWithContext(ctx aws.Context, input *StopUserImportJobInput, opts ...request.Option) (*StopUserImportJobOutput, error) {
	req, out := c.StopUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthEventFeedback = "UpdateAuthEventFeedback"

// UpdateAuthEventFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthEventFeedback operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthEventFeedback for more information on using the UpdateAuthEventFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthEventFeedbackRequest method.
//    req, resp := client.UpdateAuthEventFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback
func (c *CognitoIdentityProvider) UpdateAuthEventFeedbackRequest(input *UpdateAuthEventFeedbackInput) (req *request.Request, output *UpdateAuthEventFeedbackOutput) {
	op := &request.Operation{
		Name:       opUpdateAuthEventFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAuthEventFeedbackInput{}
	}

	output = &UpdateAuthEventFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAuthEventFeedback API operation for Amazon Cognito Identity Provider.
//
// Provides the feedback for an authentication event whether it was from a valid
// user or not. This feedback is used for improving the risk evaluation decision
// for the user pool as part of Amazon Cognito advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateAuthEventFeedback for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserPoolAddOnNotEnabledException "UserPoolAddOnNotEnabledException"
//   This exception is thrown when user pool add-ons are not enabled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback
func (c *CognitoIdentityProvider) UpdateAuthEventFeedback(input *UpdateAuthEventFeedbackInput) (*UpdateAuthEventFeedbackOutput, error) {
	req, out := c.UpdateAuthEventFeedbackRequest(input)
	return out, req.Send()
}

// UpdateAuthEventFeedbackWithContext is the same as UpdateAuthEventFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthEventFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateAuthEventFeedbackWithContext(ctx aws.Context, input *UpdateAuthEventFeedbackInput, opts ...request.Option) (*UpdateAuthEventFeedbackOutput, error) {
	req, out := c.UpdateAuthEventFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceStatus = "UpdateDeviceStatus"

// UpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceStatus for more information on using the UpdateDeviceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceStatusRequest method.
//    req, resp := client.UpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus
func (c *CognitoIdentityProvider) UpdateDeviceStatusRequest(input *UpdateDeviceStatusInput) (req *request.Request, output *UpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceStatusInput{}
	}

	output = &UpdateDeviceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateDeviceStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus
func (c *CognitoIdentityProvider) UpdateDeviceStatus(input *UpdateDeviceStatusInput) (*UpdateDeviceStatusOutput, error) {
	req, out := c.UpdateDeviceStatusRequest(input)
	return out, req.Send()
}

// UpdateDeviceStatusWithContext is the same as UpdateDeviceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateDeviceStatusWithContext(ctx aws.Context, input *UpdateDeviceStatusInput, opts ...request.Option) (*UpdateDeviceStatusOutput, error) {
	req, out := c.UpdateDeviceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup
func (c *CognitoIdentityProvider) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon Cognito Identity Provider.
//
// Updates the specified group with the specified attributes.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup
func (c *CognitoIdentityProvider) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityProvider = "UpdateIdentityProvider"

// UpdateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityProvider for more information on using the UpdateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIdentityProviderRequest method.
//    req, resp := client.UpdateIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider
func (c *CognitoIdentityProvider) UpdateIdentityProviderRequest(input *UpdateIdentityProviderInput) (req *request.Request, output *UpdateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIdentityProviderInput{}
	}

	output = &UpdateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Updates identity provider information for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateIdentityProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeUnsupportedIdentityProviderException "UnsupportedIdentityProviderException"
//   This exception is thrown when the specified identifier is not supported.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider
func (c *CognitoIdentityProvider) UpdateIdentityProvider(input *UpdateIdentityProviderInput) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	return out, req.Send()
}

// UpdateIdentityProviderWithContext is the same as UpdateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateIdentityProviderWithContext(ctx aws.Context, input *UpdateIdentityProviderInput, opts ...request.Option) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceServer = "UpdateResourceServer"

// UpdateResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceServer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceServer for more information on using the UpdateResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceServerRequest method.
//    req, resp := client.UpdateResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer
func (c *CognitoIdentityProvider) UpdateResourceServerRequest(input *UpdateResourceServerInput) (req *request.Request, output *UpdateResourceServerOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceServerInput{}
	}

	output = &UpdateResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceServer API operation for Amazon Cognito Identity Provider.
//
// Updates the name and scopes of resource server. All other fields are read-only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateResourceServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer
func (c *CognitoIdentityProvider) UpdateResourceServer(input *UpdateResourceServerInput) (*UpdateResourceServerOutput, error) {
	req, out := c.UpdateResourceServerRequest(input)
	return out, req.Send()
}

// UpdateResourceServerWithContext is the same as UpdateResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateResourceServerWithContext(ctx aws.Context, input *UpdateResourceServerInput, opts ...request.Option) (*UpdateResourceServerOutput, error) {
	req, out := c.UpdateResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserAttributes = "UpdateUserAttributes"

// UpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserAttributes for more information on using the UpdateUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserAttributesRequest method.
//    req, resp := client.UpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes
func (c *CognitoIdentityProvider) UpdateUserAttributesRequest(input *UpdateUserAttributesInput) (req *request.Request, output *UpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserAttributesInput{}
	}

	output = &UpdateUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// UpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Allows a user to update a specific attribute (one at a time).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUnexpectedLambdaException "UnexpectedLambdaException"
//   This exception is thrown when the Amazon Cognito service encounters an unexpected
//   exception with the AWS Lambda service.
//
//   * ErrCodeUserLambdaValidationException "UserLambdaValidationException"
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * ErrCodeInvalidLambdaResponseException "InvalidLambdaResponseException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeAliasExistsException "AliasExistsException"
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * ErrCodeCodeDeliveryFailureException "CodeDeliveryFailureException"
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes
func (c *CognitoIdentityProvider) UpdateUserAttributes(input *UpdateUserAttributesInput) (*UpdateUserAttributesOutput, error) {
	req, out := c.UpdateUserAttributesRequest(input)
	return out, req.Send()
}

// UpdateUserAttributesWithContext is the same as UpdateUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserAttributesWithContext(ctx aws.Context, input *UpdateUserAttributesInput, opts ...request.Option) (*UpdateUserAttributesOutput, error) {
	req, out := c.UpdateUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPool = "UpdateUserPool"

// UpdateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPool operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPool for more information on using the UpdateUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPoolRequest method.
//    req, resp := client.UpdateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool
func (c *CognitoIdentityProvider) UpdateUserPoolRequest(input *UpdateUserPoolInput) (req *request.Request, output *UpdateUserPoolOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolInput{}
	}

	output = &UpdateUserPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserPool API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user pool with the specified attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeUserImportInProgressException "UserImportInProgressException"
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeInvalidSmsRoleAccessPolicyException "InvalidSmsRoleAccessPolicyException"
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * ErrCodeInvalidSmsRoleTrustRelationshipException "InvalidSmsRoleTrustRelationshipException"
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * ErrCodeUserPoolTaggingException "UserPoolTaggingException"
//   This exception is thrown when a user pool tag cannot be set or updated.
//
//   * ErrCodeInvalidEmailRoleAccessPolicyException "InvalidEmailRoleAccessPolicyException"
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool
func (c *CognitoIdentityProvider) UpdateUserPool(input *UpdateUserPoolInput) (*UpdateUserPoolOutput, error) {
	req, out := c.UpdateUserPoolRequest(input)
	return out, req.Send()
}

// UpdateUserPoolWithContext is the same as UpdateUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserPoolWithContext(ctx aws.Context, input *UpdateUserPoolInput, opts ...request.Option) (*UpdateUserPoolOutput, error) {
	req, out := c.UpdateUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPoolClient = "UpdateUserPoolClient"

// UpdateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPoolClient for more information on using the UpdateUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPoolClientRequest method.
//    req, resp := client.UpdateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient
func (c *CognitoIdentityProvider) UpdateUserPoolClientRequest(input *UpdateUserPoolClientInput) (req *request.Request, output *UpdateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolClientInput{}
	}

	output = &UpdateUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Allows the developer to update the specified user pool client and password
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeScopeDoesNotExistException "ScopeDoesNotExistException"
//   This exception is thrown when the specified scope does not exist.
//
//   * ErrCodeInvalidOAuthFlowException "InvalidOAuthFlowException"
//   This exception is thrown when the specified OAuth flow is invalid.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient
func (c *CognitoIdentityProvider) UpdateUserPoolClient(input *UpdateUserPoolClientInput) (*UpdateUserPoolClientOutput, error) {
	req, out := c.UpdateUserPoolClientRequest(input)
	return out, req.Send()
}

// UpdateUserPoolClientWithContext is the same as UpdateUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserPoolClientWithContext(ctx aws.Context, input *UpdateUserPoolClientInput, opts ...request.Option) (*UpdateUserPoolClientOutput, error) {
	req, out := c.UpdateUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifySoftwareToken = "VerifySoftwareToken"

// VerifySoftwareTokenRequest generates a "aws/request.Request" representing the
// client's request for the VerifySoftwareToken operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifySoftwareToken for more information on using the VerifySoftwareToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VerifySoftwareTokenRequest method.
//    req, resp := client.VerifySoftwareTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken
func (c *CognitoIdentityProvider) VerifySoftwareTokenRequest(input *VerifySoftwareTokenInput) (req *request.Request, output *VerifySoftwareTokenOutput) {
	op := &request.Operation{
		Name:       opVerifySoftwareToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifySoftwareTokenInput{}
	}

	output = &VerifySoftwareTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifySoftwareToken API operation for Amazon Cognito Identity Provider.
//
// Use this API to register a user's entered TOTP code and mark the user's software
// token MFA status as "verified" if successful,
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation VerifySoftwareToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidUserPoolConfigurationException "InvalidUserPoolConfigurationException"
//   This exception is thrown when the user pool configuration is invalid.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * ErrCodeEnableSoftwareTokenMFAException "EnableSoftwareTokenMFAException"
//   This exception is thrown when there is a code mismatch and the service fails
//   to configure the software token TOTP multi-factor authentication (MFA).
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeSoftwareTokenMFANotFoundException "SoftwareTokenMFANotFoundException"
//   This exception is thrown when the software token TOTP multi-factor authentication
//   (MFA) is not enabled for the user pool.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken
func (c *CognitoIdentityProvider) VerifySoftwareToken(input *VerifySoftwareTokenInput) (*VerifySoftwareTokenOutput, error) {
	req, out := c.VerifySoftwareTokenRequest(input)
	return out, req.Send()
}

// VerifySoftwareTokenWithContext is the same as VerifySoftwareToken with the addition of
// the ability to pass a context and additional request options.
//
// See VerifySoftwareToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) VerifySoftwareTokenWithContext(ctx aws.Context, input *VerifySoftwareTokenInput, opts ...request.Option) (*VerifySoftwareTokenOutput, error) {
	req, out := c.VerifySoftwareTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyUserAttribute = "VerifyUserAttribute"

// VerifyUserAttributeRequest generates a "aws/request.Request" representing the
// client's request for the VerifyUserAttribute operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyUserAttribute for more information on using the VerifyUserAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VerifyUserAttributeRequest method.
//    req, resp := client.VerifyUserAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute
func (c *CognitoIdentityProvider) VerifyUserAttributeRequest(input *VerifyUserAttributeInput) (req *request.Request, output *VerifyUserAttributeOutput) {
	op := &request.Operation{
		Name:       opVerifyUserAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyUserAttributeInput{}
	}

	output = &VerifyUserAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// VerifyUserAttribute API operation for Amazon Cognito Identity Provider.
//
// Verifies the specified user attributes in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation VerifyUserAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ErrCodeCodeMismatchException "CodeMismatchException"
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ErrCodeExpiredCodeException "ExpiredCodeException"
//   This exception is thrown if a code has expired.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   This exception is thrown when a user is not authorized.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * ErrCodePasswordResetRequiredException "PasswordResetRequiredException"
//   This exception is thrown when a password reset is required.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   This exception is thrown when a user is not found.
//
//   * ErrCodeUserNotConfirmedException "UserNotConfirmedException"
//   This exception is thrown when a user is not confirmed successfully.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute
func (c *CognitoIdentityProvider) VerifyUserAttribute(input *VerifyUserAttributeInput) (*VerifyUserAttributeOutput, error) {
	req, out := c.VerifyUserAttributeRequest(input)
	return out, req.Send()
}

// VerifyUserAttributeWithContext is the same as VerifyUserAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyUserAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) VerifyUserAttributeWithContext(ctx aws.Context, input *VerifyUserAttributeInput, opts ...request.Option) (*VerifyUserAttributeOutput, error) {
	req, out := c.VerifyUserAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Account takeover action type.
type AccountTakeoverActionType struct {
	_ struct{} `type:"structure"`

	// The event action.
	//
	//    * BLOCK Choosing this action will block the request.
	//
	//    * MFA_IF_CONFIGURED Throw MFA challenge if user has configured it, else
	//    allow the request.
	//
	//    * MFA_REQUIRED Throw MFA challenge if user has configured it, else block
	//    the request.
	//
	//    * NO_ACTION Allow the user sign-in.
	//
	// EventAction is a required field
	EventAction *string `type:"string" required:"true" enum:"AccountTakeoverEventActionType"`

	// Flag specifying whether to send a notification.
	//
	// Notify is a required field
	Notify *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s AccountTakeoverActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountTakeoverActionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverActionType"}
	if s.EventAction == nil {
		invalidParams.Add(request.NewErrParamRequired("EventAction"))
	}
	if s.Notify == nil {
		invalidParams.Add(request.NewErrParamRequired("Notify"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventAction sets the EventAction field's value.
func (s *AccountTakeoverActionType) SetEventAction(v string) *AccountTakeoverActionType {
	s.EventAction = &v
	return s
}

// SetNotify sets the Notify field's value.
func (s *AccountTakeoverActionType) SetNotify(v bool) *AccountTakeoverActionType {
	s.Notify = &v
	return s
}

// Account takeover actions type.
type AccountTakeoverActionsType struct {
	_ struct{} `type:"structure"`

	// Action to take for a high risk.
	HighAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a low risk.
	LowAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a medium risk.
	MediumAction *AccountTakeoverActionType `type:"structure"`
}

// String returns the string representation
func (s AccountTakeoverActionsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountTakeoverActionsType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionsType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverActionsType"}
	if s.HighAction != nil {
		if err := s.HighAction.Validate(); err != nil {
			invalidParams.AddNested("HighAction", err.(request.ErrInvalidParams))
		}
	}
	if s.LowAction != nil {
		if err := s.LowAction.Validate(); err != nil {
			invalidParams.AddNested("LowAction", err.(request.ErrInvalidParams))
		}
	}
	if s.MediumAction != nil {
		if err := s.MediumAction.Validate(); err != nil {
			invalidParams.AddNested("MediumAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHighAction sets the HighAction field's value.
func (s *AccountTakeoverActionsType) SetHighAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.HighAction = v
	return s
}

// SetLowAction sets the LowAction field's value.
func (s *AccountTakeoverActionsType) SetLowAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.LowAction = v
	return s
}

// SetMediumAction sets the MediumAction field's value.
func (s *AccountTakeoverActionsType) SetMediumAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.MediumAction = v
	return s
}

// Configuration for mitigation actions and notification for different levels
// of risk detected for a potential account takeover.
type AccountTakeoverRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// Account takeover risk configuration actions
	//
	// Actions is a required field
	Actions *AccountTakeoverActionsType `type:"structure" required:"true"`

	// The notify configuration used to construct email notifications.
	NotifyConfiguration *NotifyConfigurationType `type:"structure"`
}

// String returns the string representation
func (s AccountTakeoverRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountTakeoverRiskConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverRiskConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverRiskConfigurationType"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(request.ErrInvalidParams))
		}
	}
	if s.NotifyConfiguration != nil {
		if err := s.NotifyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotifyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *AccountTakeoverRiskConfigurationType) SetActions(v *AccountTakeoverActionsType) *AccountTakeoverRiskConfigurationType {
	s.Actions = v
	return s
}

// SetNotifyConfiguration sets the NotifyConfiguration field's value.
func (s *AccountTakeoverRiskConfigurationType) SetNotifyConfiguration(v *NotifyConfigurationType) *AccountTakeoverRiskConfigurationType {
	s.NotifyConfiguration = v
	return s
}

// Represents the request to add custom attributes.
type AddCustomAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of custom attributes, such as Mutable and Name.
	//
	// CustomAttributes is a required field
	CustomAttributes []*SchemaAttributeType `min:"1" type:"list" required:"true"`

	// The user pool ID for the user pool where you want to add custom attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCustomAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCustomAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCustomAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCustomAttributesInput"}
	if s.CustomAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomAttributes"))
	}
	if s.CustomAttributes != nil && len(s.CustomAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAttributes", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.CustomAttributes != nil {
		for i, v := range s.CustomAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomAttributes sets the CustomAttributes field's value.
func (s *AddCustomAttributesInput) SetCustomAttributes(v []*SchemaAttributeType) *AddCustomAttributesInput {
	s.CustomAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AddCustomAttributesInput) SetUserPoolId(v string) *AddCustomAttributesInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server for the request to add custom attributes.
type AddCustomAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddCustomAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCustomAttributesOutput) GoString() string {
	return s.String()
}

type AdminAddUserToGroupInput struct {
	_ struct{} `type:"structure"`

	// The group name.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminAddUserToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminAddUserToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminAddUserToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminAddUserToGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AdminAddUserToGroupInput) SetGroupName(v string) *AdminAddUserToGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminAddUserToGroupInput) SetUserPoolId(v string) *AdminAddUserToGroupInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminAddUserToGroupInput) SetUsername(v string) *AdminAddUserToGroupInput {
	s.Username = &v
	return s
}

type AdminAddUserToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminAddUserToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminAddUserToGroupOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm user registration.
type AdminConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for which you want to confirm user registration.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name for which you want to confirm user registration.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminConfirmSignUpInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminConfirmSignUpInput) SetUserPoolId(v string) *AdminConfirmSignUpInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminConfirmSignUpInput) SetUsername(v string) *AdminConfirmSignUpInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to confirm registration.
type AdminConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminConfirmSignUpOutput) GoString() string {
	return s.String()
}

// The configuration for creating a new user profile.
type AdminCreateUserConfigType struct {
	_ struct{} `type:"structure"`

	// Set to True if only the administrator is allowed to create user profiles.
	// Set to False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly *bool `type:"boolean"`

	// The message template to be used for the welcome message to new users.
	//
	// See also Customizing User Invitation Messages (http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
	InviteMessageTemplate *MessageTemplateType `type:"structure"`

	// The user account expiration limit, in days, after which the account is no
	// longer usable. To reset the account after that time limit, you must call
	// AdminCreateUser again, specifying "RESEND" for the MessageAction parameter.
	// The default value for this parameter is 7.
	UnusedAccountValidityDays *int64 `type:"integer"`
}

// String returns the string representation
func (s AdminCreateUserConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserConfigType"}
	if s.InviteMessageTemplate != nil {
		if err := s.InviteMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("InviteMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAdminCreateUserOnly sets the AllowAdminCreateUserOnly field's value.
func (s *AdminCreateUserConfigType) SetAllowAdminCreateUserOnly(v bool) *AdminCreateUserConfigType {
	s.AllowAdminCreateUserOnly = &v
	return s
}

// SetInviteMessageTemplate sets the InviteMessageTemplate field's value.
func (s *AdminCreateUserConfigType) SetInviteMessageTemplate(v *MessageTemplateType) *AdminCreateUserConfigType {
	s.InviteMessageTemplate = v
	return s
}

// SetUnusedAccountValidityDays sets the UnusedAccountValidityDays field's value.
func (s *AdminCreateUserConfigType) SetUnusedAccountValidityDays(v int64) *AdminCreateUserConfigType {
	s.UnusedAccountValidityDays = &v
	return s
}

// Represents the request to create a user in the specified user pool.
type AdminCreateUserInput struct {
	_ struct{} `type:"structure"`

	// Specify "EMAIL" if email will be used to send the welcome message. Specify
	// "SMS" if the phone number will be used. The default value is "SMS". More
	// than one value can be specified.
	DesiredDeliveryMediums []*string `type:"list"`

	// This parameter is only used if the phone_number_verified or email_verified
	// attribute is set to True. Otherwise, it is ignored.
	//
	// If this parameter is set to True and the phone number or email address specified
	// in the UserAttributes parameter already exists as an alias with a different
	// user, the API call will migrate the alias from the previous user to the newly
	// created user. The previous user will no longer be able to log in using that
	// alias.
	//
	// If this parameter is set to False, the API throws an AliasExistsException
	// error if the alias already exists. The default value is False.
	ForceAliasCreation *bool `type:"boolean"`

	// Set to "RESEND" to resend the invitation message to a user that already exists
	// and reset the expiration limit on the user's account. Set to "SUPPRESS" to
	// suppress sending the message. Only one value can be specified.
	MessageAction *string `type:"string" enum:"MessageActionType"`

	// The user's temporary password. This password must conform to the password
	// policy that you specified when you created the user pool.
	//
	// The temporary password is valid only once. To complete the Admin Create User
	// flow, the user must enter the temporary password in the sign-in page along
	// with a new password to be used in all future sign-ins.
	//
	// This parameter is not required. If you do not specify a value, Amazon Cognito
	// generates one for you.
	//
	// The temporary password can only be used until the user account expiration
	// limit that you specified when you created the user pool. To reset the account
	// after that time limit, you must call AdminCreateUser again, specifying "RESEND"
	// for the MessageAction parameter.
	TemporaryPassword *string `min:"6" type:"string"`

	// An array of name-value pairs that contain user attributes and attribute values
	// to be set for the user to be created. You can create a user without specifying
	// any attributes other than Username. However, any attributes that you specify
	// as required (in or in the Attributes tab of the console) must be supplied
	// either by you (in your call to AdminCreateUser) or by the user (when he or
	// she signs up in response to your welcome message).
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// To send a message inviting the user to sign up, you must specify the user's
	// email address or phone number. This can be done in your call to AdminCreateUser
	// or in the Users tab of the Amazon Cognito console for managing your user
	// pools.
	//
	// In your call to AdminCreateUser, you can set the email_verified attribute
	// to True, and you can set the phone_number_verified attribute to True. (You
	// can also do this by calling .)
	//
	//    * email: The email address of the user to whom the message that contains
	//    the code and username will be sent. Required if the email_verified attribute
	//    is set to True, or if "EMAIL" is specified in the DesiredDeliveryMediums
	//    parameter.
	//
	//    * phone_number: The phone number of the user to whom the message that
	//    contains the code and username will be sent. Required if the phone_number_verified
	//    attribute is set to True, or if "SMS" is specified in the DesiredDeliveryMediums
	//    parameter.
	UserAttributes []*AttributeType `type:"list"`

	// The user pool ID for the user pool where the user will be created.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user. Must be unique within the user pool. Must be a
	// UTF-8 string between 1 and 128 characters. After the user is created, the
	// username cannot be changed.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`

	// The user's validation data. This is an array of name-value pairs that contain
	// user attributes and attribute values that you can use for custom validation,
	// such as restricting the types of user accounts that can be registered. For
	// example, you might choose to allow or disallow user sign-up based on the
	// user's domain.
	//
	// To configure custom validation, you must create a Pre Sign-up Lambda trigger
	// for the user pool as described in the Amazon Cognito Developer Guide. The
	// Lambda trigger receives the validation data and uses it in the validation
	// process.
	//
	// The user's validation data is not persisted.
	ValidationData []*AttributeType `type:"list"`
}

// String returns the string representation
func (s AdminCreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserInput"}
	if s.TemporaryPassword != nil && len(*s.TemporaryPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("TemporaryPassword", 6))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValidationData != nil {
		for i, v := range s.ValidationData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredDeliveryMediums sets the DesiredDeliveryMediums field's value.
func (s *AdminCreateUserInput) SetDesiredDeliveryMediums(v []*string) *AdminCreateUserInput {
	s.DesiredDeliveryMediums = v
	return s
}

// SetForceAliasCreation sets the ForceAliasCreation field's value.
func (s *AdminCreateUserInput) SetForceAliasCreation(v bool) *AdminCreateUserInput {
	s.ForceAliasCreation = &v
	return s
}

// SetMessageAction sets the MessageAction field's value.
func (s *AdminCreateUserInput) SetMessageAction(v string) *AdminCreateUserInput {
	s.MessageAction = &v
	return s
}

// SetTemporaryPassword sets the TemporaryPassword field's value.
func (s *AdminCreateUserInput) SetTemporaryPassword(v string) *AdminCreateUserInput {
	s.TemporaryPassword = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminCreateUserInput) SetUserAttributes(v []*AttributeType) *AdminCreateUserInput {
	s.UserAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminCreateUserInput) SetUserPoolId(v string) *AdminCreateUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminCreateUserInput) SetUsername(v string) *AdminCreateUserInput {
	s.Username = &v
	return s
}

// SetValidationData sets the ValidationData field's value.
func (s *AdminCreateUserInput) SetValidationData(v []*AttributeType) *AdminCreateUserInput {
	s.ValidationData = v
	return s
}

// Represents the response from the server to the request to create the user.
type AdminCreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The newly created user.
	User *UserType `type:"structure"`
}

// String returns the string representation
func (s AdminCreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *AdminCreateUserOutput) SetUser(v *UserType) *AdminCreateUserOutput {
	s.User = v
	return s
}

// Represents the request to delete user attributes as an administrator.
type AdminDeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the user attribute names you wish to delete.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to delete user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user from which you would like to delete attributes.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserAttributesInput"}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserAttributeNames sets the UserAttributeNames field's value.
func (s *AdminDeleteUserAttributesInput) SetUserAttributeNames(v []*string) *AdminDeleteUserAttributesInput {
	s.UserAttributeNames = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDeleteUserAttributesInput) SetUserPoolId(v string) *AdminDeleteUserAttributesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDeleteUserAttributesInput) SetUsername(v string) *AdminDeleteUserAttributesInput {
	s.Username = &v
	return s
}

// Represents the response received from the server for a request to delete
// user attributes.
type AdminDeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user as an administrator.
type AdminDeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to delete the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to delete.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDeleteUserInput) SetUserPoolId(v string) *AdminDeleteUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDeleteUserInput) SetUsername(v string) *AdminDeleteUserInput {
	s.Username = &v
	return s
}

type AdminDeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserOutput) GoString() string {
	return s.String()
}

type AdminDisableProviderForUserInput struct {
	_ struct{} `type:"structure"`

	// The user to be disabled.
	//
	// User is a required field
	User *ProviderUserIdentifierType `type:"structure" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDisableProviderForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableProviderForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableProviderForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDisableProviderForUserInput"}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUser sets the User field's value.
func (s *AdminDisableProviderForUserInput) SetUser(v *ProviderUserIdentifierType) *AdminDisableProviderForUserInput {
	s.User = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDisableProviderForUserInput) SetUserPoolId(v string) *AdminDisableProviderForUserInput {
	s.UserPoolId = &v
	return s
}

type AdminDisableProviderForUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDisableProviderForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableProviderForUserOutput) GoString() string {
	return s.String()
}

// Represents the request to disable any user as an administrator.
type AdminDisableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to disable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to disable.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDisableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDisableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDisableUserInput) SetUserPoolId(v string) *AdminDisableUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDisableUserInput) SetUsername(v string) *AdminDisableUserInput {
	s.Username = &v
	return s
}

// Represents the response received from the server to disable the user as an
// administrator.
type AdminDisableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDisableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableUserOutput) GoString() string {
	return s.String()
}

// Represents the request that enables the user as an administrator.
type AdminEnableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to enable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to enable.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminEnableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminEnableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminEnableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminEnableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminEnableUserInput) SetUserPoolId(v string) *AdminEnableUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminEnableUserInput) SetUsername(v string) *AdminEnableUserInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to enable a user
// as an administrator.
type AdminEnableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminEnableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminEnableUserOutput) GoString() string {
	return s.String()
}

// Sends the forgot device request, as an administrator.
type AdminForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminForgetDeviceInput) SetDeviceKey(v string) *AdminForgetDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminForgetDeviceInput) SetUserPoolId(v string) *AdminForgetDeviceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminForgetDeviceInput) SetUsername(v string) *AdminForgetDeviceInput {
	s.Username = &v
	return s
}

type AdminForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to get the device, as an administrator.
type AdminGetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminGetDeviceInput) SetDeviceKey(v string) *AdminGetDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminGetDeviceInput) SetUserPoolId(v string) *AdminGetDeviceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetDeviceInput) SetUsername(v string) *AdminGetDeviceInput {
	s.Username = &v
	return s
}

// Gets the device response, as an administrator.
type AdminGetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdminGetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *AdminGetDeviceOutput) SetDevice(v *DeviceType) *AdminGetDeviceOutput {
	s.Device = v
	return s
}

// Represents the request to get the specified user as an administrator.
type AdminGetUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to get information about
	// the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to retrieve.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminGetUserInput) SetUserPoolId(v string) *AdminGetUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetUserInput) SetUsername(v string) *AdminGetUserInput {
	s.Username = &v
	return s
}

// Represents the response from the server from the request to get the specified
// user as an administrator.
type AdminGetUserOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that the status is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies the options for MFA (e.g., email or phone number).
	MFAOptions []*MFAOptionType `type:"list"`

	// The user's preferred MFA setting.
	PreferredMfaSetting *string `type:"string"`

	// An array of name-value pairs representing user attributes.
	UserAttributes []*AttributeType `type:"list"`

	// The date the user was created.
	UserCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date the user was last modified.
	UserLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The list of the user's MFA settings.
	UserMFASettingList []*string `type:"list"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * COMPROMISED - User is disabled due to a potential security threat.
	//
	//    * UNKNOWN - User status is not known.
	UserStatus *string `type:"string" enum:"UserStatusType"`

	// The user name of the user about whom you are receiving information.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetUserOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AdminGetUserOutput) SetEnabled(v bool) *AdminGetUserOutput {
	s.Enabled = &v
	return s
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *AdminGetUserOutput) SetMFAOptions(v []*MFAOptionType) *AdminGetUserOutput {
	s.MFAOptions = v
	return s
}

// SetPreferredMfaSetting sets the PreferredMfaSetting field's value.
func (s *AdminGetUserOutput) SetPreferredMfaSetting(v string) *AdminGetUserOutput {
	s.PreferredMfaSetting = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminGetUserOutput) SetUserAttributes(v []*AttributeType) *AdminGetUserOutput {
	s.UserAttributes = v
	return s
}

// SetUserCreateDate sets the UserCreateDate field's value.
func (s *AdminGetUserOutput) SetUserCreateDate(v time.Time) *AdminGetUserOutput {
	s.UserCreateDate = &v
	return s
}

// SetUserLastModifiedDate sets the UserLastModifiedDate field's value.
func (s *AdminGetUserOutput) SetUserLastModifiedDate(v time.Time) *AdminGetUserOutput {
	s.UserLastModifiedDate = &v
	return s
}

// SetUserMFASettingList sets the UserMFASettingList field's value.
func (s *AdminGetUserOutput) SetUserMFASettingList(v []*string) *AdminGetUserOutput {
	s.UserMFASettingList = v
	return s
}

// SetUserStatus sets the UserStatus field's value.
func (s *AdminGetUserOutput) SetUserStatus(v string) *AdminGetUserOutput {
	s.UserStatus = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetUserOutput) SetUsername(v string) *AdminGetUserOutput {
	s.Username = &v
	return s
}

// Initiates the authorization request, as an administrator.
type AdminInitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The analytics metadata for collecting Amazon Pinpoint metrics for AdminInitiateAuth
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The authentication flow for this call to execute. The API action will depend
	// on this value. For example:
	//
	//    * REFRESH_TOKEN_AUTH will take in a valid refresh token and return new
	//    tokens.
	//
	//    * USER_SRP_AUTH will take in USERNAME and SRP_A and return the SRP variables
	//    to be used for next challenge execution.
	//
	//    * USER_PASSWORD_AUTH will take in USERNAME and PASSWORD and return the
	//    next challenge or tokens.
	//
	// Valid values include:
	//
	//    * USER_SRP_AUTH: Authentication flow for the Secure Remote Password (SRP)
	//    protocol.
	//
	//    * REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow for refreshing
	//    the access token and ID token by supplying a valid refresh token.
	//
	//    * CUSTOM_AUTH: Custom authentication flow.
	//
	//    * ADMIN_NO_SRP_AUTH: Non-SRP authentication flow; you can pass in the
	//    USERNAME and PASSWORD directly if the flow is enabled for calling the
	//    app client.
	//
	//    * USER_PASSWORD_AUTH: Non-SRP authentication flow; USERNAME and PASSWORD
	//    are passed directly. If a user migration Lambda trigger is set, this flow
	//    will invoke the user migration Lambda if the USERNAME is not found in
	//    the user pool.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters. These are inputs corresponding to the AuthFlow
	// that you are invoking. The required values depend on the value of AuthFlow:
	//
	//    * For USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY
	//
	//    * For REFRESH_TOKEN_AUTH/REFRESH_TOKEN: REFRESH_TOKEN (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY
	//
	//    * For ADMIN_NO_SRP_AUTH: USERNAME (required), SECRET_HASH (if app client
	//    is configured with client secret), PASSWORD (required), DEVICE_KEY
	//
	//    * For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app client is
	//    configured with client secret), DEVICE_KEY
	AuthParameters map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// This is a random key-value pair map which can contain any key and will be
	// passed to your PreAuthentication Lambda trigger as-is. It can be used to
	// implement additional validations around authentication.
	ClientMetadata map[string]*string `type:"map"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	ContextData *ContextDataType `type:"structure"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminInitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminInitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminInitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminInitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.ContextData != nil {
		if err := s.ContextData.Validate(); err != nil {
			invalidParams.AddNested("ContextData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *AdminInitiateAuthInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *AdminInitiateAuthInput {
	s.AnalyticsMetadata = v
	return s
}

// SetAuthFlow sets the AuthFlow field's value.
func (s *AdminInitiateAuthInput) SetAuthFlow(v string) *AdminInitiateAuthInput {
	s.AuthFlow = &v
	return s
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *AdminInitiateAuthInput) SetAuthParameters(v map[string]*string) *AdminInitiateAuthInput {
	s.AuthParameters = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *AdminInitiateAuthInput) SetClientId(v string) *AdminInitiateAuthInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminInitiateAuthInput) SetClientMetadata(v map[string]*string) *AdminInitiateAuthInput {
	s.ClientMetadata = v
	return s
}

// SetContextData sets the ContextData field's value.
func (s *AdminInitiateAuthInput) SetContextData(v *ContextDataType) *AdminInitiateAuthInput {
	s.ContextData = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminInitiateAuthInput) SetUserPoolId(v string) *AdminInitiateAuthInput {
	s.UserPoolId = &v
	return s
}

// Initiates the authentication response, as an administrator.
type AdminInitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authentication response. This is only returned if the caller
	// does not need to pass another challenge. If the caller does need to pass
	// another challenge before it gets tokens, ChallengeName, ChallengeParameters,
	// and Session are returned.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge which you are responding to with this call. This
	// is returned to you in the AdminInitiateAuth response if you need to pass
	// another challenge.
	//
	//    * SMS_MFA: Next challenge is to supply an SMS_MFA_CODE, delivered via
	//    SMS.
	//
	//    * PASSWORD_VERIFIER: Next challenge is to supply PASSWORD_CLAIM_SIGNATURE,
	//    PASSWORD_CLAIM_SECRET_BLOCK, and TIMESTAMP after the client-side SRP calculations.
	//
	//    * CUSTOM_CHALLENGE: This is returned if your custom authentication flow
	//    determines that the user should pass another challenge before tokens are
	//    issued.
	//
	//    * DEVICE_SRP_AUTH: If device tracking was enabled on your user pool and
	//    the previous challenges were passed, this challenge is returned so that
	//    Amazon Cognito can start tracking this device.
	//
	//    * DEVICE_PASSWORD_VERIFIER: Similar to PASSWORD_VERIFIER, but for devices
	//    only.
	//
	//    * ADMIN_NO_SRP_AUTH: This is returned if you need to authenticate with
	//    USERNAME and PASSWORD directly. An app client must be enabled to use this
	//    flow.
	//
	//    * NEW_PASSWORD_REQUIRED: For users which are required to change their
	//    passwords after successful first login. This challenge should be passed
	//    with NEW_PASSWORD and any other required attributes.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. These are returned to you in the AdminInitiateAuth
	// response if you need to pass another challenge. The responses in this parameter
	// should be used to compute inputs to the next call (AdminRespondToAuthChallenge).
	//
	// All challenges require USERNAME and SECRET_HASH (if applicable).
	//
	// The value of the USER_ID_FOR_SRP attribute will be the user's actual username,
	// not an alias (such as email address or phone number), even if you specified
	// an alias in your call to AdminInitiateAuth. This is because, in the AdminRespondToAuthChallenge
	// API ChallengeResponses, the USERNAME attribute cannot be an alias.
	ChallengeParameters map[string]*string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If AdminInitiateAuth or AdminRespondToAuthChallenge API call
	// determines that the caller needs to go through another challenge, they return
	// a session with other challenge parameters. This session should be passed
	// as it is to the next AdminRespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AdminInitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminInitiateAuthOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *AdminInitiateAuthOutput) SetAuthenticationResult(v *AuthenticationResultType) *AdminInitiateAuthOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminInitiateAuthOutput) SetChallengeName(v string) *AdminInitiateAuthOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *AdminInitiateAuthOutput) SetChallengeParameters(v map[string]*string) *AdminInitiateAuthOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminInitiateAuthOutput) SetSession(v string) *AdminInitiateAuthOutput {
	s.Session = &v
	return s
}

type AdminLinkProviderForUserInput struct {
	_ struct{} `type:"structure"`

	// The existing user in the user pool to be linked to the external identity
	// provider user account. Can be a native (Username + Password) Cognito User
	// Pools user or a federated user (for example, a SAML or Facebook user). If
	// the user doesn't exist, an exception is thrown. This is the user that is
	// returned when the new user (with the linked identity provider attribute)
	// signs in.
	//
	// For a native username + password user, the ProviderAttributeValue for the
	// DestinationUser should be the username in the user pool. For a federated
	// user, it should be the provider-specific user_id.
	//
	// The ProviderAttributeName of the DestinationUser is ignored.
	//
	// The ProviderName should be set to Cognito for users in Cognito user pools.
	//
	// DestinationUser is a required field
	DestinationUser *ProviderUserIdentifierType `type:"structure" required:"true"`

	// An external identity provider account for a user who does not currently exist
	// yet in the user pool. This user must be a federated user (for example, a
	// SAML or Facebook user), not another native user.
	//
	// If the SourceUser is a federated social identity provider user (Facebook,
	// Google, or Login with Amazon), you must set the ProviderAttributeName to
	// Cognito_Subject. For social identity providers, the ProviderName will be
	// Facebook, Google, or LoginWithAmazon, and Cognito will automatically parse
	// the Facebook, Google, and Login with Amazon tokens for id, sub, and user_id,
	// respectively. The ProviderAttributeValue for the user must be the same value
	// as the id, sub, or user_id value found in the social identity provider token.
	//
	// For SAML, the ProviderAttributeNamecan be any value that matches a claim in the SAML assertion. If you wish
	// to link SAML users based on the subject of the SAML assertion, you should
	// map the subject to a claim through the SAML identity provider and submit
	// that claim name as the ProviderAttributeName. If you set ProviderAttributeNameto Cognito_Subject
	//
	// SourceUser is a required field
	SourceUser *ProviderUserIdentifierType `type:"structure" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AdminLinkProviderForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminLinkProviderForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminLinkProviderForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminLinkProviderForUserInput"}
	if s.DestinationUser == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationUser"))
	}
	if s.SourceUser == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceUser"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.DestinationUser != nil {
		if err := s.DestinationUser.Validate(); err != nil {
			invalidParams.AddNested("DestinationUser", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceUser != nil {
		if err := s.SourceUser.Validate(); err != nil {
			invalidParams.AddNested("SourceUser", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationUser sets the DestinationUser field's value.
func (s *AdminLinkProviderForUserInput) SetDestinationUser(v *ProviderUserIdentifierType) *AdminLinkProviderForUserInput {
	s.DestinationUser = v
	return s
}

// SetSourceUser sets the SourceUser field's value.
func (s *AdminLinkProviderForUserInput) SetSourceUser(v *ProviderUserIdentifierType) *AdminLinkProviderForUserInput {
	s.SourceUser = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminLinkProviderForUserInput) SetUserPoolId(v string) *AdminLinkProviderForUserInput {
	s.UserPoolId = &v
	return s
}

type AdminLinkProviderForUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminLinkProviderForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminLinkProviderForUserOutput) GoString() string {
	return s.String()
}

// Represents the request to list devices, as an administrator.
type AdminListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The limit of the devices request.
	Limit *int64 `type:"integer"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListDevicesInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *AdminListDevicesInput) SetLimit(v int64) *AdminListDevicesInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *AdminListDevicesInput) SetPaginationToken(v string) *AdminListDevicesInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListDevicesInput) SetUserPoolId(v string) *AdminListDevicesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListDevicesInput) SetUsername(v string) *AdminListDevicesInput {
	s.Username = &v
	return s
}

// Lists the device's response, as an administrator.
type AdminListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices in the list of devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdminListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *AdminListDevicesOutput) SetDevices(v []*DeviceType) *AdminListDevicesOutput {
	s.Devices = v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *AdminListDevicesOutput) SetPaginationToken(v string) *AdminListDevicesOutput {
	s.PaginationToken = &v
	return s
}

type AdminListGroupsForUserInput struct {
	_ struct{} `type:"structure"`

	// The limit of the request to list groups.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminListGroupsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListGroupsForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListGroupsForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListGroupsForUserInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *AdminListGroupsForUserInput) SetLimit(v int64) *AdminListGroupsForUserInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListGroupsForUserInput) SetNextToken(v string) *AdminListGroupsForUserInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListGroupsForUserInput) SetUserPoolId(v string) *AdminListGroupsForUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListGroupsForUserInput) SetUsername(v string) *AdminListGroupsForUserInput {
	s.Username = &v
	return s
}

type AdminListGroupsForUserOutput struct {
	_ struct{} `type:"structure"`

	// The groups that the user belongs to.
	Groups []*GroupType `type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdminListGroupsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListGroupsForUserOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *AdminListGroupsForUserOutput) SetGroups(v []*GroupType) *AdminListGroupsForUserOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListGroupsForUserOutput) SetNextToken(v string) *AdminListGroupsForUserOutput {
	s.NextToken = &v
	return s
}

type AdminListUserAuthEventsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of authentication events to return.
	MaxResults *int64 `type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username or an alias.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminListUserAuthEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListUserAuthEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListUserAuthEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListUserAuthEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *AdminListUserAuthEventsInput) SetMaxResults(v int64) *AdminListUserAuthEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListUserAuthEventsInput) SetNextToken(v string) *AdminListUserAuthEventsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListUserAuthEventsInput) SetUserPoolId(v string) *AdminListUserAuthEventsInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListUserAuthEventsInput) SetUsername(v string) *AdminListUserAuthEventsInput {
	s.Username = &v
	return s
}

type AdminListUserAuthEventsOutput struct {
	_ struct{} `type:"structure"`

	// The response object. It includes the EventID, EventType, CreationDate, EventRisk,
	// and EventResponse.
	AuthEvents []*AuthEventType `type:"list"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdminListUserAuthEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListUserAuthEventsOutput) GoString() string {
	return s.String()
}

// SetAuthEvents sets the AuthEvents field's value.
func (s *AdminListUserAuthEventsOutput) SetAuthEvents(v []*AuthEventType) *AdminListUserAuthEventsOutput {
	s.AuthEvents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListUserAuthEventsOutput) SetNextToken(v string) *AdminListUserAuthEventsOutput {
	s.NextToken = &v
	return s
}

type AdminRemoveUserFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The group name.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminRemoveUserFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRemoveUserFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminRemoveUserFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminRemoveUserFromGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AdminRemoveUserFromGroupInput) SetGroupName(v string) *AdminRemoveUserFromGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminRemoveUserFromGroupInput) SetUserPoolId(v string) *AdminRemoveUserFromGroupInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminRemoveUserFromGroupInput) SetUsername(v string) *AdminRemoveUserFromGroupInput {
	s.Username = &v
	return s
}

type AdminRemoveUserFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminRemoveUserFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRemoveUserFromGroupOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password as an administrator.
type AdminResetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to reset the user's password.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose password you wish to reset.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminResetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminResetUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminResetUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminResetUserPasswordInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminResetUserPasswordInput) SetUserPoolId(v string) *AdminResetUserPasswordInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminResetUserPasswordInput) SetUsername(v string) *AdminResetUserPasswordInput {
	s.Username = &v
	return s
}

// Represents the response from the server to reset a user password as an administrator.
type AdminResetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminResetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminResetUserPasswordOutput) GoString() string {
	return s.String()
}

// The request to respond to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The analytics metadata for collecting Amazon Pinpoint metrics for AdminRespondToAuthChallenge
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The challenge name. For more information, see .
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The challenge responses. These are inputs corresponding to the value of ChallengeName,
	// for example:
	//
	//    * SMS_MFA: SMS_MFA_CODE, USERNAME, SECRET_HASH (if app client is configured
	//    with client secret).
	//
	//    * PASSWORD_VERIFIER: PASSWORD_CLAIM_SIGNATURE, PASSWORD_CLAIM_SECRET_BLOCK,
	//    TIMESTAMP, USERNAME, SECRET_HASH (if app client is configured with client
	//    secret).
	//
	//    * ADMIN_NO_SRP_AUTH: PASSWORD, USERNAME, SECRET_HASH (if app client is
	//    configured with client secret).
	//
	//    * NEW_PASSWORD_REQUIRED: NEW_PASSWORD, any other required attributes,
	//    USERNAME, SECRET_HASH (if app client is configured with client secret).
	//
	//
	// The value of the USERNAME attribute must be the user's actual username, not
	// an alias (such as email address or phone number). To make this easier, the
	// AdminInitiateAuth response includes the actual username value in the USERNAMEUSER_ID_FOR_SRP
	// attribute, even if you specified an alias in your call to AdminInitiateAuth.
	ChallengeResponses map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	ContextData *ContextDataType `type:"structure"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If InitiateAuth or RespondToAuthChallenge API call determines
	// that the caller needs to go through another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminRespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminRespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminRespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.ContextData != nil {
		if err := s.ContextData.Validate(); err != nil {
			invalidParams.AddNested("ContextData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *AdminRespondToAuthChallengeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *AdminRespondToAuthChallengeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminRespondToAuthChallengeInput) SetChallengeName(v string) *AdminRespondToAuthChallengeInput {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *AdminRespondToAuthChallengeInput) SetChallengeResponses(v map[string]*string) *AdminRespondToAuthChallengeInput {
	s.ChallengeResponses = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *AdminRespondToAuthChallengeInput) SetClientId(v string) *AdminRespondToAuthChallengeInput {
	s.ClientId = &v
	return s
}

// SetContextData sets the ContextData field's value.
func (s *AdminRespondToAuthChallengeInput) SetContextData(v *ContextDataType) *AdminRespondToAuthChallengeInput {
	s.ContextData = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminRespondToAuthChallengeInput) SetSession(v string) *AdminRespondToAuthChallengeInput {
	s.Session = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminRespondToAuthChallengeInput) SetUserPoolId(v string) *AdminRespondToAuthChallengeInput {
	s.UserPoolId = &v
	return s
}

// Responds to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the server in response to the authentication request.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge. For more information, see .
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. For more information, see .
	ChallengeParameters map[string]*string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If the or API call determines that the caller needs to go
	// through another challenge, they return a session with other challenge parameters.
	// This session should be passed as it is to the next RespondToAuthChallenge
	// API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AdminRespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *AdminRespondToAuthChallengeOutput) SetAuthenticationResult(v *AuthenticationResultType) *AdminRespondToAuthChallengeOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminRespondToAuthChallengeOutput) SetChallengeName(v string) *AdminRespondToAuthChallengeOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *AdminRespondToAuthChallengeOutput) SetChallengeParameters(v map[string]*string) *AdminRespondToAuthChallengeOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminRespondToAuthChallengeOutput) SetSession(v string) *AdminRespondToAuthChallengeOutput {
	s.Session = &v
	return s
}

type AdminSetUserMFAPreferenceInput struct {
	_ struct{} `type:"structure"`

	// The SMS text message MFA settings.
	SMSMfaSettings *SMSMfaSettingsType `type:"structure"`

	// The time-based one-time password software token MFA settings.
	SoftwareTokenMfaSettings *SoftwareTokenMfaSettingsType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username or alias.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminSetUserMFAPreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserMFAPreferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserMFAPreferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserMFAPreferenceInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSMSMfaSettings sets the SMSMfaSettings field's value.
func (s *AdminSetUserMFAPreferenceInput) SetSMSMfaSettings(v *SMSMfaSettingsType) *AdminSetUserMFAPreferenceInput {
	s.SMSMfaSettings = v
	return s
}

// SetSoftwareTokenMfaSettings sets the SoftwareTokenMfaSettings field's value.
func (s *AdminSetUserMFAPreferenceInput) SetSoftwareTokenMfaSettings(v *SoftwareTokenMfaSettingsType) *AdminSetUserMFAPreferenceInput {
	s.SoftwareTokenMfaSettings = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminSetUserMFAPreferenceInput) SetUserPoolId(v string) *AdminSetUserMFAPreferenceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminSetUserMFAPreferenceInput) SetUsername(v string) *AdminSetUserMFAPreferenceInput {
	s.Username = &v
	return s
}

type AdminSetUserMFAPreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminSetUserMFAPreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserMFAPreferenceOutput) GoString() string {
	return s.String()
}

// Represents the request to set user settings as an administrator.
type AdminSetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the options for MFA (e.g., email or phone number).
	//
	// MFAOptions is a required field
	MFAOptions []*MFAOptionType `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to set the user's settings,
	// such as MFA options.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user for whom you wish to set user settings.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminSetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserSettingsInput"}
	if s.MFAOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAOptions"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *AdminSetUserSettingsInput) SetMFAOptions(v []*MFAOptionType) *AdminSetUserSettingsInput {
	s.MFAOptions = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminSetUserSettingsInput) SetUserPoolId(v string) *AdminSetUserSettingsInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminSetUserSettingsInput) SetUsername(v string) *AdminSetUserSettingsInput {
	s.Username = &v
	return s
}

// Represents the response from the server to set user settings as an administrator.
type AdminSetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminSetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserSettingsOutput) GoString() string {
	return s.String()
}

type AdminUpdateAuthEventFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The authentication event ID.
	//
	// EventId is a required field
	EventId *string `min:"1" type:"string" required:"true"`

	// The authentication event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue *string `type:"string" required:"true" enum:"FeedbackValueType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUpdateAuthEventFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateAuthEventFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateAuthEventFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateAuthEventFeedbackInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.FeedbackValue == nil {
		invalidParams.Add(request.NewErrParamRequired("FeedbackValue"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetEventId(v string) *AdminUpdateAuthEventFeedbackInput {
	s.EventId = &v
	return s
}

// SetFeedbackValue sets the FeedbackValue field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetFeedbackValue(v string) *AdminUpdateAuthEventFeedbackInput {
	s.FeedbackValue = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetUserPoolId(v string) *AdminUpdateAuthEventFeedbackInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetUsername(v string) *AdminUpdateAuthEventFeedbackInput {
	s.Username = &v
	return s
}

type AdminUpdateAuthEventFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateAuthEventFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateAuthEventFeedbackOutput) GoString() string {
	return s.String()
}

// The request to update the device status, as an administrator.
type AdminUpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status indicating whether a device has been remembered or not.
	DeviceRememberedStatus *string `type:"string" enum:"DeviceRememberedStatusType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateDeviceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateDeviceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateDeviceStatusInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminUpdateDeviceStatusInput) SetDeviceKey(v string) *AdminUpdateDeviceStatusInput {
	s.DeviceKey = &v
	return s
}

// SetDeviceRememberedStatus sets the DeviceRememberedStatus field's value.
func (s *AdminUpdateDeviceStatusInput) SetDeviceRememberedStatus(v string) *AdminUpdateDeviceStatusInput {
	s.DeviceRememberedStatus = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateDeviceStatusInput) SetUserPoolId(v string) *AdminUpdateDeviceStatusInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateDeviceStatusInput) SetUsername(v string) *AdminUpdateDeviceStatusInput {
	s.Username = &v
	return s
}

// The status response from the request to update the device, as an administrator.
type AdminUpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateDeviceStatusOutput) GoString() string {
	return s.String()
}

// Represents the request to update the user's attributes as an administrator.
type AdminUpdateUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to update user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user for whom you want to update user attributes.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUpdateUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateUserAttributesInput"}
	if s.UserAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributes"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminUpdateUserAttributesInput) SetUserAttributes(v []*AttributeType) *AdminUpdateUserAttributesInput {
	s.UserAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateUserAttributesInput) SetUserPoolId(v string) *AdminUpdateUserAttributesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateUserAttributesInput) SetUsername(v string) *AdminUpdateUserAttributesInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to update user attributes
// as an administrator.
type AdminUpdateUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateUserAttributesOutput) GoString() string {
	return s.String()
}

// The request to sign out of all devices, as an administrator.
type AdminUserGlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUserGlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUserGlobalSignOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUserGlobalSignOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUserGlobalSignOutInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUserGlobalSignOutInput) SetUserPoolId(v string) *AdminUserGlobalSignOutInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUserGlobalSignOutInput) SetUsername(v string) *AdminUserGlobalSignOutInput {
	s.Username = &v
	return s
}

// The global sign-out response, as an administrator.
type AdminUserGlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUserGlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUserGlobalSignOutOutput) GoString() string {
	return s.String()
}

// The Amazon Pinpoint analytics configuration for collecting metrics for a
// user pool.
type AnalyticsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The application ID for an Amazon Pinpoint application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The external ID.
	//
	// ExternalId is a required field
	ExternalId *string `type:"string" required:"true"`

	// The ARN of an IAM role that authorizes Amazon Cognito to publish events to
	// Amazon Pinpoint analytics.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// If UserDataShared is true, Amazon Cognito will include user data in the events
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared *bool `type:"boolean"`
}

// String returns the string representation
func (s AnalyticsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsConfigurationType"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *AnalyticsConfigurationType) SetApplicationId(v string) *AnalyticsConfigurationType {
	s.ApplicationId = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *AnalyticsConfigurationType) SetExternalId(v string) *AnalyticsConfigurationType {
	s.ExternalId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AnalyticsConfigurationType) SetRoleArn(v string) *AnalyticsConfigurationType {
	s.RoleArn = &v
	return s
}

// SetUserDataShared sets the UserDataShared field's value.
func (s *AnalyticsConfigurationType) SetUserDataShared(v bool) *AnalyticsConfigurationType {
	s.UserDataShared = &v
	return s
}

// An Amazon Pinpoint analytics endpoint.
//
// An endpoint uniquely identifies a mobile device, email address, or phone
// number that can receive messages from Amazon Pinpoint analytics.
type AnalyticsMetadataType struct {
	_ struct{} `type:"structure"`

	// The endpoint ID.
	AnalyticsEndpointId *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsMetadataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsMetadataType) GoString() string {
	return s.String()
}

// SetAnalyticsEndpointId sets the AnalyticsEndpointId field's value.
func (s *AnalyticsMetadataType) SetAnalyticsEndpointId(v string) *AnalyticsMetadataType {
	s.AnalyticsEndpointId = &v
	return s
}

type AssociateSoftwareTokenInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. This allows authentication of the user as part of the MFA
	// setup process.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AssociateSoftwareTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSoftwareTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSoftwareTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSoftwareTokenInput"}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *AssociateSoftwareTokenInput) SetAccessToken(v string) *AssociateSoftwareTokenInput {
	s.AccessToken = &v
	return s
}

// SetSession sets the Session field's value.
func (s *AssociateSoftwareTokenInput) SetSession(v string) *AssociateSoftwareTokenInput {
	s.Session = &v
	return s
}

type AssociateSoftwareTokenOutput struct {
	_ struct{} `type:"structure"`

	// A unique generated shared secret code that is used in the TOTP algorithm
	// to generate a one time code.
	SecretCode *string `min:"16" type:"string"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. This allows authentication of the user as part of the MFA
	// setup process.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AssociateSoftwareTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSoftwareTokenOutput) GoString() string {
	return s.String()
}

// SetSecretCode sets the SecretCode field's value.
func (s *AssociateSoftwareTokenOutput) SetSecretCode(v string) *AssociateSoftwareTokenOutput {
	s.SecretCode = &v
	return s
}

// SetSession sets the Session field's value.
func (s *AssociateSoftwareTokenOutput) SetSession(v string) *AssociateSoftwareTokenOutput {
	s.Session = &v
	return s
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AttributeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AttributeType) SetName(v string) *AttributeType {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeType) SetValue(v string) *AttributeType {
	s.Value = &v
	return s
}

// The authentication event type.
type AuthEventType struct {
	_ struct{} `type:"structure"`

	// The challenge responses.
	ChallengeResponses []*ChallengeResponseType `type:"list"`

	// The creation date
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The user context data captured at the time of an event request. It provides
	// additional information about the client from which event the request is received.
	EventContextData *EventContextDataType `type:"structure"`

	// A flag specifying the user feedback captured at the time of an event request
	// is good or bad.
	EventFeedback *EventFeedbackType `type:"structure"`

	// The event ID.
	EventId *string `type:"string"`

	// The event response.
	EventResponse *string `type:"string" enum:"EventResponseType"`

	// The event risk.
	EventRisk *EventRiskType `type:"structure"`

	// The event type.
	EventType *string `type:"string" enum:"EventType"`
}

// String returns the string representation
func (s AuthEventType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthEventType) GoString() string {
	return s.String()
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *AuthEventType) SetChallengeResponses(v []*ChallengeResponseType) *AuthEventType {
	s.ChallengeResponses = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AuthEventType) SetCreationDate(v time.Time) *AuthEventType {
	s.CreationDate = &v
	return s
}

// SetEventContextData sets the EventContextData field's value.
func (s *AuthEventType) SetEventContextData(v *EventContextDataType) *AuthEventType {
	s.EventContextData = v
	return s
}

// SetEventFeedback sets the EventFeedback field's value.
func (s *AuthEventType) SetEventFeedback(v *EventFeedbackType) *AuthEventType {
	s.EventFeedback = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *AuthEventType) SetEventId(v string) *AuthEventType {
	s.EventId = &v
	return s
}

// SetEventResponse sets the EventResponse field's value.
func (s *AuthEventType) SetEventResponse(v string) *AuthEventType {
	s.EventResponse = &v
	return s
}

// SetEventRisk sets the EventRisk field's value.
func (s *AuthEventType) SetEventRisk(v *EventRiskType) *AuthEventType {
	s.EventRisk = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *AuthEventType) SetEventType(v string) *AuthEventType {
	s.EventType = &v
	return s
}

// The authentication result.
type AuthenticationResultType struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`

	// The expiration period of the authentication result.
	ExpiresIn *int64 `type:"integer"`

	// The ID token.
	IdToken *string `type:"string"`

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType `type:"structure"`

	// The refresh token.
	RefreshToken *string `type:"string"`

	// The token type.
	TokenType *string `type:"string"`
}

// String returns the string representation
func (s AuthenticationResultType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthenticationResultType) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *AuthenticationResultType) SetAccessToken(v string) *AuthenticationResultType {
	s.AccessToken = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *AuthenticationResultType) SetExpiresIn(v int64) *AuthenticationResultType {
	s.ExpiresIn = &v
	return s
}

// SetIdToken sets the IdToken field's value.
func (s *AuthenticationResultType) SetIdToken(v string) *AuthenticationResultType {
	s.IdToken = &v
	return s
}

// SetNewDeviceMetadata sets the NewDeviceMetadata field's value.
func (s *AuthenticationResultType) SetNewDeviceMetadata(v *NewDeviceMetadataType) *AuthenticationResultType {
	s.NewDeviceMetadata = v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *AuthenticationResultType) SetRefreshToken(v string) *AuthenticationResultType {
	s.RefreshToken = &v
	return s
}

// SetTokenType sets the TokenType field's value.
func (s *AuthenticationResultType) SetTokenType(v string) *AuthenticationResultType {
	s.TokenType = &v
	return s
}

// The challenge response type.
type ChallengeResponseType struct {
	_ struct{} `type:"structure"`

	// The challenge name
	ChallengeName *string `type:"string" enum:"ChallengeName"`

	// The challenge response.
	ChallengeResponse *string `type:"string" enum:"ChallengeResponse"`
}

// String returns the string representation
func (s ChallengeResponseType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChallengeResponseType) GoString() string {
	return s.String()
}

// SetChallengeName sets the ChallengeName field's value.
func (s *ChallengeResponseType) SetChallengeName(v string) *ChallengeResponseType {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponse sets the ChallengeResponse field's value.
func (s *ChallengeResponseType) SetChallengeResponse(v string) *ChallengeResponseType {
	s.ChallengeResponse = &v
	return s
}

// Represents the request to change a user password.
type ChangePasswordInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The old password.
	//
	// PreviousPassword is a required field
	PreviousPassword *string `min:"6" type:"string" required:"true"`

	// The new password.
	//
	// ProposedPassword is a required field
	ProposedPassword *string `min:"6" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangePasswordInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.PreviousPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("PreviousPassword"))
	}
	if s.PreviousPassword != nil && len(*s.PreviousPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("PreviousPassword", 6))
	}
	if s.ProposedPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposedPassword"))
	}
	if s.ProposedPassword != nil && len(*s.ProposedPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ProposedPassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ChangePasswordInput) SetAccessToken(v string) *ChangePasswordInput {
	s.AccessToken = &v
	return s
}

// SetPreviousPassword sets the PreviousPassword field's value.
func (s *ChangePasswordInput) SetPreviousPassword(v string) *ChangePasswordInput {
	s.PreviousPassword = &v
	return s
}

// SetProposedPassword sets the ProposedPassword field's value.
func (s *ChangePasswordInput) SetProposedPassword(v string) *ChangePasswordInput {
	s.ProposedPassword = &v
	return s
}

// The response from the server to the change password request.
type ChangePasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordOutput) GoString() string {
	return s.String()
}

// The code delivery details being returned from the server.
type CodeDeliveryDetailsType struct {
	_ struct{} `type:"structure"`

	// The attribute name.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or phone number).
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`

	// The destination for the code delivery details.
	Destination *string `type:"string"`
}

// String returns the string representation
func (s CodeDeliveryDetailsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeDeliveryDetailsType) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *CodeDeliveryDetailsType) SetAttributeName(v string) *CodeDeliveryDetailsType {
	s.AttributeName = &v
	return s
}

// SetDeliveryMedium sets the DeliveryMedium field's value.
func (s *CodeDeliveryDetailsType) SetDeliveryMedium(v string) *CodeDeliveryDetailsType {
	s.DeliveryMedium = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *CodeDeliveryDetailsType) SetDestination(v string) *CodeDeliveryDetailsType {
	s.Destination = &v
	return s
}

// The compromised credentials actions type
type CompromisedCredentialsActionsType struct {
	_ struct{} `type:"structure"`

	// The event action.
	//
	// EventAction is a required field
	EventAction *string `type:"string" required:"true" enum:"CompromisedCredentialsEventActionType"`
}

// String returns the string representation
func (s CompromisedCredentialsActionsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompromisedCredentialsActionsType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsActionsType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompromisedCredentialsActionsType"}
	if s.EventAction == nil {
		invalidParams.Add(request.NewErrParamRequired("EventAction"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventAction sets the EventAction field's value.
func (s *CompromisedCredentialsActionsType) SetEventAction(v string) *CompromisedCredentialsActionsType {
	s.EventAction = &v
	return s
}

// The compromised credentials risk configuration type.
type CompromisedCredentialsRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The compromised credentials risk configuration actions.
	//
	// Actions is a required field
	Actions *CompromisedCredentialsActionsType `type:"structure" required:"true"`

	// Perform the action for these events. The default is to perform all events
	// if no event filter is specified.
	EventFilter []*string `type:"list"`
}

// String returns the string representation
func (s CompromisedCredentialsRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompromisedCredentialsRiskConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsRiskConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompromisedCredentialsRiskConfigurationType"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CompromisedCredentialsRiskConfigurationType) SetActions(v *CompromisedCredentialsActionsType) *CompromisedCredentialsRiskConfigurationType {
	s.Actions = v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *CompromisedCredentialsRiskConfigurationType) SetEventFilter(v []*string) *CompromisedCredentialsRiskConfigurationType {
	s.EventFilter = v
	return s
}

// Confirms the device request.
type ConfirmDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The device name.
	DeviceName *string `min:"1" type:"string"`

	// The configuration of the device secret verifier.
	DeviceSecretVerifierConfig *DeviceSecretVerifierConfigType `type:"structure"`
}

// String returns the string representation
func (s ConfirmDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmDeviceInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ConfirmDeviceInput) SetAccessToken(v string) *ConfirmDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *ConfirmDeviceInput) SetDeviceKey(v string) *ConfirmDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *ConfirmDeviceInput) SetDeviceName(v string) *ConfirmDeviceInput {
	s.DeviceName = &v
	return s
}

// SetDeviceSecretVerifierConfig sets the DeviceSecretVerifierConfig field's value.
func (s *ConfirmDeviceInput) SetDeviceSecretVerifierConfig(v *DeviceSecretVerifierConfigType) *ConfirmDeviceInput {
	s.DeviceSecretVerifierConfig = v
	return s
}

// Confirms the device response.
type ConfirmDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the user confirmation is necessary to confirm the device
	// response.
	UserConfirmationNecessary *bool `type:"boolean"`
}

// String returns the string representation
func (s ConfirmDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmDeviceOutput) GoString() string {
	return s.String()
}

// SetUserConfirmationNecessary sets the UserConfirmationNecessary field's value.
func (s *ConfirmDeviceOutput) SetUserConfirmationNecessary(v bool) *ConfirmDeviceOutput {
	s.UserConfirmationNecessary = &v
	return s
}

// The request representing the confirmation for a password reset.
type ConfirmForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmForgotPassword
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The confirmation code sent by a user's request to retrieve a forgotten password.
	// For more information, see
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// The password sent by a user's request to retrieve a forgotten password.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user for whom you want to enter a code to retrieve a
	// forgotten password.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ConfirmForgotPasswordInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ConfirmForgotPasswordInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ConfirmForgotPasswordInput) SetClientId(v string) *ConfirmForgotPasswordInput {
	s.ClientId = &v
	return s
}

// SetConfirmationCode sets the ConfirmationCode field's value.
func (s *ConfirmForgotPasswordInput) SetConfirmationCode(v string) *ConfirmForgotPasswordInput {
	s.ConfirmationCode = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ConfirmForgotPasswordInput) SetPassword(v string) *ConfirmForgotPasswordInput {
	s.Password = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ConfirmForgotPasswordInput) SetSecretHash(v string) *ConfirmForgotPasswordInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ConfirmForgotPasswordInput) SetUserContextData(v *UserContextDataType) *ConfirmForgotPasswordInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ConfirmForgotPasswordInput) SetUsername(v string) *ConfirmForgotPasswordInput {
	s.Username = &v
	return s
}

// The response from the server that results from a user's request to retrieve
// a forgotten password.
type ConfirmForgotPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmForgotPasswordOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm registration of a user.
type ConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmSignUp
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the app client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The confirmation code sent by a user's request to confirm registration.
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// Boolean to be specified to force user confirmation irrespective of existing
	// alias. By default set to False. If this parameter is set to True and the
	// phone number/email used for sign up confirmation already exists as an alias
	// with a different user, the API call will migrate the alias from the previous
	// user to the newly created user being confirmed. If set to False, the API
	// will throw an AliasExistsException error.
	ForceAliasCreation *bool `type:"boolean"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user whose registration you wish to confirm.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmSignUpInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ConfirmSignUpInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ConfirmSignUpInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ConfirmSignUpInput) SetClientId(v string) *ConfirmSignUpInput {
	s.ClientId = &v
	return s
}

// SetConfirmationCode sets the ConfirmationCode field's value.
func (s *ConfirmSignUpInput) SetConfirmationCode(v string) *ConfirmSignUpInput {
	s.ConfirmationCode = &v
	return s
}

// SetForceAliasCreation sets the ForceAliasCreation field's value.
func (s *ConfirmSignUpInput) SetForceAliasCreation(v bool) *ConfirmSignUpInput {
	s.ForceAliasCreation = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ConfirmSignUpInput) SetSecretHash(v string) *ConfirmSignUpInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ConfirmSignUpInput) SetUserContextData(v *UserContextDataType) *ConfirmSignUpInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ConfirmSignUpInput) SetUsername(v string) *ConfirmSignUpInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the registration confirmation.
type ConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSignUpOutput) GoString() string {
	return s.String()
}

// Contextual user data type used for evaluating the risk of an unexpected event
// by Amazon Cognito advanced security.
type ContextDataType struct {
	_ struct{} `type:"structure"`

	// Encoded data containing device fingerprinting details, collected using the
	// Amazon Cognito context data collection library.
	EncodedData *string `type:"string"`

	// HttpHeaders received on your server in same order.
	//
	// HttpHeaders is a required field
	HttpHeaders []*HttpHeader `type:"list" required:"true"`

	// Source IP address of your user.
	//
	// IpAddress is a required field
	IpAddress *string `type:"string" required:"true"`

	// Your server endpoint where this API is invoked.
	//
	// ServerName is a required field
	ServerName *string `type:"string" required:"true"`

	// Your server path where this API is invoked.
	//
	// ServerPath is a required field
	ServerPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ContextDataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContextDataType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextDataType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContextDataType"}
	if s.HttpHeaders == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpHeaders"))
	}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerPath == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncodedData sets the EncodedData field's value.
func (s *ContextDataType) SetEncodedData(v string) *ContextDataType {
	s.EncodedData = &v
	return s
}

// SetHttpHeaders sets the HttpHeaders field's value.
func (s *ContextDataType) SetHttpHeaders(v []*HttpHeader) *ContextDataType {
	s.HttpHeaders = v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *ContextDataType) SetIpAddress(v string) *ContextDataType {
	s.IpAddress = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ContextDataType) SetServerName(v string) *ContextDataType {
	s.ServerName = &v
	return s
}

// SetServerPath sets the ServerPath field's value.
func (s *ContextDataType) SetServerPath(v string) *ContextDataType {
	s.ServerPath = &v
	return s
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// A string containing the description of the group.
	Description *string `type:"string"`

	// The name of the group. Must be unique.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// A nonnegative integer value that specifies the precedence of this group relative
	// to the other groups that a user can belong to in the user pool. Zero is the
	// highest precedence value. Groups with lower Precedence values take precedence
	// over groups with higher or null Precedence values. If a user belongs to two
	// or more groups, it is the group with the lowest precedence value whose role
	// ARN will be used in the cognito:roles and cognito:preferred_role claims in
	// the user's tokens.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim
	// in tokens for users in each group. If the two groups have different role
	// ARNs, the cognito:preferred_role claim is not set in users' tokens.
	//
	// The default Precedence value is null.
	Precedence *int64 `type:"integer"`

	// The role ARN for the group.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetPrecedence sets the Precedence field's value.
func (s *CreateGroupInput) SetPrecedence(v int64) *CreateGroupInput {
	s.Precedence = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateGroupInput) SetRoleArn(v string) *CreateGroupInput {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateGroupInput) SetUserPoolId(v string) *CreateGroupInput {
	s.UserPoolId = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *GroupType) *CreateGroupOutput {
	s.Group = v
	return s
}

type CreateIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]*string `type:"map"`

	// A list of identity provider identifiers.
	IdpIdentifiers []*string `type:"list"`

	// The identity provider details, such as MetadataURL and MetadataFile.
	//
	// ProviderDetails is a required field
	ProviderDetails map[string]*string `type:"map" required:"true"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The identity provider type.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"IdentityProviderTypeType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdentityProviderInput"}
	if s.ProviderDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderDetails"))
	}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.ProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderType"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeMapping sets the AttributeMapping field's value.
func (s *CreateIdentityProviderInput) SetAttributeMapping(v map[string]*string) *CreateIdentityProviderInput {
	s.AttributeMapping = v
	return s
}

// SetIdpIdentifiers sets the IdpIdentifiers field's value.
func (s *CreateIdentityProviderInput) SetIdpIdentifiers(v []*string) *CreateIdentityProviderInput {
	s.IdpIdentifiers = v
	return s
}

// SetProviderDetails sets the ProviderDetails field's value.
func (s *CreateIdentityProviderInput) SetProviderDetails(v map[string]*string) *CreateIdentityProviderInput {
	s.ProviderDetails = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreateIdentityProviderInput) SetProviderName(v string) *CreateIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CreateIdentityProviderInput) SetProviderType(v string) *CreateIdentityProviderInput {
	s.ProviderType = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateIdentityProviderInput) SetUserPoolId(v string) *CreateIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type CreateIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The newly created identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *CreateIdentityProviderOutput) SetIdentityProvider(v *IdentityProviderType) *CreateIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type CreateResourceServerInput struct {
	_ struct{} `type:"structure"`

	// A unique resource server identifier for the resource server. This could be
	// an HTTPS endpoint where the resource server is located. For example, https://my-weather-api.example.com.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// A friendly name for the resource server.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of scopes. Each scope is map, where the keys are name and description.
	Scopes []*ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Scopes != nil {
		for i, v := range s.Scopes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Scopes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *CreateResourceServerInput) SetIdentifier(v string) *CreateResourceServerInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceServerInput) SetName(v string) *CreateResourceServerInput {
	s.Name = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *CreateResourceServerInput) SetScopes(v []*ResourceServerScopeType) *CreateResourceServerInput {
	s.Scopes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateResourceServerInput) SetUserPoolId(v string) *CreateResourceServerInput {
	s.UserPoolId = &v
	return s
}

type CreateResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The newly created resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceServerOutput) GoString() string {
	return s.String()
}

// SetResourceServer sets the ResourceServer field's value.
func (s *CreateResourceServerOutput) SetResourceServer(v *ResourceServerType) *CreateResourceServerOutput {
	s.ResourceServer = v
	return s
}

// Represents the request to create the user import job.
type CreateUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `min:"20" type:"string" required:"true"`

	// The job name for the user import job.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserImportJobInput"}
	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if s.CloudWatchLogsRoleArn != nil && len(*s.CloudWatchLogsRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogsRoleArn", 20))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateUserImportJobInput) SetCloudWatchLogsRoleArn(v string) *CreateUserImportJobInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateUserImportJobInput) SetJobName(v string) *CreateUserImportJobInput {
	s.JobName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserImportJobInput) SetUserPoolId(v string) *CreateUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to create the user
// import job.
type CreateUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s CreateUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *CreateUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *CreateUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// Represents the request to create a user pool client.
type CreateUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// Set to code to initiate a code grant flow, which provides an authorization
	// code as the response. This code can be exchanged for access tokens with the
	// token endpoint.
	//
	// Set to token to specify that the client should get the access token (and,
	// optionally, ID token, based on scopes) directly.
	AllowedOAuthFlows []*string `type:"list"`

	// Set to True if the client is allowed to follow the OAuth protocol when interacting
	// with Cognito user pools.
	AllowedOAuthFlowsUserPoolClient *bool `type:"boolean"`

	// A list of allowed OAuth scopes. Currently supported values are "phone", "email",
	// "openid", and "Cognito".
	AllowedOAuthScopes []*string `type:"list"`

	// The Amazon Pinpoint analytics configuration for collecting metrics for this
	// user pool.
	AnalyticsConfiguration *AnalyticsConfigurationType `type:"structure"`

	// A list of allowed callback URLs for the identity providers.
	CallbackURLs []*string `type:"list"`

	// The client name for the user pool client you would like to create.
	//
	// ClientName is a required field
	ClientName *string `min:"1" type:"string" required:"true"`

	// The default redirect URI. Must be in the CallbackURLs list.
	DefaultRedirectURI *string `min:"1" type:"string"`

	// The explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// Boolean to specify whether you want to generate a secret for the user pool
	// client being created.
	GenerateSecret *bool `type:"boolean"`

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []*string `type:"list"`

	// The read attributes.
	ReadAttributes []*string `type:"list"`

	// The time limit, in days, after which the refresh token is no longer valid
	// and cannot be used.
	RefreshTokenValidity *int64 `type:"integer"`

	// A list of provider names for the identity providers that are supported on
	// this client.
	SupportedIdentityProviders []*string `type:"list"`

	// The user pool ID for the user pool where you want to create a user pool client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The write attributes.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s CreateUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolClientInput"}
	if s.ClientName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientName"))
	}
	if s.ClientName != nil && len(*s.ClientName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientName", 1))
	}
	if s.DefaultRedirectURI != nil && len(*s.DefaultRedirectURI) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultRedirectURI", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedOAuthFlows sets the AllowedOAuthFlows field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthFlows(v []*string) *CreateUserPoolClientInput {
	s.AllowedOAuthFlows = v
	return s
}

// SetAllowedOAuthFlowsUserPoolClient sets the AllowedOAuthFlowsUserPoolClient field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthFlowsUserPoolClient(v bool) *CreateUserPoolClientInput {
	s.AllowedOAuthFlowsUserPoolClient = &v
	return s
}

// SetAllowedOAuthScopes sets the AllowedOAuthScopes field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthScopes(v []*string) *CreateUserPoolClientInput {
	s.AllowedOAuthScopes = v
	return s
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *CreateUserPoolClientInput) SetAnalyticsConfiguration(v *AnalyticsConfigurationType) *CreateUserPoolClientInput {
	s.AnalyticsConfiguration = v
	return s
}

// SetCallbackURLs sets the CallbackURLs field's value.
func (s *CreateUserPoolClientInput) SetCallbackURLs(v []*string) *CreateUserPoolClientInput {
	s.CallbackURLs = v
	return s
}

// SetClientName sets the ClientName field's value.
func (s *CreateUserPoolClientInput) SetClientName(v string) *CreateUserPoolClientInput {
	s.ClientName = &v
	return s
}

// SetDefaultRedirectURI sets the DefaultRedirectURI field's value.
func (s *CreateUserPoolClientInput) SetDefaultRedirectURI(v string) *CreateUserPoolClientInput {
	s.DefaultRedirectURI = &v
	return s
}

// SetExplicitAuthFlows sets the ExplicitAuthFlows field's value.
func (s *CreateUserPoolClientInput) SetExplicitAuthFlows(v []*string) *CreateUserPoolClientInput {
	s.ExplicitAuthFlows = v
	return s
}

// SetGenerateSecret sets the GenerateSecret field's value.
func (s *CreateUserPoolClientInput) SetGenerateSecret(v bool) *CreateUserPoolClientInput {
	s.GenerateSecret = &v
	return s
}

// SetLogoutURLs sets the LogoutURLs field's value.
func (s *CreateUserPoolClientInput) SetLogoutURLs(v []*string) *CreateUserPoolClientInput {
	s.LogoutURLs = v
	return s
}

// SetReadAttributes sets the ReadAttributes field's value.
func (s *CreateUserPoolClientInput) SetReadAttributes(v []*string) *CreateUserPoolClientInput {
	s.ReadAttributes = v
	return s
}

// SetRefreshTokenValidity sets the RefreshTokenValidity field's value.
func (s *CreateUserPoolClientInput) SetRefreshTokenValidity(v int64) *CreateUserPoolClientInput {
	s.RefreshTokenValidity = &v
	return s
}

// SetSupportedIdentityProviders sets the SupportedIdentityProviders field's value.
func (s *CreateUserPoolClientInput) SetSupportedIdentityProviders(v []*string) *CreateUserPoolClientInput {
	s.SupportedIdentityProviders = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserPoolClientInput) SetUserPoolId(v string) *CreateUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

// SetWriteAttributes sets the WriteAttributes field's value.
func (s *CreateUserPoolClientInput) SetWriteAttributes(v []*string) *CreateUserPoolClientInput {
	s.WriteAttributes = v
	return s
}

// Represents the response from the server to create a user pool client.
type CreateUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client that was just created.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolClientOutput) GoString() string {
	return s.String()
}

// SetUserPoolClient sets the UserPoolClient field's value.
func (s *CreateUserPoolClientOutput) SetUserPoolClient(v *UserPoolClientType) *CreateUserPoolClientOutput {
	s.UserPoolClient = v
	return s
}

type CreateUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateUserPoolDomainInput) SetDomain(v string) *CreateUserPoolDomainInput {
	s.Domain = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserPoolDomainInput) SetUserPoolId(v string) *CreateUserPoolDomainInput {
	s.UserPoolId = &v
	return s
}

type CreateUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolDomainOutput) GoString() string {
	return s.String()
}

// Represents the request to create a user pool.
type CreateUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Attributes supported as an alias for this user pool. Possible values: phone_number,
	// email, or preferred_username.
	AliasAttributes []*string `type:"list"`

	// The attributes to be auto-verified. Possible values: email, phone_number.
	AutoVerifiedAttributes []*string `type:"list"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// The email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// A string representing the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// A string representing the email verification subject.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// The Lambda trigger configuration information for the new user pool.
	//
	// In a push model, event sources (such as Amazon S3 and custom applications)
	// need permission to invoke a function. So you will need to make an extra call
	// to add permission for these event sources to invoke your Lambda function.
	//
	// For more information on using the Lambda API to add permission, see  AddPermission
	//  (https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html).
	//
	// For adding permission using the AWS CLI, see  add-permission  (https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html).
	LambdaConfig *LambdaConfigType `type:"structure"`

	// Specifies MFA configuration details.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The policies associated with the new user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A string used to name the user pool.
	//
	// PoolName is a required field
	PoolName *string `min:"1" type:"string" required:"true"`

	// An array of schema attributes for the new user pool. These attributes can
	// be standard or custom attributes.
	Schema []*SchemaAttributeType `min:"1" type:"list"`

	// A string representing the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// A string representing the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// Used to enable advanced security risk detection. Set the key AdvancedSecurityMode
	// to the value "AUDIT".
	UserPoolAddOns *UserPoolAddOnsType `type:"structure"`

	// The cost allocation tags for the user pool. For more information, see Adding
	// Cost Allocation Tags to Your User Pool (http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html)
	UserPoolTags map[string]*string `type:"map"`

	// Specifies whether email addresses or phone numbers can be specified as usernames
	// when a user signs up.
	UsernameAttributes []*string `type:"list"`

	// The template for the verification message that the user sees when the app
	// requests permission to access the user's information.
	VerificationMessageTemplate *VerificationMessageTemplateType `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolInput"}
	if s.EmailVerificationMessage != nil && len(*s.EmailVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationMessage", 6))
	}
	if s.EmailVerificationSubject != nil && len(*s.EmailVerificationSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationSubject", 1))
	}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}
	if s.Schema != nil && len(s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsVerificationMessage != nil && len(*s.SmsVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsVerificationMessage", 6))
	}
	if s.AdminCreateUserConfig != nil {
		if err := s.AdminCreateUserConfig.Validate(); err != nil {
			invalidParams.AddNested("AdminCreateUserConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailConfiguration != nil {
		if err := s.EmailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Policies != nil {
		if err := s.Policies.Validate(); err != nil {
			invalidParams.AddNested("Policies", err.(request.ErrInvalidParams))
		}
	}
	if s.Schema != nil {
		for i, v := range s.Schema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolAddOns != nil {
		if err := s.UserPoolAddOns.Validate(); err != nil {
			invalidParams.AddNested("UserPoolAddOns", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationMessageTemplate != nil {
		if err := s.VerificationMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("VerificationMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminCreateUserConfig sets the AdminCreateUserConfig field's value.
func (s *CreateUserPoolInput) SetAdminCreateUserConfig(v *AdminCreateUserConfigType) *CreateUserPoolInput {
	s.AdminCreateUserConfig = v
	return s
}

// SetAliasAttributes sets the AliasAttributes field's value.
func (s *CreateUserPoolInput) SetAliasAttributes(v []*string) *CreateUserPoolInput {
	s.AliasAttributes = v
	return s
}

// SetAutoVerifiedAttributes sets the AutoVerifiedAttributes field's value.
func (s *CreateUserPoolInput) SetAutoVerifiedAttributes(v []*string) *CreateUserPoolInput {
	s.AutoVerifiedAttributes = v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *CreateUserPoolInput) SetDeviceConfiguration(v *DeviceConfigurationType) *CreateUserPoolInput {
	s.DeviceConfiguration = v
	return s
}

// SetEmailConfiguration sets the EmailConfiguration field's value.
func (s *CreateUserPoolInput) SetEmailConfiguration(v *EmailConfigurationType) *CreateUserPoolInput {
	s.EmailConfiguration = v
	return s
}

// SetEmailVerificationMessage sets the EmailVerificationMessage field's value.
func (s *CreateUserPoolInput) SetEmailVerificationMessage(v string) *CreateUserPoolInput {
	s.EmailVerificationMessage = &v
	return s
}

// SetEmailVerificationSubject sets the EmailVerificationSubject field's value.
func (s *CreateUserPoolInput) SetEmailVerificationSubject(v string) *CreateUserPoolInput {
	s.EmailVerificationSubject = &v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *CreateUserPoolInput) SetLambdaConfig(v *LambdaConfigType) *CreateUserPoolInput {
	s.LambdaConfig = v
	return s
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *CreateUserPoolInput) SetMfaConfiguration(v string) *CreateUserPoolInput {
	s.MfaConfiguration = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *CreateUserPoolInput) SetPolicies(v *UserPoolPolicyType) *CreateUserPoolInput {
	s.Policies = v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *CreateUserPoolInput) SetPoolName(v string) *CreateUserPoolInput {
	s.PoolName = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateUserPoolInput) SetSchema(v []*SchemaAttributeType) *CreateUserPoolInput {
	s.Schema = v
	return s
}

// SetSmsAuthenticationMessage sets the SmsAuthenticationMessage field's value.
func (s *CreateUserPoolInput) SetSmsAuthenticationMessage(v string) *CreateUserPoolInput {
	s.SmsAuthenticationMessage = &v
	return s
}

// SetSmsConfiguration sets the SmsConfiguration field's value.
func (s *CreateUserPoolInput) SetSmsConfiguration(v *SmsConfigurationType) *CreateUserPoolInput {
	s.SmsConfiguration = v
	return s
}

// SetSmsVerificationMessage sets the SmsVerificationMessage field's value.
func (s *CreateUserPoolInput) SetSmsVerificationMessage(v string) *CreateUserPoolInput {
	s.SmsVerificationMessage = &v
	return s
}

// SetUserPoolAddOns sets the UserPoolAddOns field's value.
func (s *CreateUserPoolInput) SetUserPoolAddOns(v *UserPoolAddOnsType) *CreateUserPoolInput {
	s.UserPoolAddOns = v
	return s
}

// SetUserPoolTags sets the UserPoolTags field's value.
func (s *CreateUserPoolInput) SetUserPoolTags(v map[string]*string) *CreateUserPoolInput {
	s.UserPoolTags = v
	return s
}

// SetUsernameAttributes sets the UsernameAttributes field's value.
func (s *CreateUserPoolInput) SetUsernameAttributes(v []*string) *CreateUserPoolInput {
	s.UsernameAttributes = v
	return s
}

// SetVerificationMessageTemplate sets the VerificationMessageTemplate field's value.
func (s *CreateUserPoolInput) SetVerificationMessageTemplate(v *VerificationMessageTemplateType) *CreateUserPoolInput {
	s.VerificationMessageTemplate = v
	return s
}

// Represents the response from the server for the request to create a user
// pool.
type CreateUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// A container for the user pool details.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolOutput) GoString() string {
	return s.String()
}

// SetUserPool sets the UserPool field's value.
func (s *CreateUserPoolOutput) SetUserPool(v *UserPoolType) *CreateUserPoolOutput {
	s.UserPool = v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteGroupInput) SetUserPoolId(v string) *DeleteGroupInput {
	s.UserPoolId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityProviderInput"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderName sets the ProviderName field's value.
func (s *DeleteIdentityProviderInput) SetProviderName(v string) *DeleteIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteIdentityProviderInput) SetUserPoolId(v string) *DeleteIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type DeleteIdentityProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityProviderOutput) GoString() string {
	return s.String()
}

type DeleteResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that hosts the resource server.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteResourceServerInput) SetIdentifier(v string) *DeleteResourceServerInput {
	s.Identifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteResourceServerInput) SetUserPoolId(v string) *DeleteResourceServerInput {
	s.UserPoolId = &v
	return s
}

type DeleteResourceServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceServerOutput) GoString() string {
	return s.String()
}

// Represents the request to delete user attributes.
type DeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// The access token used in the request to delete user attributes.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// An array of strings representing the user attribute names you wish to delete.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserAttributesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *DeleteUserAttributesInput) SetAccessToken(v string) *DeleteUserAttributesInput {
	s.AccessToken = &v
	return s
}

// SetUserAttributeNames sets the UserAttributeNames field's value.
func (s *DeleteUserAttributesInput) SetUserAttributeNames(v []*string) *DeleteUserAttributesInput {
	s.UserAttributeNames = v
	return s
}

// Represents the response from the server to delete user attributes.
type DeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user.
type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The access token from a request to delete a user.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *DeleteUserInput) SetAccessToken(v string) *DeleteUserInput {
	s.AccessToken = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool client.
type DeleteUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool where you want to delete the client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DeleteUserPoolClientInput) SetClientId(v string) *DeleteUserPoolClientInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolClientInput) SetUserPoolId(v string) *DeleteUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolClientOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolClientOutput) GoString() string {
	return s.String()
}

type DeleteUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteUserPoolDomainInput) SetDomain(v string) *DeleteUserPoolDomainInput {
	s.Domain = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolDomainInput) SetUserPoolId(v string) *DeleteUserPoolDomainInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolDomainOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool.
type DeleteUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to delete.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolInput) SetUserPoolId(v string) *DeleteUserPoolInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolOutput) GoString() string {
	return s.String()
}

type DescribeIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityProviderInput"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeIdentityProviderInput) SetProviderName(v string) *DescribeIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeIdentityProviderInput) SetUserPoolId(v string) *DescribeIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type DescribeIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider that was deleted.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *DescribeIdentityProviderOutput) SetIdentityProvider(v *IdentityProviderType) *DescribeIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type DescribeResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that hosts the resource server.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DescribeResourceServerInput) SetIdentifier(v string) *DescribeResourceServerInput {
	s.Identifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeResourceServerInput) SetUserPoolId(v string) *DescribeResourceServerInput {
	s.UserPoolId = &v
	return s
}

type DescribeResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceServerOutput) GoString() string {
	return s.String()
}

// SetResourceServer sets the ResourceServer field's value.
func (s *DescribeResourceServerOutput) SetResourceServer(v *ResourceServerType) *DescribeResourceServerOutput {
	s.ResourceServer = v
	return s
}

type DescribeRiskConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The app client ID.
	ClientId *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRiskConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRiskConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRiskConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRiskConfigurationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DescribeRiskConfigurationInput) SetClientId(v string) *DescribeRiskConfigurationInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeRiskConfigurationInput) SetUserPoolId(v string) *DescribeRiskConfigurationInput {
	s.UserPoolId = &v
	return s
}

type DescribeRiskConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The risk configuration.
	//
	// RiskConfiguration is a required field
	RiskConfiguration *RiskConfigurationType `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeRiskConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRiskConfigurationOutput) GoString() string {
	return s.String()
}

// SetRiskConfiguration sets the RiskConfiguration field's value.
func (s *DescribeRiskConfigurationOutput) SetRiskConfiguration(v *RiskConfigurationType) *DescribeRiskConfigurationOutput {
	s.RiskConfiguration = v
	return s
}

// Represents the request to describe the user import job.
type DescribeUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeUserImportJobInput) SetJobId(v string) *DescribeUserImportJobInput {
	s.JobId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserImportJobInput) SetUserPoolId(v string) *DescribeUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to describe the user
// import job.
type DescribeUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *DescribeUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *DescribeUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// Represents the request to describe a user pool client.
type DescribeUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DescribeUserPoolClientInput) SetClientId(v string) *DescribeUserPoolClientInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserPoolClientInput) SetUserPoolId(v string) *DescribeUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server from a request to describe the user
// pool client.
type DescribeUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client from a server response to describe the user pool client.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolClientOutput) GoString() string {
	return s.String()
}

// SetUserPoolClient sets the UserPoolClient field's value.
func (s *DescribeUserPoolClientOutput) SetUserPoolClient(v *UserPoolClientType) *DescribeUserPoolClientOutput {
	s.UserPoolClient = v
	return s
}

type DescribeUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeUserPoolDomainInput) SetDomain(v string) *DescribeUserPoolDomainInput {
	s.Domain = &v
	return s
}

type DescribeUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`

	// A domain description object containing information about the domain.
	DomainDescription *DomainDescriptionType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolDomainOutput) GoString() string {
	return s.String()
}

// SetDomainDescription sets the DomainDescription field's value.
func (s *DescribeUserPoolDomainOutput) SetDomainDescription(v *DomainDescriptionType) *DescribeUserPoolDomainOutput {
	s.DomainDescription = v
	return s
}

// Represents the request to describe the user pool.
type DescribeUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserPoolInput) SetUserPoolId(v string) *DescribeUserPoolInput {
	s.UserPoolId = &v
	return s
}

// Represents the response to describe the user pool.
type DescribeUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// The container of metadata returned by the server to describe the pool.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolOutput) GoString() string {
	return s.String()
}

// SetUserPool sets the UserPool field's value.
func (s *DescribeUserPoolOutput) SetUserPool(v *UserPoolType) *DescribeUserPoolOutput {
	s.UserPool = v
	return s
}

// The configuration for the user pool's device tracking.
type DeviceConfigurationType struct {
	_ struct{} `type:"structure"`

	// Indicates whether a challenge is required on a new device. Only applicable
	// to a new device.
	ChallengeRequiredOnNewDevice *bool `type:"boolean"`

	// If true, a device is only remembered on user prompt.
	DeviceOnlyRememberedOnUserPrompt *bool `type:"boolean"`
}

// String returns the string representation
func (s DeviceConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceConfigurationType) GoString() string {
	return s.String()
}

// SetChallengeRequiredOnNewDevice sets the ChallengeRequiredOnNewDevice field's value.
func (s *DeviceConfigurationType) SetChallengeRequiredOnNewDevice(v bool) *DeviceConfigurationType {
	s.ChallengeRequiredOnNewDevice = &v
	return s
}

// SetDeviceOnlyRememberedOnUserPrompt sets the DeviceOnlyRememberedOnUserPrompt field's value.
func (s *DeviceConfigurationType) SetDeviceOnlyRememberedOnUserPrompt(v bool) *DeviceConfigurationType {
	s.DeviceOnlyRememberedOnUserPrompt = &v
	return s
}

// The device verifier against which it will be authenticated.
type DeviceSecretVerifierConfigType struct {
	_ struct{} `type:"structure"`

	// The password verifier.
	PasswordVerifier *string `type:"string"`

	// The salt.
	Salt *string `type:"string"`
}

// String returns the string representation
func (s DeviceSecretVerifierConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceSecretVerifierConfigType) GoString() string {
	return s.String()
}

// SetPasswordVerifier sets the PasswordVerifier field's value.
func (s *DeviceSecretVerifierConfigType) SetPasswordVerifier(v string) *DeviceSecretVerifierConfigType {
	s.PasswordVerifier = &v
	return s
}

// SetSalt sets the Salt field's value.
func (s *DeviceSecretVerifierConfigType) SetSalt(v string) *DeviceSecretVerifierConfigType {
	s.Salt = &v
	return s
}

// The device type.
type DeviceType struct {
	_ struct{} `type:"structure"`

	// The device attributes.
	DeviceAttributes []*AttributeType `type:"list"`

	// The creation date of the device.
	DeviceCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`

	// The date in which the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last modified date of the device.
	DeviceLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DeviceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceType) GoString() string {
	return s.String()
}

// SetDeviceAttributes sets the DeviceAttributes field's value.
func (s *DeviceType) SetDeviceAttributes(v []*AttributeType) *DeviceType {
	s.DeviceAttributes = v
	return s
}

// SetDeviceCreateDate sets the DeviceCreateDate field's value.
func (s *DeviceType) SetDeviceCreateDate(v time.Time) *DeviceType {
	s.DeviceCreateDate = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *DeviceType) SetDeviceKey(v string) *DeviceType {
	s.DeviceKey = &v
	return s
}

// SetDeviceLastAuthenticatedDate sets the DeviceLastAuthenticatedDate field's value.
func (s *DeviceType) SetDeviceLastAuthenticatedDate(v time.Time) *DeviceType {
	s.DeviceLastAuthenticatedDate = &v
	return s
}

// SetDeviceLastModifiedDate sets the DeviceLastModifiedDate field's value.
func (s *DeviceType) SetDeviceLastModifiedDate(v time.Time) *DeviceType {
	s.DeviceLastModifiedDate = &v
	return s
}

// A container for information about a domain.
type DomainDescriptionType struct {
	_ struct{} `type:"structure"`

	// The AWS account ID for the user pool owner.
	AWSAccountId *string `type:"string"`

	// The ARN of the CloudFront distribution.
	CloudFrontDistribution *string `min:"20" type:"string"`

	// The domain string.
	Domain *string `min:"1" type:"string"`

	// The S3 bucket where the static files for this domain are stored.
	S3Bucket *string `min:"3" type:"string"`

	// The domain status.
	Status *string `type:"string" enum:"DomainStatusType"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`

	// The app version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DomainDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDescriptionType) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *DomainDescriptionType) SetAWSAccountId(v string) *DomainDescriptionType {
	s.AWSAccountId = &v
	return s
}

// SetCloudFrontDistribution sets the CloudFrontDistribution field's value.
func (s *DomainDescriptionType) SetCloudFrontDistribution(v string) *DomainDescriptionType {
	s.CloudFrontDistribution = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DomainDescriptionType) SetDomain(v string) *DomainDescriptionType {
	s.Domain = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *DomainDescriptionType) SetS3Bucket(v string) *DomainDescriptionType {
	s.S3Bucket = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainDescriptionType) SetStatus(v string) *DomainDescriptionType {
	s.Status = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DomainDescriptionType) SetUserPoolId(v string) *DomainDescriptionType {
	s.UserPoolId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DomainDescriptionType) SetVersion(v string) *DomainDescriptionType {
	s.Version = &v
	return s
}

// The email configuration type.
type EmailConfigurationType struct {
	_ struct{} `type:"structure"`

	// The destination to which the receiver of the email should reply to.
	ReplyToEmailAddress *string `type:"string"`

	// The Amazon Resource Name (ARN) of the email source.
	SourceArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s EmailConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailConfigurationType"}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplyToEmailAddress sets the ReplyToEmailAddress field's value.
func (s *EmailConfigurationType) SetReplyToEmailAddress(v string) *EmailConfigurationType {
	s.ReplyToEmailAddress = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *EmailConfigurationType) SetSourceArn(v string) *EmailConfigurationType {
	s.SourceArn = &v
	return s
}

// Specifies the user context data captured at the time of an event request.
type EventContextDataType struct {
	_ struct{} `type:"structure"`

	// The user's city.
	City *string `type:"string"`

	// The user's country.
	Country *string `type:"string"`

	// The user's device name.
	DeviceName *string `type:"string"`

	// The user's IP address.
	IpAddress *string `type:"string"`

	// The user's time zone.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EventContextDataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventContextDataType) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EventContextDataType) SetCity(v string) *EventContextDataType {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EventContextDataType) SetCountry(v string) *EventContextDataType {
	s.Country = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *EventContextDataType) SetDeviceName(v string) *EventContextDataType {
	s.DeviceName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *EventContextDataType) SetIpAddress(v string) *EventContextDataType {
	s.IpAddress = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EventContextDataType) SetTimezone(v string) *EventContextDataType {
	s.Timezone = &v
	return s
}

// Specifies the event feedback type.
type EventFeedbackType struct {
	_ struct{} `type:"structure"`

	// The event feedback date.
	FeedbackDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue *string `type:"string" required:"true" enum:"FeedbackValueType"`

	// The provider.
	//
	// Provider is a required field
	Provider *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventFeedbackType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventFeedbackType) GoString() string {
	return s.String()
}

// SetFeedbackDate sets the FeedbackDate field's value.
func (s *EventFeedbackType) SetFeedbackDate(v time.Time) *EventFeedbackType {
	s.FeedbackDate = &v
	return s
}

// SetFeedbackValue sets the FeedbackValue field's value.
func (s *EventFeedbackType) SetFeedbackValue(v string) *EventFeedbackType {
	s.FeedbackValue = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *EventFeedbackType) SetProvider(v string) *EventFeedbackType {
	s.Provider = &v
	return s
}

// The event risk type.
type EventRiskType struct {
	_ struct{} `type:"structure"`

	// The risk decision.
	RiskDecision *string `type:"string" enum:"RiskDecisionType"`

	// The risk level.
	RiskLevel *string `type:"string" enum:"RiskLevelType"`
}

// String returns the string representation
func (s EventRiskType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventRiskType) GoString() string {
	return s.String()
}

// SetRiskDecision sets the RiskDecision field's value.
func (s *EventRiskType) SetRiskDecision(v string) *EventRiskType {
	s.RiskDecision = &v
	return s
}

// SetRiskLevel sets the RiskLevel field's value.
func (s *EventRiskType) SetRiskLevel(v string) *EventRiskType {
	s.RiskLevel = &v
	return s
}

// Represents the request to forget the device.
type ForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token for the forgotten device request.
	AccessToken *string `type:"string"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ForgetDeviceInput) SetAccessToken(v string) *ForgetDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *ForgetDeviceInput) SetDeviceKey(v string) *ForgetDeviceInput {
	s.DeviceKey = &v
	return s
}

type ForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password.
type ForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ForgotPassword
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user for whom you want to enter a code to reset a forgotten
	// password.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ForgotPasswordInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ForgotPasswordInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ForgotPasswordInput) SetClientId(v string) *ForgotPasswordInput {
	s.ClientId = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ForgotPasswordInput) SetSecretHash(v string) *ForgotPasswordInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ForgotPasswordInput) SetUserContextData(v *UserContextDataType) *ForgotPasswordInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ForgotPasswordInput) SetUsername(v string) *ForgotPasswordInput {
	s.Username = &v
	return s
}

// Respresents the response from the server regarding the request to reset a
// password.
type ForgotPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to reset a password.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s ForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgotPasswordOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *ForgotPasswordOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *ForgotPasswordOutput {
	s.CodeDeliveryDetails = v
	return s
}

// Represents the request to get the header information for the .csv file for
// the user import job.
type GetCSVHeaderInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool that the users are to be imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCSVHeaderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCSVHeaderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCSVHeaderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCSVHeaderInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetCSVHeaderInput) SetUserPoolId(v string) *GetCSVHeaderInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to get the header
// information for the .csv file for the user import job.
type GetCSVHeaderOutput struct {
	_ struct{} `type:"structure"`

	// The header information for the .csv file for the user import job.
	CSVHeader []*string `type:"list"`

	// The user pool ID for the user pool that the users are to be imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCSVHeaderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCSVHeaderOutput) GoString() string {
	return s.String()
}

// SetCSVHeader sets the CSVHeader field's value.
func (s *GetCSVHeaderOutput) SetCSVHeader(v []*string) *GetCSVHeaderOutput {
	s.CSVHeader = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetCSVHeaderOutput) SetUserPoolId(v string) *GetCSVHeaderOutput {
	s.UserPoolId = &v
	return s
}

// Represents the request to get the device.
type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetDeviceInput) SetAccessToken(v string) *GetDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *GetDeviceInput) SetDeviceKey(v string) *GetDeviceInput {
	s.DeviceKey = &v
	return s
}

// Gets the device response.
type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *DeviceType) *GetDeviceOutput {
	s.Device = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetGroupInput) SetUserPoolId(v string) *GetGroupInput {
	s.UserPoolId = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *GroupType) *GetGroupOutput {
	s.Group = v
	return s
}

type GetIdentityProviderByIdentifierInput struct {
	_ struct{} `type:"structure"`

	// The identity provider ID.
	//
	// IdpIdentifier is a required field
	IdpIdentifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityProviderByIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityProviderByIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityProviderByIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityProviderByIdentifierInput"}
	if s.IdpIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdpIdentifier"))
	}
	if s.IdpIdentifier != nil && len(*s.IdpIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdpIdentifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdpIdentifier sets the IdpIdentifier field's value.
func (s *GetIdentityProviderByIdentifierInput) SetIdpIdentifier(v string) *GetIdentityProviderByIdentifierInput {
	s.IdpIdentifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetIdentityProviderByIdentifierInput) SetUserPoolId(v string) *GetIdentityProviderByIdentifierInput {
	s.UserPoolId = &v
	return s
}

type GetIdentityProviderByIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetIdentityProviderByIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityProviderByIdentifierOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *GetIdentityProviderByIdentifierOutput) SetIdentityProvider(v *IdentityProviderType) *GetIdentityProviderByIdentifierOutput {
	s.IdentityProvider = v
	return s
}

// Request to get a signing certificate from Cognito.
type GetSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningCertificateInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetSigningCertificateInput) SetUserPoolId(v string) *GetSigningCertificateInput {
	s.UserPoolId = &v
	return s
}

// Response from Cognito for a signing certificate request.
type GetSigningCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The signing certificate.
	Certificate *string `type:"string"`
}

// String returns the string representation
func (s GetSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetSigningCertificateOutput) SetCertificate(v string) *GetSigningCertificateOutput {
	s.Certificate = &v
	return s
}

type GetUICustomizationInput struct {
	_ struct{} `type:"structure"`

	// The client ID for the client app.
	ClientId *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUICustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUICustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUICustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUICustomizationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *GetUICustomizationInput) SetClientId(v string) *GetUICustomizationInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetUICustomizationInput) SetUserPoolId(v string) *GetUICustomizationInput {
	s.UserPoolId = &v
	return s
}

type GetUICustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The UI customization information.
	//
	// UICustomization is a required field
	UICustomization *UICustomizationType `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUICustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUICustomizationOutput) GoString() string {
	return s.String()
}

// SetUICustomization sets the UICustomization field's value.
func (s *GetUICustomizationOutput) SetUICustomization(v *UICustomizationType) *GetUICustomizationOutput {
	s.UICustomization = v
	return s
}

// Represents the request to get user attribute verification.
type GetUserAttributeVerificationCodeInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get the user attribute
	// verification code.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The attribute name returned by the server response to get the user attribute
	// verification code.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserAttributeVerificationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserAttributeVerificationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserAttributeVerificationCodeInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetUserAttributeVerificationCodeInput) SetAccessToken(v string) *GetUserAttributeVerificationCodeInput {
	s.AccessToken = &v
	return s
}

// SetAttributeName sets the AttributeName field's value.
func (s *GetUserAttributeVerificationCodeInput) SetAttributeName(v string) *GetUserAttributeVerificationCodeInput {
	s.AttributeName = &v
	return s
}

// The verification code response returned by the server response to get the
// user attribute verification code.
type GetUserAttributeVerificationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to get the user attribute verification code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserAttributeVerificationCodeOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *GetUserAttributeVerificationCodeOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *GetUserAttributeVerificationCodeOutput {
	s.CodeDeliveryDetails = v
	return s
}

// Represents the request to get information about the user.
type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get information about
	// the user.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetUserInput) SetAccessToken(v string) *GetUserInput {
	s.AccessToken = &v
	return s
}

// Represents the response from the server from the request to get information
// about the user.
type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the options for MFA (e.g., email or phone number).
	MFAOptions []*MFAOptionType `type:"list"`

	// The user's preferred MFA setting.
	PreferredMfaSetting *string `type:"string"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The list of the user's MFA settings.
	UserMFASettingList []*string `type:"list"`

	// The user name of the user you wish to retrieve from the get user request.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *GetUserOutput) SetMFAOptions(v []*MFAOptionType) *GetUserOutput {
	s.MFAOptions = v
	return s
}

// SetPreferredMfaSetting sets the PreferredMfaSetting field's value.
func (s *GetUserOutput) SetPreferredMfaSetting(v string) *GetUserOutput {
	s.PreferredMfaSetting = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *GetUserOutput) SetUserAttributes(v []*AttributeType) *GetUserOutput {
	s.UserAttributes = v
	return s
}

// SetUserMFASettingList sets the UserMFASettingList field's value.
func (s *GetUserOutput) SetUserMFASettingList(v []*string) *GetUserOutput {
	s.UserMFASettingList = v
	return s
}

// SetUsername sets the Username field's value.
func (s *GetUserOutput) SetUsername(v string) *GetUserOutput {
	s.Username = &v
	return s
}

type GetUserPoolMfaConfigInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPoolMfaConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPoolMfaConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserPoolMfaConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserPoolMfaConfigInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetUserPoolMfaConfigInput) SetUserPoolId(v string) *GetUserPoolMfaConfigInput {
	s.UserPoolId = &v
	return s
}

type GetUserPoolMfaConfigOutput struct {
	_ struct{} `type:"structure"`

	// The multi-factor (MFA) configuration.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The SMS text message multi-factor (MFA) configuration.
	SmsMfaConfiguration *SmsMfaConfigType `type:"structure"`

	// The software token multi-factor (MFA) configuration.
	SoftwareTokenMfaConfiguration *SoftwareTokenMfaConfigType `type:"structure"`
}

// String returns the string representation
func (s GetUserPoolMfaConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPoolMfaConfigOutput) GoString() string {
	return s.String()
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetMfaConfiguration(v string) *GetUserPoolMfaConfigOutput {
	s.MfaConfiguration = &v
	return s
}

// SetSmsMfaConfiguration sets the SmsMfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetSmsMfaConfiguration(v *SmsMfaConfigType) *GetUserPoolMfaConfigOutput {
	s.SmsMfaConfiguration = v
	return s
}

// SetSoftwareTokenMfaConfiguration sets the SoftwareTokenMfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetSoftwareTokenMfaConfiguration(v *SoftwareTokenMfaConfigType) *GetUserPoolMfaConfigOutput {
	s.SoftwareTokenMfaConfiguration = v
	return s
}

// Represents the request to sign out all devices.
type GlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSignOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSignOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSignOutInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GlobalSignOutInput) SetAccessToken(v string) *GlobalSignOutInput {
	s.AccessToken = &v
	return s
}

// The response to the request to sign out all devices.
type GlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSignOutOutput) GoString() string {
	return s.String()
}

// The group type.
type GroupType struct {
	_ struct{} `type:"structure"`

	// The date the group was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A string containing the description of the group.
	Description *string `type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The date the group was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A nonnegative integer value that specifies the precedence of this group relative
	// to the other groups that a user can belong to in the user pool. If a user
	// belongs to two or more groups, it is the group with the highest precedence
	// whose role ARN will be used in the cognito:roles and cognito:preferred_role
	// claims in the user's tokens. Groups with higher Precedence values take precedence
	// over groups with lower Precedence values or with null Precedence values.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim
	// in tokens for users in each group. If the two groups have different role
	// ARNs, the cognito:preferred_role claim is not set in users' tokens.
	//
	// The default Precedence value is null.
	Precedence *int64 `type:"integer"`

	// The role ARN for the group.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupType) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GroupType) SetCreationDate(v time.Time) *GroupType {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GroupType) SetDescription(v string) *GroupType {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupType) SetGroupName(v string) *GroupType {
	s.GroupName = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GroupType) SetLastModifiedDate(v time.Time) *GroupType {
	s.LastModifiedDate = &v
	return s
}

// SetPrecedence sets the Precedence field's value.
func (s *GroupType) SetPrecedence(v int64) *GroupType {
	s.Precedence = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GroupType) SetRoleArn(v string) *GroupType {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GroupType) SetUserPoolId(v string) *GroupType {
	s.UserPoolId = &v
	return s
}

// The HTTP header.
type HttpHeader struct {
	_ struct{} `type:"structure"`

	// The header name
	HeaderName *string `locationName:"headerName" type:"string"`

	// The header value.
	HeaderValue *string `locationName:"headerValue" type:"string"`
}

// String returns the string representation
func (s HttpHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpHeader) GoString() string {
	return s.String()
}

// SetHeaderName sets the HeaderName field's value.
func (s *HttpHeader) SetHeaderName(v string) *HttpHeader {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *HttpHeader) SetHeaderValue(v string) *HttpHeader {
	s.HeaderValue = &v
	return s
}

// A container for information about an identity provider.
type IdentityProviderType struct {
	_ struct{} `type:"structure"`

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]*string `type:"map"`

	// The date the identity provider was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of identity provider identifiers.
	IdpIdentifiers []*string `type:"list"`

	// The date the identity provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identity provider details, such as MetadataURL and MetadataFile.
	ProviderDetails map[string]*string `type:"map"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType *string `type:"string" enum:"IdentityProviderTypeType"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IdentityProviderType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityProviderType) GoString() string {
	return s.String()
}

// SetAttributeMapping sets the AttributeMapping field's value.
func (s *IdentityProviderType) SetAttributeMapping(v map[string]*string) *IdentityProviderType {
	s.AttributeMapping = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *IdentityProviderType) SetCreationDate(v time.Time) *IdentityProviderType {
	s.CreationDate = &v
	return s
}

// SetIdpIdentifiers sets the IdpIdentifiers field's value.
func (s *IdentityProviderType) SetIdpIdentifiers(v []*string) *IdentityProviderType {
	s.IdpIdentifiers = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *IdentityProviderType) SetLastModifiedDate(v time.Time) *IdentityProviderType {
	s.LastModifiedDate = &v
	return s
}

// SetProviderDetails sets the ProviderDetails field's value.
func (s *IdentityProviderType) SetProviderDetails(v map[string]*string) *IdentityProviderType {
	s.ProviderDetails = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *IdentityProviderType) SetProviderName(v string) *IdentityProviderType {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *IdentityProviderType) SetProviderType(v string) *IdentityProviderType {
	s.ProviderType = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *IdentityProviderType) SetUserPoolId(v string) *IdentityProviderType {
	s.UserPoolId = &v
	return s
}

// Initiates the authentication request.
type InitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for InitiateAuth
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The authentication flow for this call to execute. The API action will depend
	// on this value. For example:
	//
	//    * REFRESH_TOKEN_AUTH will take in a valid refresh token and return new
	//    tokens.
	//
	//    * USER_SRP_AUTH will take in USERNAME and SRP_A and return the SRP variables
	//    to be used for next challenge execution.
	//
	//    * USER_PASSWORD_AUTH will take in USERNAME and PASSWORD and return the
	//    next challenge or tokens.
	//
	// Valid values include:
	//
	//    * USER_SRP_AUTH: Authentication flow for the Secure Remote Password (SRP)
	//    protocol.
	//
	//    * REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow for refreshing
	//    the access token and ID token by supplying a valid refresh token.
	//
	//    * CUSTOM_AUTH: Custom authentication flow.
	//
	//    * USER_PASSWORD_AUTH: Non-SRP authentication flow; USERNAME and PASSWORD
	//    are passed directly. If a user migration Lambda trigger is set, this flow
	//    will invoke the user migration Lambda if the USERNAME is not found in
	//    the user pool.
	//
	// ADMIN_NO_SRP_AUTH is not a valid value.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters. These are inputs corresponding to the AuthFlow
	// that you are invoking. The required values depend on the value of AuthFlow:
	//
	//    * For USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY
	//
	//    * For REFRESH_TOKEN_AUTH/REFRESH_TOKEN: REFRESH_TOKEN (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY
	//
	//    * For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app client is
	//    configured with client secret), DEVICE_KEY
	AuthParameters map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// This is a random key-value pair map which can contain any key and will be
	// passed to your PreAuthentication Lambda trigger as-is. It can be used to
	// implement additional validations around authentication.
	ClientMetadata map[string]*string `type:"map"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`
}

// String returns the string representation
func (s InitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *InitiateAuthInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *InitiateAuthInput {
	s.AnalyticsMetadata = v
	return s
}

// SetAuthFlow sets the AuthFlow field's value.
func (s *InitiateAuthInput) SetAuthFlow(v string) *InitiateAuthInput {
	s.AuthFlow = &v
	return s
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *InitiateAuthInput) SetAuthParameters(v map[string]*string) *InitiateAuthInput {
	s.AuthParameters = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *InitiateAuthInput) SetClientId(v string) *InitiateAuthInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *InitiateAuthInput) SetClientMetadata(v map[string]*string) *InitiateAuthInput {
	s.ClientMetadata = v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *InitiateAuthInput) SetUserContextData(v *UserContextDataType) *InitiateAuthInput {
	s.UserContextData = v
	return s
}

// Initiates the authentication response.
type InitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authentication response. This is only returned if the caller
	// does not need to pass another challenge. If the caller does need to pass
	// another challenge before it gets tokens, ChallengeName, ChallengeParameters,
	// and Session are returned.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge which you are responding to with this call. This
	// is returned to you in the AdminInitiateAuth response if you need to pass
	// another challenge.
	//
	// Valid values include the following. Note that all of these challenges require
	// USERNAME and SECRET_HASH (if applicable) in the parameters.
	//
	//    * SMS_MFA: Next challenge is to supply an SMS_MFA_CODE, delivered via
	//    SMS.
	//
	//    * PASSWORD_VERIFIER: Next challenge is to supply PASSWORD_CLAIM_SIGNATURE,
	//    PASSWORD_CLAIM_SECRET_BLOCK, and TIMESTAMP after the client-side SRP calculations.
	//
	//    * CUSTOM_CHALLENGE: This is returned if your custom authentication flow
	//    determines that the user should pass another challenge before tokens are
	//    issued.
	//
	//    * DEVICE_SRP_AUTH: If device tracking was enabled on your user pool and
	//    the previous challenges were passed, this challenge is returned so that
	//    Amazon Cognito can start tracking this device.
	//
	//    * DEVICE_PASSWORD_VERIFIER: Similar to PASSWORD_VERIFIER, but for devices
	//    only.
	//
	//    * NEW_PASSWORD_REQUIRED: For users which are required to change their
	//    passwords after successful first login. This challenge should be passed
	//    with NEW_PASSWORD and any other required attributes.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. These are returned to you in the InitiateAuth response
	// if you need to pass another challenge. The responses in this parameter should
	// be used to compute inputs to the next call (RespondToAuthChallenge).
	//
	// All challenges require USERNAME and SECRET_HASH (if applicable).
	ChallengeParameters map[string]*string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If the or API call determines that the caller needs to go
	// through another challenge, they return a session with other challenge parameters.
	// This session should be passed as it is to the next RespondToAuthChallenge
	// API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s InitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateAuthOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *InitiateAuthOutput) SetAuthenticationResult(v *AuthenticationResultType) *InitiateAuthOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *InitiateAuthOutput) SetChallengeName(v string) *InitiateAuthOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *InitiateAuthOutput) SetChallengeParameters(v map[string]*string) *InitiateAuthOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *InitiateAuthOutput) SetSession(v string) *InitiateAuthOutput {
	s.Session = &v
	return s
}

// Specifies the configuration for AWS Lambda triggers.
type LambdaConfigType struct {
	_ struct{} `type:"structure"`

	// Creates an authentication challenge.
	CreateAuthChallenge *string `min:"20" type:"string"`

	// A custom Message AWS Lambda trigger.
	CustomMessage *string `min:"20" type:"string"`

	// Defines the authentication challenge.
	DefineAuthChallenge *string `min:"20" type:"string"`

	// A post-authentication AWS Lambda trigger.
	PostAuthentication *string `min:"20" type:"string"`

	// A post-confirmation AWS Lambda trigger.
	PostConfirmation *string `min:"20" type:"string"`

	// A pre-authentication AWS Lambda trigger.
	PreAuthentication *string `min:"20" type:"string"`

	// A pre-registration AWS Lambda trigger.
	PreSignUp *string `min:"20" type:"string"`

	// A Lambda trigger that is invoked before token generation.
	PreTokenGeneration *string `min:"20" type:"string"`

	// The user migration Lambda config type.
	UserMigration *string `min:"20" type:"string"`

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string `min:"20" type:"string"`
}

// String returns the string representation
func (s LambdaConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaConfigType"}
	if s.CreateAuthChallenge != nil && len(*s.CreateAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CreateAuthChallenge", 20))
	}
	if s.CustomMessage != nil && len(*s.CustomMessage) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomMessage", 20))
	}
	if s.DefineAuthChallenge != nil && len(*s.DefineAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DefineAuthChallenge", 20))
	}
	if s.PostAuthentication != nil && len(*s.PostAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostAuthentication", 20))
	}
	if s.PostConfirmation != nil && len(*s.PostConfirmation) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostConfirmation", 20))
	}
	if s.PreAuthentication != nil && len(*s.PreAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreAuthentication", 20))
	}
	if s.PreSignUp != nil && len(*s.PreSignUp) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreSignUp", 20))
	}
	if s.PreTokenGeneration != nil && len(*s.PreTokenGeneration) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreTokenGeneration", 20))
	}
	if s.UserMigration != nil && len(*s.UserMigration) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserMigration", 20))
	}
	if s.VerifyAuthChallengeResponse != nil && len(*s.VerifyAuthChallengeResponse) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("VerifyAuthChallengeResponse", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateAuthChallenge sets the CreateAuthChallenge field's value.
func (s *LambdaConfigType) SetCreateAuthChallenge(v string) *LambdaConfigType {
	s.CreateAuthChallenge = &v
	return s
}

// SetCustomMessage sets the CustomMessage field's value.
func (s *LambdaConfigType) SetCustomMessage(v string) *LambdaConfigType {
	s.CustomMessage = &v
	return s
}

// SetDefineAuthChallenge sets the DefineAuthChallenge field's value.
func (s *LambdaConfigType) SetDefineAuthChallenge(v string) *LambdaConfigType {
	s.DefineAuthChallenge = &v
	return s
}

// SetPostAuthentication sets the PostAuthentication field's value.
func (s *LambdaConfigType) SetPostAuthentication(v string) *LambdaConfigType {
	s.PostAuthentication = &v
	return s
}

// SetPostConfirmation sets the PostConfirmation field's value.
func (s *LambdaConfigType) SetPostConfirmation(v string) *LambdaConfigType {
	s.PostConfirmation = &v
	return s
}

// SetPreAuthentication sets the PreAuthentication field's value.
func (s *LambdaConfigType) SetPreAuthentication(v string) *LambdaConfigType {
	s.PreAuthentication = &v
	return s
}

// SetPreSignUp sets the PreSignUp field's value.
func (s *LambdaConfigType) SetPreSignUp(v string) *LambdaConfigType {
	s.PreSignUp = &v
	return s
}

// SetPreTokenGeneration sets the PreTokenGeneration field's value.
func (s *LambdaConfigType) SetPreTokenGeneration(v string) *LambdaConfigType {
	s.PreTokenGeneration = &v
	return s
}

// SetUserMigration sets the UserMigration field's value.
func (s *LambdaConfigType) SetUserMigration(v string) *LambdaConfigType {
	s.UserMigration = &v
	return s
}

// SetVerifyAuthChallengeResponse sets the VerifyAuthChallengeResponse field's value.
func (s *LambdaConfigType) SetVerifyAuthChallengeResponse(v string) *LambdaConfigType {
	s.VerifyAuthChallengeResponse = &v
	return s
}

// Represents the request to list the devices.
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The access tokens for the request to list devices.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The limit of the device request.
	Limit *int64 `type:"integer"`

	// The pagination token for the list request.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ListDevicesInput) SetAccessToken(v string) *ListDevicesInput {
	s.AccessToken = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDevicesInput) SetLimit(v int64) *ListDevicesInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListDevicesInput) SetPaginationToken(v string) *ListDevicesInput {
	s.PaginationToken = &v
	return s
}

// Represents the response to list devices.
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices returned in the list devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token for the list device response.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceType) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListDevicesOutput) SetPaginationToken(v string) *ListDevicesOutput {
	s.PaginationToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The limit of the request to list groups.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGroupsInput) SetLimit(v int64) *ListGroupsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListGroupsInput) SetUserPoolId(v string) *ListGroupsInput {
	s.UserPoolId = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The group objects for the groups.
	Groups []*GroupType `type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*GroupType) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListIdentityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identity providers to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListIdentityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityProvidersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProvidersInput) SetMaxResults(v int64) *ListIdentityProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersInput) SetNextToken(v string) *ListIdentityProvidersInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListIdentityProvidersInput) SetUserPoolId(v string) *ListIdentityProvidersInput {
	s.UserPoolId = &v
	return s
}

type ListIdentityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// A list of identity provider objects.
	//
	// Providers is a required field
	Providers []*ProviderDescription `type:"list" required:"true"`
}

// String returns the string representation
func (s ListIdentityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityProvidersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersOutput) SetNextToken(v string) *ListIdentityProvidersOutput {
	s.NextToken = &v
	return s
}

// SetProviders sets the Providers field's value.
func (s *ListIdentityProvidersOutput) SetProviders(v []*ProviderDescription) *ListIdentityProvidersOutput {
	s.Providers = v
	return s
}

type ListResourceServersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of resource servers to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceServersInput) SetMaxResults(v int64) *ListResourceServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceServersInput) SetNextToken(v string) *ListResourceServersInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListResourceServersInput) SetUserPoolId(v string) *ListResourceServersInput {
	s.UserPoolId = &v
	return s
}

type ListResourceServersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The resource servers.
	//
	// ResourceServers is a required field
	ResourceServers []*ResourceServerType `type:"list" required:"true"`
}

// String returns the string representation
func (s ListResourceServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceServersOutput) SetNextToken(v string) *ListResourceServersOutput {
	s.NextToken = &v
	return s
}

// SetResourceServers sets the ResourceServers field's value.
func (s *ListResourceServersOutput) SetResourceServers(v []*ResourceServerType) *ListResourceServersOutput {
	s.ResourceServers = v
	return s
}

// Represents the request to list the user import jobs.
type ListUserImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of import jobs you want the request to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to ListUserImportJobs,
	// which can be used to return the next set of import jobs in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserImportJobsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserImportJobsInput) SetMaxResults(v int64) *ListUserImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUserImportJobsInput) SetPaginationToken(v string) *ListUserImportJobsInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUserImportJobsInput) SetUserPoolId(v string) *ListUserImportJobsInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to list the user import
// jobs.
type ListUserImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of user import jobs
	// in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user import jobs.
	UserImportJobs []*UserImportJobType `min:"1" type:"list"`
}

// String returns the string representation
func (s ListUserImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserImportJobsOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUserImportJobsOutput) SetPaginationToken(v string) *ListUserImportJobsOutput {
	s.PaginationToken = &v
	return s
}

// SetUserImportJobs sets the UserImportJobs field's value.
func (s *ListUserImportJobsOutput) SetUserImportJobs(v []*UserImportJobType) *ListUserImportJobsOutput {
	s.UserImportJobs = v
	return s
}

// Represents the request to list the user pool clients.
type ListUserPoolClientsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pool clients.
	MaxResults *int64 `min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to list user pool clients.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserPoolClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolClientsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolClientsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolClientsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserPoolClientsInput) SetMaxResults(v int64) *ListUserPoolClientsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolClientsInput) SetNextToken(v string) *ListUserPoolClientsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUserPoolClientsInput) SetUserPoolId(v string) *ListUserPoolClientsInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server that lists user pool clients.
type ListUserPoolClientsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool clients in the response that lists user pool clients.
	UserPoolClients []*UserPoolClientDescription `type:"list"`
}

// String returns the string representation
func (s ListUserPoolClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolClientsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolClientsOutput) SetNextToken(v string) *ListUserPoolClientsOutput {
	s.NextToken = &v
	return s
}

// SetUserPoolClients sets the UserPoolClients field's value.
func (s *ListUserPoolClientsOutput) SetUserPoolClients(v []*UserPoolClientDescription) *ListUserPoolClientsOutput {
	s.UserPoolClients = v
	return s
}

// Represents the request to list user pools.
type ListUserPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pools.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListUserPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserPoolsInput) SetMaxResults(v int64) *ListUserPoolsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolsInput) SetNextToken(v string) *ListUserPoolsInput {
	s.NextToken = &v
	return s
}

// Represents the response to list user pools.
type ListUserPoolsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pools from the response to list users.
	UserPools []*UserPoolDescriptionType `type:"list"`
}

// String returns the string representation
func (s ListUserPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolsOutput) SetNextToken(v string) *ListUserPoolsOutput {
	s.NextToken = &v
	return s
}

// SetUserPools sets the UserPools field's value.
func (s *ListUserPoolsOutput) SetUserPools(v []*UserPoolDescriptionType) *ListUserPoolsOutput {
	s.UserPools = v
	return s
}

type ListUsersInGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The limit of the request to list users.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *ListUsersInGroupInput) SetGroupName(v string) *ListUsersInGroupInput {
	s.GroupName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListUsersInGroupInput) SetLimit(v int64) *ListUsersInGroupInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInGroupInput) SetNextToken(v string) *ListUsersInGroupInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUsersInGroupInput) SetUserPoolId(v string) *ListUsersInGroupInput {
	s.UserPoolId = &v
	return s
}

type ListUsersInGroupOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The users returned in the request to list users.
	Users []*UserType `type:"list"`
}

// String returns the string representation
func (s ListUsersInGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInGroupOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInGroupOutput) SetNextToken(v string) *ListUsersInGroupOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersInGroupOutput) SetUsers(v []*UserType) *ListUsersInGroupOutput {
	s.Users = v
	return s
}

// Represents the request to list users.
type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// An array of strings, where each string is the name of a user attribute to
	// be returned for each user in the search results. If the array is null, all
	// attributes are returned.
	AttributesToGet []*string `type:"list"`

	// A filter string of the form "AttributeNameFilter-Type "AttributeValue"".
	// Quotation marks within the filter string must be escaped using the backslash
	// (\) character. For example, "family_name = \"Reddy\"".
	//
	//    * AttributeName: The name of the attribute to search for. You can only
	//    search for one attribute at a time.
	//
	//    * Filter-Type: For an exact match, use =, for example, "given_name = \"Jon\"".
	//    For a prefix ("starts with") match, use ^=, for example, "given_name ^=
	//    \"Jon\"".
	//
	//    * AttributeValue: The attribute value that must be matched for each user.
	//
	// If the filter string is empty, ListUsers returns all users in the user pool.
	//
	// You can only search for the following standard attributes:
	//
	//    * username (case-sensitive)
	//
	//    * email
	//
	//    * phone_number
	//
	//    * name
	//
	//    * given_name
	//
	//    * family_name
	//
	//    * preferred_username
	//
	//    * cognito:user_status (called Enabled in the Console) (case-sensitive)
	//
	//    * status (case-insensitive)
	//
	//    * sub
	//
	// Custom attributes are not searchable.
	//
	// For more information, see Searching for Users Using the ListUsers API (http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api)
	// and Examples of Using the ListUsers API (http://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples)
	// in the Amazon Cognito Developer Guide.
	Filter *string `type:"string"`

	// Maximum number of users to be returned.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool on which the search should be performed.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *ListUsersInput) SetAttributesToGet(v []*string) *ListUsersInput {
	s.AttributesToGet = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListUsersInput) SetFilter(v string) *ListUsersInput {
	s.Filter = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListUsersInput) SetLimit(v int64) *ListUsersInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUsersInput) SetPaginationToken(v string) *ListUsersInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUsersInput) SetUserPoolId(v string) *ListUsersInput {
	s.UserPoolId = &v
	return s
}

// The response from the request to list users.
type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The users returned in the request to list users.
	Users []*UserType `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUsersOutput) SetPaginationToken(v string) *ListUsersOutput {
	s.PaginationToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*UserType) *ListUsersOutput {
	s.Users = v
	return s
}

// Specifies the different settings for multi-factor authentication (MFA).
type MFAOptionType struct {
	_ struct{} `type:"structure"`

	// The attribute name of the MFA option type.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or SMS message) to send the MFA code.
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`
}

// String returns the string representation
func (s MFAOptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MFAOptionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MFAOptionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MFAOptionType"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *MFAOptionType) SetAttributeName(v string) *MFAOptionType {
	s.AttributeName = &v
	return s
}

// SetDeliveryMedium sets the DeliveryMedium field's value.
func (s *MFAOptionType) SetDeliveryMedium(v string) *MFAOptionType {
	s.DeliveryMedium = &v
	return s
}

// The message template structure.
type MessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The message template for email messages.
	EmailMessage *string `min:"6" type:"string"`

	// The subject line for email messages.
	EmailSubject *string `min:"1" type:"string"`

	// The message template for SMS messages.
	SMSMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s MessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTemplateType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTemplateType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.SMSMessage != nil && len(*s.SMSMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SMSMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *MessageTemplateType) SetEmailMessage(v string) *MessageTemplateType {
	s.EmailMessage = &v
	return s
}

// SetEmailSubject sets the EmailSubject field's value.
func (s *MessageTemplateType) SetEmailSubject(v string) *MessageTemplateType {
	s.EmailSubject = &v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *MessageTemplateType) SetSMSMessage(v string) *MessageTemplateType {
	s.SMSMessage = &v
	return s
}

// The new device metadata type.
type NewDeviceMetadataType struct {
	_ struct{} `type:"structure"`

	// The device group key.
	DeviceGroupKey *string `type:"string"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NewDeviceMetadataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewDeviceMetadataType) GoString() string {
	return s.String()
}

// SetDeviceGroupKey sets the DeviceGroupKey field's value.
func (s *NewDeviceMetadataType) SetDeviceGroupKey(v string) *NewDeviceMetadataType {
	s.DeviceGroupKey = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *NewDeviceMetadataType) SetDeviceKey(v string) *NewDeviceMetadataType {
	s.DeviceKey = &v
	return s
}

// The notify configuration type.
type NotifyConfigurationType struct {
	_ struct{} `type:"structure"`

	// Email template used when a detected risk event is blocked.
	BlockEmail *NotifyEmailType `type:"structure"`

	// The email address that is sending the email. It must be either individually
	// verified with Amazon SES, or from a domain that has been verified with Amazon
	// SES.
	From *string `type:"string"`

	// The MFA email template used when MFA is challenged as part of a detected
	// risk.
	MfaEmail *NotifyEmailType `type:"structure"`

	// The email template used when a detected risk event is allowed.
	NoActionEmail *NotifyEmailType `type:"structure"`

	// The destination to which the receiver of an email should reply to.
	ReplyTo *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. It permits Amazon Cognito to send for the email
	// address specified in the From parameter.
	//
	// SourceArn is a required field
	SourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s NotifyConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyConfigurationType"}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}
	if s.BlockEmail != nil {
		if err := s.BlockEmail.Validate(); err != nil {
			invalidParams.AddNested("BlockEmail", err.(request.ErrInvalidParams))
		}
	}
	if s.MfaEmail != nil {
		if err := s.MfaEmail.Validate(); err != nil {
			invalidParams.AddNested("MfaEmail", err.(request.ErrInvalidParams))
		}
	}
	if s.NoActionEmail != nil {
		if err := s.NoActionEmail.Validate(); err != nil {
			invalidParams.AddNested("NoActionEmail", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockEmail sets the BlockEmail field's value.
func (s *NotifyConfigurationType) SetBlockEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.BlockEmail = v
	return s
}

// SetFrom sets the From field's value.
func (s *NotifyConfigurationType) SetFrom(v string) *NotifyConfigurationType {
	s.From = &v
	return s
}

// SetMfaEmail sets the MfaEmail field's value.
func (s *NotifyConfigurationType) SetMfaEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.MfaEmail = v
	return s
}

// SetNoActionEmail sets the NoActionEmail field's value.
func (s *NotifyConfigurationType) SetNoActionEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.NoActionEmail = v
	return s
}

// SetReplyTo sets the ReplyTo field's value.
func (s *NotifyConfigurationType) SetReplyTo(v string) *NotifyConfigurationType {
	s.ReplyTo = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *NotifyConfigurationType) SetSourceArn(v string) *NotifyConfigurationType {
	s.SourceArn = &v
	return s
}

// The notify email type.
type NotifyEmailType struct {
	_ struct{} `type:"structure"`

	// The HTML body.
	HtmlBody *string `min:"6" type:"string"`

	// The subject.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`

	// The text body.
	TextBody *string `min:"6" type:"string"`
}

// String returns the string representation
func (s NotifyEmailType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyEmailType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyEmailType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyEmailType"}
	if s.HtmlBody != nil && len(*s.HtmlBody) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("HtmlBody", 6))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Subject != nil && len(*s.Subject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subject", 1))
	}
	if s.TextBody != nil && len(*s.TextBody) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("TextBody", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtmlBody sets the HtmlBody field's value.
func (s *NotifyEmailType) SetHtmlBody(v string) *NotifyEmailType {
	s.HtmlBody = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *NotifyEmailType) SetSubject(v string) *NotifyEmailType {
	s.Subject = &v
	return s
}

// SetTextBody sets the TextBody field's value.
func (s *NotifyEmailType) SetTextBody(v string) *NotifyEmailType {
	s.TextBody = &v
	return s
}

// The minimum and maximum value of an attribute that is of the number data
// type.
type NumberAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string `type:"string"`

	// The minimum value of an attribute that is of the number data type.
	MinValue *string `type:"string"`
}

// String returns the string representation
func (s NumberAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberAttributeConstraintsType) GoString() string {
	return s.String()
}

// SetMaxValue sets the MaxValue field's value.
func (s *NumberAttributeConstraintsType) SetMaxValue(v string) *NumberAttributeConstraintsType {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *NumberAttributeConstraintsType) SetMinValue(v string) *NumberAttributeConstraintsType {
	s.MinValue = &v
	return s
}

// The password policy type.
type PasswordPolicyType struct {
	_ struct{} `type:"structure"`

	// The minimum length of the password policy that you have set. Cannot be less
	// than 6.
	MinimumLength *int64 `min:"6" type:"integer"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase *bool `type:"boolean"`
}

// String returns the string representation
func (s PasswordPolicyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordPolicyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PasswordPolicyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PasswordPolicyType"}
	if s.MinimumLength != nil && *s.MinimumLength < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumLength", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinimumLength sets the MinimumLength field's value.
func (s *PasswordPolicyType) SetMinimumLength(v int64) *PasswordPolicyType {
	s.MinimumLength = &v
	return s
}

// SetRequireLowercase sets the RequireLowercase field's value.
func (s *PasswordPolicyType) SetRequireLowercase(v bool) *PasswordPolicyType {
	s.RequireLowercase = &v
	return s
}

// SetRequireNumbers sets the RequireNumbers field's value.
func (s *PasswordPolicyType) SetRequireNumbers(v bool) *PasswordPolicyType {
	s.RequireNumbers = &v
	return s
}

// SetRequireSymbols sets the RequireSymbols field's value.
func (s *PasswordPolicyType) SetRequireSymbols(v bool) *PasswordPolicyType {
	s.RequireSymbols = &v
	return s
}

// SetRequireUppercase sets the RequireUppercase field's value.
func (s *PasswordPolicyType) SetRequireUppercase(v bool) *PasswordPolicyType {
	s.RequireUppercase = &v
	return s
}

// A container for identity provider details.
type ProviderDescription struct {
	_ struct{} `type:"structure"`

	// The date the provider was added to the user pool.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date the provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType *string `type:"string" enum:"IdentityProviderTypeType"`
}

// String returns the string representation
func (s ProviderDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProviderDescription) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ProviderDescription) SetCreationDate(v time.Time) *ProviderDescription {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ProviderDescription) SetLastModifiedDate(v time.Time) *ProviderDescription {
	s.LastModifiedDate = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *ProviderDescription) SetProviderName(v string) *ProviderDescription {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *ProviderDescription) SetProviderType(v string) *ProviderDescription {
	s.ProviderType = &v
	return s
}

// A container for information about an identity provider for a user pool.
type ProviderUserIdentifierType struct {
	_ struct{} `type:"structure"`

	// The name of the provider attribute to link to, for example, NameID.
	ProviderAttributeName *string `type:"string"`

	// The value of the provider attribute to link to, for example, xxxxx_account.
	ProviderAttributeValue *string `type:"string"`

	// The name of the provider, for example, Facebook, Google, or Login with Amazon.
	ProviderName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ProviderUserIdentifierType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProviderUserIdentifierType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProviderUserIdentifierType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProviderUserIdentifierType"}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderAttributeName sets the ProviderAttributeName field's value.
func (s *ProviderUserIdentifierType) SetProviderAttributeName(v string) *ProviderUserIdentifierType {
	s.ProviderAttributeName = &v
	return s
}

// SetProviderAttributeValue sets the ProviderAttributeValue field's value.
func (s *ProviderUserIdentifierType) SetProviderAttributeValue(v string) *ProviderUserIdentifierType {
	s.ProviderAttributeValue = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *ProviderUserIdentifierType) SetProviderName(v string) *ProviderUserIdentifierType {
	s.ProviderName = &v
	return s
}

// Represents the request to resend the confirmation code.
type ResendConfirmationCodeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ResendConfirmationCode
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user to whom you wish to resend a confirmation code.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResendConfirmationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendConfirmationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResendConfirmationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResendConfirmationCodeInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ResendConfirmationCodeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ResendConfirmationCodeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ResendConfirmationCodeInput) SetClientId(v string) *ResendConfirmationCodeInput {
	s.ClientId = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ResendConfirmationCodeInput) SetSecretHash(v string) *ResendConfirmationCodeInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ResendConfirmationCodeInput) SetUserContextData(v *UserContextDataType) *ResendConfirmationCodeInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ResendConfirmationCodeInput) SetUsername(v string) *ResendConfirmationCodeInput {
	s.Username = &v
	return s
}

// The response from the server when the Amazon Cognito Your User Pools service
// makes the request to resend a confirmation code.
type ResendConfirmationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to resend the confirmation code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s ResendConfirmationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendConfirmationCodeOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *ResendConfirmationCodeOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *ResendConfirmationCodeOutput {
	s.CodeDeliveryDetails = v
	return s
}

// A resource server scope.
type ResourceServerScopeType struct {
	_ struct{} `type:"structure"`

	// A description of the scope.
	//
	// ScopeDescription is a required field
	ScopeDescription *string `min:"1" type:"string" required:"true"`

	// The name of the scope.
	//
	// ScopeName is a required field
	ScopeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceServerScopeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceServerScopeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceServerScopeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceServerScopeType"}
	if s.ScopeDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeDescription"))
	}
	if s.ScopeDescription != nil && len(*s.ScopeDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScopeDescription", 1))
	}
	if s.ScopeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeName"))
	}
	if s.ScopeName != nil && len(*s.ScopeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScopeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScopeDescription sets the ScopeDescription field's value.
func (s *ResourceServerScopeType) SetScopeDescription(v string) *ResourceServerScopeType {
	s.ScopeDescription = &v
	return s
}

// SetScopeName sets the ScopeName field's value.
func (s *ResourceServerScopeType) SetScopeName(v string) *ResourceServerScopeType {
	s.ScopeName = &v
	return s
}

// A container for information about a resource server for a user pool.
type ResourceServerType struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	Identifier *string `min:"1" type:"string"`

	// The name of the resource server.
	Name *string `min:"1" type:"string"`

	// A list of scopes that are defined for the resource server.
	Scopes []*ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool that hosts the resource server.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceServerType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceServerType) GoString() string {
	return s.String()
}

// SetIdentifier sets the Identifier field's value.
func (s *ResourceServerType) SetIdentifier(v string) *ResourceServerType {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceServerType) SetName(v string) *ResourceServerType {
	s.Name = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *ResourceServerType) SetScopes(v []*ResourceServerScopeType) *ResourceServerType {
	s.Scopes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ResourceServerType) SetUserPoolId(v string) *ResourceServerType {
	s.UserPoolId = &v
	return s
}

// The request to respond to an authentication challenge.
type RespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for RespondToAuthChallenge
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The challenge name. For more information, see .
	//
	// ADMIN_NO_SRP_AUTH is not a valid value.
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The challenge responses. These are inputs corresponding to the value of ChallengeName,
	// for example:
	//
	//    * SMS_MFA: SMS_MFA_CODE, USERNAME, SECRET_HASH (if app client is configured
	//    with client secret).
	//
	//    * PASSWORD_VERIFIER: PASSWORD_CLAIM_SIGNATURE, PASSWORD_CLAIM_SECRET_BLOCK,
	//    TIMESTAMP, USERNAME, SECRET_HASH (if app client is configured with client
	//    secret).
	//
	//    * NEW_PASSWORD_REQUIRED: NEW_PASSWORD, any other required attributes,
	//    USERNAME, SECRET_HASH (if app client is configured with client secret).
	ChallengeResponses map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If InitiateAuth or RespondToAuthChallenge API call determines
	// that the caller needs to go through another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`
}

// String returns the string representation
func (s RespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *RespondToAuthChallengeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *RespondToAuthChallengeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *RespondToAuthChallengeInput) SetChallengeName(v string) *RespondToAuthChallengeInput {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *RespondToAuthChallengeInput) SetChallengeResponses(v map[string]*string) *RespondToAuthChallengeInput {
	s.ChallengeResponses = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RespondToAuthChallengeInput) SetClientId(v string) *RespondToAuthChallengeInput {
	s.ClientId = &v
	return s
}

// SetSession sets the Session field's value.
func (s *RespondToAuthChallengeInput) SetSession(v string) *RespondToAuthChallengeInput {
	s.Session = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *RespondToAuthChallengeInput) SetUserContextData(v *UserContextDataType) *RespondToAuthChallengeInput {
	s.UserContextData = v
	return s
}

// The response to respond to the authentication challenge.
type RespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the server in response to the request to respond to
	// the authentication challenge.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The challenge name. For more information, see .
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. For more information, see .
	ChallengeParameters map[string]*string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If the or API call determines that the caller needs to go
	// through another challenge, they return a session with other challenge parameters.
	// This session should be passed as it is to the next RespondToAuthChallenge
	// API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *RespondToAuthChallengeOutput) SetAuthenticationResult(v *AuthenticationResultType) *RespondToAuthChallengeOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *RespondToAuthChallengeOutput) SetChallengeName(v string) *RespondToAuthChallengeOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *RespondToAuthChallengeOutput) SetChallengeParameters(v map[string]*string) *RespondToAuthChallengeOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *RespondToAuthChallengeOutput) SetSession(v string) *RespondToAuthChallengeOutput {
	s.Session = &v
	return s
}

// The risk configuration type.
type RiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The account takeover risk configuration object including the NotifyConfiguration
	// object and Actions to take in the case of an account takeover.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType `type:"structure"`

	// The app client ID.
	ClientId *string `min:"1" type:"string"`

	// The compromised credentials risk configuration object including the EventFilter
	// and the EventAction
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType `type:"structure"`

	// The last modified date.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType `type:"structure"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RiskConfigurationType) GoString() string {
	return s.String()
}

// SetAccountTakeoverRiskConfiguration sets the AccountTakeoverRiskConfiguration field's value.
func (s *RiskConfigurationType) SetAccountTakeoverRiskConfiguration(v *AccountTakeoverRiskConfigurationType) *RiskConfigurationType {
	s.AccountTakeoverRiskConfiguration = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RiskConfigurationType) SetClientId(v string) *RiskConfigurationType {
	s.ClientId = &v
	return s
}

// SetCompromisedCredentialsRiskConfiguration sets the CompromisedCredentialsRiskConfiguration field's value.
func (s *RiskConfigurationType) SetCompromisedCredentialsRiskConfiguration(v *CompromisedCredentialsRiskConfigurationType) *RiskConfigurationType {
	s.CompromisedCredentialsRiskConfiguration = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RiskConfigurationType) SetLastModifiedDate(v time.Time) *RiskConfigurationType {
	s.LastModifiedDate = &v
	return s
}

// SetRiskExceptionConfiguration sets the RiskExceptionConfiguration field's value.
func (s *RiskConfigurationType) SetRiskExceptionConfiguration(v *RiskExceptionConfigurationType) *RiskConfigurationType {
	s.RiskExceptionConfiguration = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *RiskConfigurationType) SetUserPoolId(v string) *RiskConfigurationType {
	s.UserPoolId = &v
	return s
}

// The type of the configuration to override the risk decision.
type RiskExceptionConfigurationType struct {
	_ struct{} `type:"structure"`

	// Overrides the risk decision to always block the pre-authentication requests.
	// The IP range is in CIDR notation: a compact representation of an IP address
	// and its associated routing prefix.
	BlockedIPRangeList []*string `type:"list"`

	// Risk detection is not performed on the IP addresses in the range list. The
	// IP range is in CIDR notation.
	SkippedIPRangeList []*string `type:"list"`
}

// String returns the string representation
func (s RiskExceptionConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RiskExceptionConfigurationType) GoString() string {
	return s.String()
}

// SetBlockedIPRangeList sets the BlockedIPRangeList field's value.
func (s *RiskExceptionConfigurationType) SetBlockedIPRangeList(v []*string) *RiskExceptionConfigurationType {
	s.BlockedIPRangeList = v
	return s
}

// SetSkippedIPRangeList sets the SkippedIPRangeList field's value.
func (s *RiskExceptionConfigurationType) SetSkippedIPRangeList(v []*string) *RiskExceptionConfigurationType {
	s.SkippedIPRangeList = v
	return s
}

// The SMS multi-factor authentication (MFA) settings type.
type SMSMfaSettingsType struct {
	_ struct{} `type:"structure"`

	// Specifies whether SMS text message MFA is enabled.
	Enabled *bool `type:"boolean"`

	// The preferred MFA method.
	PreferredMfa *bool `type:"boolean"`
}

// String returns the string representation
func (s SMSMfaSettingsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSMfaSettingsType) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SMSMfaSettingsType) SetEnabled(v bool) *SMSMfaSettingsType {
	s.Enabled = &v
	return s
}

// SetPreferredMfa sets the PreferredMfa field's value.
func (s *SMSMfaSettingsType) SetPreferredMfa(v bool) *SMSMfaSettingsType {
	s.PreferredMfa = &v
	return s
}

// Contains information about the schema attribute.
type SchemaAttributeType struct {
	_ struct{} `type:"structure"`

	// The attribute data type.
	AttributeDataType *string `type:"string" enum:"AttributeDataType"`

	// Specifies whether the attribute type is developer only.
	DeveloperOnlyAttribute *bool `type:"boolean"`

	// Specifies whether the attribute can be changed once it has been created.
	Mutable *bool `type:"boolean"`

	// A schema attribute of the name type.
	Name *string `min:"1" type:"string"`

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType `type:"structure"`

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user does not provide a value, registration or sign-in will
	// fail.
	Required *bool `type:"boolean"`

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType `type:"structure"`
}

// String returns the string representation
func (s SchemaAttributeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaAttributeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAttributeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaAttributeType"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDataType sets the AttributeDataType field's value.
func (s *SchemaAttributeType) SetAttributeDataType(v string) *SchemaAttributeType {
	s.AttributeDataType = &v
	return s
}

// SetDeveloperOnlyAttribute sets the DeveloperOnlyAttribute field's value.
func (s *SchemaAttributeType) SetDeveloperOnlyAttribute(v bool) *SchemaAttributeType {
	s.DeveloperOnlyAttribute = &v
	return s
}

// SetMutable sets the Mutable field's value.
func (s *SchemaAttributeType) SetMutable(v bool) *SchemaAttributeType {
	s.Mutable = &v
	return s
}

// SetName sets the Name field's value.
func (s *SchemaAttributeType) SetName(v string) *SchemaAttributeType {
	s.Name = &v
	return s
}

// SetNumberAttributeConstraints sets the NumberAttributeConstraints field's value.
func (s *SchemaAttributeType) SetNumberAttributeConstraints(v *NumberAttributeConstraintsType) *SchemaAttributeType {
	s.NumberAttributeConstraints = v
	return s
}

// SetRequired sets the Required field's value.
func (s *SchemaAttributeType) SetRequired(v bool) *SchemaAttributeType {
	s.Required = &v
	return s
}

// SetStringAttributeConstraints sets the StringAttributeConstraints field's value.
func (s *SchemaAttributeType) SetStringAttributeConstraints(v *StringAttributeConstraintsType) *SchemaAttributeType {
	s.StringAttributeConstraints = v
	return s
}

type SetRiskConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The account takeover risk configuration.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType `type:"structure"`

	// The app client ID. If ClientId is null, then the risk configuration is mapped
	// to userPoolId. When the client ID is null, the same risk configuration is
	// applied to all the clients in the userPool.
	//
	// Otherwise, ClientId is mapped to the client. When the client ID is not null,
	// the user pool configuration is overridden and the risk configuration for
	// the client is used instead.
	ClientId *string `min:"1" type:"string"`

	// The compromised credentials risk configuration.
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType `type:"structure"`

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetRiskConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRiskConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRiskConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetRiskConfigurationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AccountTakeoverRiskConfiguration != nil {
		if err := s.AccountTakeoverRiskConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccountTakeoverRiskConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CompromisedCredentialsRiskConfiguration != nil {
		if err := s.CompromisedCredentialsRiskConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CompromisedCredentialsRiskConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountTakeoverRiskConfiguration sets the AccountTakeoverRiskConfiguration field's value.
func (s *SetRiskConfigurationInput) SetAccountTakeoverRiskConfiguration(v *AccountTakeoverRiskConfigurationType) *SetRiskConfigurationInput {
	s.AccountTakeoverRiskConfiguration = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *SetRiskConfigurationInput) SetClientId(v string) *SetRiskConfigurationInput {
	s.ClientId = &v
	return s
}

// SetCompromisedCredentialsRiskConfiguration sets the CompromisedCredentialsRiskConfiguration field's value.
func (s *SetRiskConfigurationInput) SetCompromisedCredentialsRiskConfiguration(v *CompromisedCredentialsRiskConfigurationType) *SetRiskConfigurationInput {
	s.CompromisedCredentialsRiskConfiguration = v
	return s
}

// SetRiskExceptionConfiguration sets the RiskExceptionConfiguration field's value.
func (s *SetRiskConfigurationInput) SetRiskExceptionConfiguration(v *RiskExceptionConfigurationType) *SetRiskConfigurationInput {
	s.RiskExceptionConfiguration = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *SetRiskConfigurationInput) SetUserPoolId(v string) *SetRiskConfigurationInput {
	s.UserPoolId = &v
	return s
}

type SetRiskConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The risk configuration.
	//
	// RiskConfiguration is a required field
	RiskConfiguration *RiskConfigurationType `type:"structure" required:"true"`
}

// String returns the string representation
func (s SetRiskConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRiskConfigurationOutput) GoString() string {
	return s.String()
}

// SetRiskConfiguration sets the RiskConfiguration field's value.
func (s *SetRiskConfigurationOutput) SetRiskConfiguration(v *RiskConfigurationType) *SetRiskConfigurationOutput {
	s.RiskConfiguration = v
	return s
}

type SetUICustomizationInput struct {
	_ struct{} `type:"structure"`

	// The CSS values in the UI customization.
	CSS *string `type:"string"`

	// The client ID for the client app.
	ClientId *string `min:"1" type:"string"`

	// The uploaded logo image for the UI customization.
	//
	// ImageFile is automatically base64 encoded/decoded by the SDK.
	ImageFile []byte `type:"blob"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetUICustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUICustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUICustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUICustomizationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCSS sets the CSS field's value.
func (s *SetUICustomizationInput) SetCSS(v string) *SetUICustomizationInput {
	s.CSS = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *SetUICustomizationInput) SetClientId(v string) *SetUICustomizationInput {
	s.ClientId = &v
	return s
}

// SetImageFile sets the ImageFile field's value.
func (s *SetUICustomizationInput) SetImageFile(v []byte) *SetUICustomizationInput {
	s.ImageFile = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *SetUICustomizationInput) SetUserPoolId(v string) *SetUICustomizationInput {
	s.UserPoolId = &v
	return s
}

type SetUICustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The UI customization information.
	//
	// UICustomization is a required field
	UICustomization *UICustomizationType `type:"structure" required:"true"`
}

// String returns the string representation
func (s SetUICustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUICustomizationOutput) GoString() string {
	return s.String()
}

// SetUICustomization sets the UICustomization field's value.
func (s *SetUICustomizationOutput) SetUICustomization(v *UICustomizationType) *SetUICustomizationOutput {
	s.UICustomization = v
	return s
}

type SetUserMFAPreferenceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The SMS text message multi-factor authentication (MFA) settings.
	SMSMfaSettings *SMSMfaSettingsType `type:"structure"`

	// The time-based one-time password software token MFA settings.
	SoftwareTokenMfaSettings *SoftwareTokenMfaSettingsType `type:"structure"`
}

// String returns the string representation
func (s SetUserMFAPreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserMFAPreferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserMFAPreferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUserMFAPreferenceInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *SetUserMFAPreferenceInput) SetAccessToken(v string) *SetUserMFAPreferenceInput {
	s.AccessToken = &v
	return s
}

// SetSMSMfaSettings sets the SMSMfaSettings field's value.
func (s *SetUserMFAPreferenceInput) SetSMSMfaSettings(v *SMSMfaSettingsType) *SetUserMFAPreferenceInput {
	s.SMSMfaSettings = v
	return s
}

// SetSoftwareTokenMfaSettings sets the SoftwareTokenMfaSettings field's value.
func (s *SetUserMFAPreferenceInput) SetSoftwareTokenMfaSettings(v *SoftwareTokenMfaSettingsType) *SetUserMFAPreferenceInput {
	s.SoftwareTokenMfaSettings = v
	return s
}

type SetUserMFAPreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetUserMFAPreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserMFAPreferenceOutput) GoString() string {
	return s.String()
}

type SetUserPoolMfaConfigInput struct {
	_ struct{} `type:"structure"`

	// The MFA configuration.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The SMS text message MFA configuration.
	SmsMfaConfiguration *SmsMfaConfigType `type:"structure"`

	// The software token MFA configuration.
	SoftwareTokenMfaConfiguration *SoftwareTokenMfaConfigType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetUserPoolMfaConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserPoolMfaConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserPoolMfaConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUserPoolMfaConfigInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.SmsMfaConfiguration != nil {
		if err := s.SmsMfaConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsMfaConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *SetUserPoolMfaConfigInput) SetMfaConfiguration(v string) *SetUserPoolMfaConfigInput {
	s.MfaConfiguration = &v
	return s
}

// SetSmsMfaConfiguration sets the SmsMfaConfiguration field's value.
func (s *SetUserPoolMfaConfigInput) SetSmsMfaConfiguration(v *SmsMfaConfigType) *SetUserPoolMfaConfigInput {
	s.SmsMfaConfiguration = v
	return s
}

// SetSoftwareTokenMfaConfiguration sets the SoftwareTokenMfaConfiguration field's value.
func (s *SetUserPoolMfaConfigInput) SetSoftwareTokenMfaConfiguration(v *SoftwareTokenMfaConfigType) *SetUserPoolMfaConfigInput {
	s.SoftwareTokenMfaConfiguration = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *SetUserPoolMfaConfigInput) SetUserPoolId(v string) *SetUserPoolMfaConfigInput {
	s.UserPoolId = &v
	return s
}

type SetUserPoolMfaConfigOutput struct {
	_ struct{} `type:"structure"`

	// The MFA configuration.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The SMS text message MFA configuration.
	SmsMfaConfiguration *SmsMfaConfigType `type:"structure"`

	// The software token MFA configuration.
	SoftwareTokenMfaConfiguration *SoftwareTokenMfaConfigType `type:"structure"`
}

// String returns the string representation
func (s SetUserPoolMfaConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserPoolMfaConfigOutput) GoString() string {
	return s.String()
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *SetUserPoolMfaConfigOutput) SetMfaConfiguration(v string) *SetUserPoolMfaConfigOutput {
	s.MfaConfiguration = &v
	return s
}

// SetSmsMfaConfiguration sets the SmsMfaConfiguration field's value.
func (s *SetUserPoolMfaConfigOutput) SetSmsMfaConfiguration(v *SmsMfaConfigType) *SetUserPoolMfaConfigOutput {
	s.SmsMfaConfiguration = v
	return s
}

// SetSoftwareTokenMfaConfiguration sets the SoftwareTokenMfaConfiguration field's value.
func (s *SetUserPoolMfaConfigOutput) SetSoftwareTokenMfaConfiguration(v *SoftwareTokenMfaConfigType) *SetUserPoolMfaConfigOutput {
	s.SoftwareTokenMfaConfiguration = v
	return s
}

// Represents the request to set user settings.
type SetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The access token for the set user settings request.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// Specifies the options for MFA (e.g., email or phone number).
	//
	// MFAOptions is a required field
	MFAOptions []*MFAOptionType `type:"list" required:"true"`
}

// String returns the string representation
func (s SetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUserSettingsInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.MFAOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAOptions"))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *SetUserSettingsInput) SetAccessToken(v string) *SetUserSettingsInput {
	s.AccessToken = &v
	return s
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *SetUserSettingsInput) SetMFAOptions(v []*MFAOptionType) *SetUserSettingsInput {
	s.MFAOptions = v
	return s
}

// The response from the server for a set user settings request.
type SetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserSettingsOutput) GoString() string {
	return s.String()
}

// Represents the request to register a user.
type SignUpInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for SignUp
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The password of the user you wish to register.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	UserAttributes []*AttributeType `type:"list"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user you wish to register.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`

	// The validation data in the request to register a user.
	ValidationData []*AttributeType `type:"list"`
}

// String returns the string representation
func (s SignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignUpInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValidationData != nil {
		for i, v := range s.ValidationData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *SignUpInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *SignUpInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *SignUpInput) SetClientId(v string) *SignUpInput {
	s.ClientId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *SignUpInput) SetPassword(v string) *SignUpInput {
	s.Password = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *SignUpInput) SetSecretHash(v string) *SignUpInput {
	s.SecretHash = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *SignUpInput) SetUserAttributes(v []*AttributeType) *SignUpInput {
	s.UserAttributes = v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *SignUpInput) SetUserContextData(v *UserContextDataType) *SignUpInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *SignUpInput) SetUsername(v string) *SignUpInput {
	s.Username = &v
	return s
}

// SetValidationData sets the ValidationData field's value.
func (s *SignUpInput) SetValidationData(v []*AttributeType) *SignUpInput {
	s.ValidationData = v
	return s
}

// The response from the server for a registration request.
type SignUpOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server response to the user registration
	// request.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`

	// A response from the server indicating that a user registration has been confirmed.
	//
	// UserConfirmed is a required field
	UserConfirmed *bool `type:"boolean" required:"true"`

	// The UUID of the authenticated user. This is not the same as username.
	//
	// UserSub is a required field
	UserSub *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignUpOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *SignUpOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *SignUpOutput {
	s.CodeDeliveryDetails = v
	return s
}

// SetUserConfirmed sets the UserConfirmed field's value.
func (s *SignUpOutput) SetUserConfirmed(v bool) *SignUpOutput {
	s.UserConfirmed = &v
	return s
}

// SetUserSub sets the UserSub field's value.
func (s *SignUpOutput) SetUserSub(v string) *SignUpOutput {
	s.UserSub = &v
	return s
}

// The SMS configuration type.
type SmsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The external ID.
	ExternalId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) caller.
	//
	// SnsCallerArn is a required field
	SnsCallerArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s SmsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmsConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SmsConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SmsConfigurationType"}
	if s.SnsCallerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsCallerArn"))
	}
	if s.SnsCallerArn != nil && len(*s.SnsCallerArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SnsCallerArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *SmsConfigurationType) SetExternalId(v string) *SmsConfigurationType {
	s.ExternalId = &v
	return s
}

// SetSnsCallerArn sets the SnsCallerArn field's value.
func (s *SmsConfigurationType) SetSnsCallerArn(v string) *SmsConfigurationType {
	s.SnsCallerArn = &v
	return s
}

// The SMS text message multi-factor authentication (MFA) configuration type.
type SmsMfaConfigType struct {
	_ struct{} `type:"structure"`

	// The SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`
}

// String returns the string representation
func (s SmsMfaConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmsMfaConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SmsMfaConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SmsMfaConfigType"}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSmsAuthenticationMessage sets the SmsAuthenticationMessage field's value.
func (s *SmsMfaConfigType) SetSmsAuthenticationMessage(v string) *SmsMfaConfigType {
	s.SmsAuthenticationMessage = &v
	return s
}

// SetSmsConfiguration sets the SmsConfiguration field's value.
func (s *SmsMfaConfigType) SetSmsConfiguration(v *SmsConfigurationType) *SmsMfaConfigType {
	s.SmsConfiguration = v
	return s
}

// The type used for enabling software token MFA at the user pool level.
type SoftwareTokenMfaConfigType struct {
	_ struct{} `type:"structure"`

	// Specifies whether software token MFA is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s SoftwareTokenMfaConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SoftwareTokenMfaConfigType) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SoftwareTokenMfaConfigType) SetEnabled(v bool) *SoftwareTokenMfaConfigType {
	s.Enabled = &v
	return s
}

// The type used for enabling software token MFA at the user level.
type SoftwareTokenMfaSettingsType struct {
	_ struct{} `type:"structure"`

	// Specifies whether software token MFA is enabled.
	Enabled *bool `type:"boolean"`

	// The preferred MFA method.
	PreferredMfa *bool `type:"boolean"`
}

// String returns the string representation
func (s SoftwareTokenMfaSettingsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SoftwareTokenMfaSettingsType) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SoftwareTokenMfaSettingsType) SetEnabled(v bool) *SoftwareTokenMfaSettingsType {
	s.Enabled = &v
	return s
}

// SetPreferredMfa sets the PreferredMfa field's value.
func (s *SoftwareTokenMfaSettingsType) SetPreferredMfa(v bool) *SoftwareTokenMfaSettingsType {
	s.PreferredMfa = &v
	return s
}

// Represents the request to start the user import job.
type StartUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StartUserImportJobInput) SetJobId(v string) *StartUserImportJobInput {
	s.JobId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *StartUserImportJobInput) SetUserPoolId(v string) *StartUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to start the user
// import job.
type StartUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s StartUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *StartUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *StartUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// Represents the request to stop the user import job.
type StopUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopUserImportJobInput) SetJobId(v string) *StopUserImportJobInput {
	s.JobId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *StopUserImportJobInput) SetUserPoolId(v string) *StopUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to stop the user import
// job.
type StopUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s StopUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *StopUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *StopUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// The constraints associated with a string attribute.
type StringAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum length.
	MaxLength *string `type:"string"`

	// The minimum length.
	MinLength *string `type:"string"`
}

// String returns the string representation
func (s StringAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringAttributeConstraintsType) GoString() string {
	return s.String()
}

// SetMaxLength sets the MaxLength field's value.
func (s *StringAttributeConstraintsType) SetMaxLength(v string) *StringAttributeConstraintsType {
	s.MaxLength = &v
	return s
}

// SetMinLength sets the MinLength field's value.
func (s *StringAttributeConstraintsType) SetMinLength(v string) *StringAttributeConstraintsType {
	s.MinLength = &v
	return s
}

// A container for the UI customization information for a user pool's built-in
// app UI.
type UICustomizationType struct {
	_ struct{} `type:"structure"`

	// The CSS values in the UI customization.
	CSS *string `type:"string"`

	// The CSS version number.
	CSSVersion *string `type:"string"`

	// The client ID for the client app.
	ClientId *string `min:"1" type:"string"`

	// The creation date for the UI customization.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The logo image for the UI customization.
	ImageUrl *string `type:"string"`

	// The last-modified date for the UI customization.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The user pool ID for the user pool.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UICustomizationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UICustomizationType) GoString() string {
	return s.String()
}

// SetCSS sets the CSS field's value.
func (s *UICustomizationType) SetCSS(v string) *UICustomizationType {
	s.CSS = &v
	return s
}

// SetCSSVersion sets the CSSVersion field's value.
func (s *UICustomizationType) SetCSSVersion(v string) *UICustomizationType {
	s.CSSVersion = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *UICustomizationType) SetClientId(v string) *UICustomizationType {
	s.ClientId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *UICustomizationType) SetCreationDate(v time.Time) *UICustomizationType {
	s.CreationDate = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *UICustomizationType) SetImageUrl(v string) *UICustomizationType {
	s.ImageUrl = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UICustomizationType) SetLastModifiedDate(v time.Time) *UICustomizationType {
	s.LastModifiedDate = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UICustomizationType) SetUserPoolId(v string) *UICustomizationType {
	s.UserPoolId = &v
	return s
}

type UpdateAuthEventFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The event ID.
	//
	// EventId is a required field
	EventId *string `min:"1" type:"string" required:"true"`

	// The feedback token.
	//
	// FeedbackToken is a required field
	FeedbackToken *string `type:"string" required:"true"`

	// The authentication event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue *string `type:"string" required:"true" enum:"FeedbackValueType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAuthEventFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuthEventFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAuthEventFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAuthEventFeedbackInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.FeedbackToken == nil {
		invalidParams.Add(request.NewErrParamRequired("FeedbackToken"))
	}
	if s.FeedbackValue == nil {
		invalidParams.Add(request.NewErrParamRequired("FeedbackValue"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *UpdateAuthEventFeedbackInput) SetEventId(v string) *UpdateAuthEventFeedbackInput {
	s.EventId = &v
	return s
}

// SetFeedbackToken sets the FeedbackToken field's value.
func (s *UpdateAuthEventFeedbackInput) SetFeedbackToken(v string) *UpdateAuthEventFeedbackInput {
	s.FeedbackToken = &v
	return s
}

// SetFeedbackValue sets the FeedbackValue field's value.
func (s *UpdateAuthEventFeedbackInput) SetFeedbackValue(v string) *UpdateAuthEventFeedbackInput {
	s.FeedbackValue = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateAuthEventFeedbackInput) SetUserPoolId(v string) *UpdateAuthEventFeedbackInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UpdateAuthEventFeedbackInput) SetUsername(v string) *UpdateAuthEventFeedbackInput {
	s.Username = &v
	return s
}

type UpdateAuthEventFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAuthEventFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuthEventFeedbackOutput) GoString() string {
	return s.String()
}

// Represents the request to update the device status.
type UpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status of whether a device is remembered.
	DeviceRememberedStatus *string `type:"string" enum:"DeviceRememberedStatusType"`
}

// String returns the string representation
func (s UpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceStatusInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *UpdateDeviceStatusInput) SetAccessToken(v string) *UpdateDeviceStatusInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *UpdateDeviceStatusInput) SetDeviceKey(v string) *UpdateDeviceStatusInput {
	s.DeviceKey = &v
	return s
}

// SetDeviceRememberedStatus sets the DeviceRememberedStatus field's value.
func (s *UpdateDeviceStatusInput) SetDeviceRememberedStatus(v string) *UpdateDeviceStatusInput {
	s.DeviceRememberedStatus = &v
	return s
}

// The response to the request to update the device status.
type UpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStatusOutput) GoString() string {
	return s.String()
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// A string containing the new description of the group.
	Description *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The new precedence value for the group. For more information about this parameter,
	// see .
	Precedence *int64 `type:"integer"`

	// The new role ARN for the group. This is used for setting the cognito:roles
	// and cognito:preferred_role claims in the token.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

// SetPrecedence sets the Precedence field's value.
func (s *UpdateGroupInput) SetPrecedence(v int64) *UpdateGroupInput {
	s.Precedence = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateGroupInput) SetRoleArn(v string) *UpdateGroupInput {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateGroupInput) SetUserPoolId(v string) *UpdateGroupInput {
	s.UserPoolId = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *GroupType) *UpdateGroupOutput {
	s.Group = v
	return s
}

type UpdateIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider attribute mapping to be changed.
	AttributeMapping map[string]*string `type:"map"`

	// A list of identity provider identifiers.
	IdpIdentifiers []*string `type:"list"`

	// The identity provider details to be updated, such as MetadataURL and MetadataFile.
	ProviderDetails map[string]*string `type:"map"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdentityProviderInput"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeMapping sets the AttributeMapping field's value.
func (s *UpdateIdentityProviderInput) SetAttributeMapping(v map[string]*string) *UpdateIdentityProviderInput {
	s.AttributeMapping = v
	return s
}

// SetIdpIdentifiers sets the IdpIdentifiers field's value.
func (s *UpdateIdentityProviderInput) SetIdpIdentifiers(v []*string) *UpdateIdentityProviderInput {
	s.IdpIdentifiers = v
	return s
}

// SetProviderDetails sets the ProviderDetails field's value.
func (s *UpdateIdentityProviderInput) SetProviderDetails(v map[string]*string) *UpdateIdentityProviderInput {
	s.ProviderDetails = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *UpdateIdentityProviderInput) SetProviderName(v string) *UpdateIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateIdentityProviderInput) SetUserPoolId(v string) *UpdateIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type UpdateIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *UpdateIdentityProviderOutput) SetIdentityProvider(v *IdentityProviderType) *UpdateIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type UpdateResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The name of the resource server.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The scope values to be set for the resource server.
	Scopes []*ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Scopes != nil {
		for i, v := range s.Scopes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Scopes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateResourceServerInput) SetIdentifier(v string) *UpdateResourceServerInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceServerInput) SetName(v string) *UpdateResourceServerInput {
	s.Name = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *UpdateResourceServerInput) SetScopes(v []*ResourceServerScopeType) *UpdateResourceServerInput {
	s.Scopes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateResourceServerInput) SetUserPoolId(v string) *UpdateResourceServerInput {
	s.UserPoolId = &v
	return s
}

type UpdateResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceServerOutput) GoString() string {
	return s.String()
}

// SetResourceServer sets the ResourceServer field's value.
func (s *UpdateResourceServerOutput) SetResourceServer(v *ResourceServerType) *UpdateResourceServerOutput {
	s.ResourceServer = v
	return s
}

// Represents the request to update user attributes.
type UpdateUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// The access token for the request to update user attributes.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserAttributesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.UserAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributes"))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *UpdateUserAttributesInput) SetAccessToken(v string) *UpdateUserAttributesInput {
	s.AccessToken = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *UpdateUserAttributesInput) SetUserAttributes(v []*AttributeType) *UpdateUserAttributesInput {
	s.UserAttributes = v
	return s
}

// Represents the response from the server for the request to update user attributes.
type UpdateUserAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details list from the server for the request to update
	// user attributes.
	CodeDeliveryDetailsList []*CodeDeliveryDetailsType `type:"list"`
}

// String returns the string representation
func (s UpdateUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserAttributesOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetailsList sets the CodeDeliveryDetailsList field's value.
func (s *UpdateUserAttributesOutput) SetCodeDeliveryDetailsList(v []*CodeDeliveryDetailsType) *UpdateUserAttributesOutput {
	s.CodeDeliveryDetailsList = v
	return s
}

// Represents the request to update the user pool client.
type UpdateUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// Set to code to initiate a code grant flow, which provides an authorization
	// code as the response. This code can be exchanged for access tokens with the
	// token endpoint.
	//
	// Set to token to specify that the client should get the access token (and,
	// optionally, ID token, based on scopes) directly.
	AllowedOAuthFlows []*string `type:"list"`

	// Set to TRUE if the client is allowed to follow the OAuth protocol when interacting
	// with Cognito user pools.
	AllowedOAuthFlowsUserPoolClient *bool `type:"boolean"`

	// A list of allowed OAuth scopes. Currently supported values are "phone", "email",
	// "openid", and "Cognito".
	AllowedOAuthScopes []*string `type:"list"`

	// The Amazon Pinpoint analytics configuration for collecting metrics for this
	// user pool.
	AnalyticsConfiguration *AnalyticsConfigurationType `type:"structure"`

	// A list of allowed callback URLs for the identity providers.
	CallbackURLs []*string `type:"list"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The client name from the update user pool client request.
	ClientName *string `min:"1" type:"string"`

	// The default redirect URI. Must be in the CallbackURLs list.
	DefaultRedirectURI *string `min:"1" type:"string"`

	// Explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []*string `type:"list"`

	// The read-only attributes of the user pool.
	ReadAttributes []*string `type:"list"`

	// The time limit, in days, after which the refresh token is no longer valid
	// and cannot be used.
	RefreshTokenValidity *int64 `type:"integer"`

	// A list of provider names for the identity providers that are supported on
	// this client.
	SupportedIdentityProviders []*string `type:"list"`

	// The user pool ID for the user pool where you want to update the user pool
	// client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The writeable attributes of the user pool.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s UpdateUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ClientName != nil && len(*s.ClientName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientName", 1))
	}
	if s.DefaultRedirectURI != nil && len(*s.DefaultRedirectURI) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultRedirectURI", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedOAuthFlows sets the AllowedOAuthFlows field's value.
func (s *UpdateUserPoolClientInput) SetAllowedOAuthFlows(v []*string) *UpdateUserPoolClientInput {
	s.AllowedOAuthFlows = v
	return s
}

// SetAllowedOAuthFlowsUserPoolClient sets the AllowedOAuthFlowsUserPoolClient field's value.
func (s *UpdateUserPoolClientInput) SetAllowedOAuthFlowsUserPoolClient(v bool) *UpdateUserPoolClientInput {
	s.AllowedOAuthFlowsUserPoolClient = &v
	return s
}

// SetAllowedOAuthScopes sets the AllowedOAuthScopes field's value.
func (s *UpdateUserPoolClientInput) SetAllowedOAuthScopes(v []*string) *UpdateUserPoolClientInput {
	s.AllowedOAuthScopes = v
	return s
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *UpdateUserPoolClientInput) SetAnalyticsConfiguration(v *AnalyticsConfigurationType) *UpdateUserPoolClientInput {
	s.AnalyticsConfiguration = v
	return s
}

// SetCallbackURLs sets the CallbackURLs field's value.
func (s *UpdateUserPoolClientInput) SetCallbackURLs(v []*string) *UpdateUserPoolClientInput {
	s.CallbackURLs = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *UpdateUserPoolClientInput) SetClientId(v string) *UpdateUserPoolClientInput {
	s.ClientId = &v
	return s
}

// SetClientName sets the ClientName field's value.
func (s *UpdateUserPoolClientInput) SetClientName(v string) *UpdateUserPoolClientInput {
	s.ClientName = &v
	return s
}

// SetDefaultRedirectURI sets the DefaultRedirectURI field's value.
func (s *UpdateUserPoolClientInput) SetDefaultRedirectURI(v string) *UpdateUserPoolClientInput {
	s.DefaultRedirectURI = &v
	return s
}

// SetExplicitAuthFlows sets the ExplicitAuthFlows field's value.
func (s *UpdateUserPoolClientInput) SetExplicitAuthFlows(v []*string) *UpdateUserPoolClientInput {
	s.ExplicitAuthFlows = v
	return s
}

// SetLogoutURLs sets the LogoutURLs field's value.
func (s *UpdateUserPoolClientInput) SetLogoutURLs(v []*string) *UpdateUserPoolClientInput {
	s.LogoutURLs = v
	return s
}

// SetReadAttributes sets the ReadAttributes field's value.
func (s *UpdateUserPoolClientInput) SetReadAttributes(v []*string) *UpdateUserPoolClientInput {
	s.ReadAttributes = v
	return s
}

// SetRefreshTokenValidity sets the RefreshTokenValidity field's value.
func (s *UpdateUserPoolClientInput) SetRefreshTokenValidity(v int64) *UpdateUserPoolClientInput {
	s.RefreshTokenValidity = &v
	return s
}

// SetSupportedIdentityProviders sets the SupportedIdentityProviders field's value.
func (s *UpdateUserPoolClientInput) SetSupportedIdentityProviders(v []*string) *UpdateUserPoolClientInput {
	s.SupportedIdentityProviders = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateUserPoolClientInput) SetUserPoolId(v string) *UpdateUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

// SetWriteAttributes sets the WriteAttributes field's value.
func (s *UpdateUserPoolClientInput) SetWriteAttributes(v []*string) *UpdateUserPoolClientInput {
	s.WriteAttributes = v
	return s
}

// Represents the response from the server to the request to update the user
// pool client.
type UpdateUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client value from the response from the server when an update
	// user pool client request is made.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolClientOutput) GoString() string {
	return s.String()
}

// SetUserPoolClient sets the UserPoolClient field's value.
func (s *UpdateUserPoolClientOutput) SetUserPoolClient(v *UserPoolClientType) *UpdateUserPoolClientOutput {
	s.UserPoolClient = v
	return s
}

// Represents the request to update the user pool.
type UpdateUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// The attributes that are automatically verified when the Amazon Cognito service
	// makes a request to update user pools.
	AutoVerifiedAttributes []*string `type:"list"`

	// Device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// Email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// The contents of the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// The subject of the email verification message.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// The AWS Lambda configuration information from the request to update the user
	// pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// Can be one of the following values:
	//
	//    * OFF - MFA tokens are not required and cannot be specified during user
	//    registration.
	//
	//    * ON - MFA tokens are required for all user registrations. You can only
	//    specify required when you are initially creating a user pool.
	//
	//    * OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// A container with the policies you wish to update in a user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// A container with information about the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// Used to enable advanced security risk detection. Set the key AdvancedSecurityMode
	// to the value "AUDIT".
	UserPoolAddOns *UserPoolAddOnsType `type:"structure"`

	// The user pool ID for the user pool you want to update.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The cost allocation tags for the user pool. For more information, see Adding
	// Cost Allocation Tags to Your User Pool (http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html)
	UserPoolTags map[string]*string `type:"map"`

	// The template for verification messages.
	VerificationMessageTemplate *VerificationMessageTemplateType `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPoolInput"}
	if s.EmailVerificationMessage != nil && len(*s.EmailVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationMessage", 6))
	}
	if s.EmailVerificationSubject != nil && len(*s.EmailVerificationSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationSubject", 1))
	}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsVerificationMessage != nil && len(*s.SmsVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsVerificationMessage", 6))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AdminCreateUserConfig != nil {
		if err := s.AdminCreateUserConfig.Validate(); err != nil {
			invalidParams.AddNested("AdminCreateUserConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailConfiguration != nil {
		if err := s.EmailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Policies != nil {
		if err := s.Policies.Validate(); err != nil {
			invalidParams.AddNested("Policies", err.(request.ErrInvalidParams))
		}
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolAddOns != nil {
		if err := s.UserPoolAddOns.Validate(); err != nil {
			invalidParams.AddNested("UserPoolAddOns", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationMessageTemplate != nil {
		if err := s.VerificationMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("VerificationMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminCreateUserConfig sets the AdminCreateUserConfig field's value.
func (s *UpdateUserPoolInput) SetAdminCreateUserConfig(v *AdminCreateUserConfigType) *UpdateUserPoolInput {
	s.AdminCreateUserConfig = v
	return s
}

// SetAutoVerifiedAttributes sets the AutoVerifiedAttributes field's value.
func (s *UpdateUserPoolInput) SetAutoVerifiedAttributes(v []*string) *UpdateUserPoolInput {
	s.AutoVerifiedAttributes = v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *UpdateUserPoolInput) SetDeviceConfiguration(v *DeviceConfigurationType) *UpdateUserPoolInput {
	s.DeviceConfiguration = v
	return s
}

// SetEmailConfiguration sets the EmailConfiguration field's value.
func (s *UpdateUserPoolInput) SetEmailConfiguration(v *EmailConfigurationType) *UpdateUserPoolInput {
	s.EmailConfiguration = v
	return s
}

// SetEmailVerificationMessage sets the EmailVerificationMessage field's value.
func (s *UpdateUserPoolInput) SetEmailVerificationMessage(v string) *UpdateUserPoolInput {
	s.EmailVerificationMessage = &v
	return s
}

// SetEmailVerificationSubject sets the EmailVerificationSubject field's value.
func (s *UpdateUserPoolInput) SetEmailVerificationSubject(v string) *UpdateUserPoolInput {
	s.EmailVerificationSubject = &v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *UpdateUserPoolInput) SetLambdaConfig(v *LambdaConfigType) *UpdateUserPoolInput {
	s.LambdaConfig = v
	return s
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *UpdateUserPoolInput) SetMfaConfiguration(v string) *UpdateUserPoolInput {
	s.MfaConfiguration = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *UpdateUserPoolInput) SetPolicies(v *UserPoolPolicyType) *UpdateUserPoolInput {
	s.Policies = v
	return s
}

// SetSmsAuthenticationMessage sets the SmsAuthenticationMessage field's value.
func (s *UpdateUserPoolInput) SetSmsAuthenticationMessage(v string) *UpdateUserPoolInput {
	s.SmsAuthenticationMessage = &v
	return s
}

// SetSmsConfiguration sets the SmsConfiguration field's value.
func (s *UpdateUserPoolInput) SetSmsConfiguration(v *SmsConfigurationType) *UpdateUserPoolInput {
	s.SmsConfiguration = v
	return s
}

// SetSmsVerificationMessage sets the SmsVerificationMessage field's value.
func (s *UpdateUserPoolInput) SetSmsVerificationMessage(v string) *UpdateUserPoolInput {
	s.SmsVerificationMessage = &v
	return s
}

// SetUserPoolAddOns sets the UserPoolAddOns field's value.
func (s *UpdateUserPoolInput) SetUserPoolAddOns(v *UserPoolAddOnsType) *UpdateUserPoolInput {
	s.UserPoolAddOns = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UpdateUserPoolInput) SetUserPoolId(v string) *UpdateUserPoolInput {
	s.UserPoolId = &v
	return s
}

// SetUserPoolTags sets the UserPoolTags field's value.
func (s *UpdateUserPoolInput) SetUserPoolTags(v map[string]*string) *UpdateUserPoolInput {
	s.UserPoolTags = v
	return s
}

// SetVerificationMessageTemplate sets the VerificationMessageTemplate field's value.
func (s *UpdateUserPoolInput) SetVerificationMessageTemplate(v *VerificationMessageTemplateType) *UpdateUserPoolInput {
	s.VerificationMessageTemplate = v
	return s
}

// Represents the response from the server when you make a request to update
// the user pool.
type UpdateUserPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolOutput) GoString() string {
	return s.String()
}

// Contextual data such as the user's device fingerprint, IP address, or location
// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
// security.
type UserContextDataType struct {
	_ struct{} `type:"structure"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	EncodedData *string `type:"string"`
}

// String returns the string representation
func (s UserContextDataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserContextDataType) GoString() string {
	return s.String()
}

// SetEncodedData sets the EncodedData field's value.
func (s *UserContextDataType) SetEncodedData(v string) *UserContextDataType {
	s.EncodedData = &v
	return s
}

// The user import job type.
type UserImportJobType struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	// For more information, see "Creating the CloudWatch Logs IAM Role" in the
	// Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string `min:"20" type:"string"`

	// The date when the user import job was completed.
	CompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The message returned when the user import job is completed.
	CompletionMessage *string `min:"1" type:"string"`

	// The date the user import job was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The number of users that could not be imported.
	FailedUsers *int64 `type:"long"`

	// The number of users that were successfully imported.
	ImportedUsers *int64 `type:"long"`

	// The job ID for the user import job.
	JobId *string `min:"1" type:"string"`

	// The job name for the user import job.
	JobName *string `min:"1" type:"string"`

	// The pre-signed URL to be used to upload the .csv file.
	PreSignedUrl *string `type:"string"`

	// The number of users that were skipped.
	SkippedUsers *int64 `type:"long"`

	// The date when the user import job was started.
	StartDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the user import job. One of the following:
	//
	//    * Created - The job was created but not started.
	//
	//    * Pending - A transition state. You have started the job, but it has not
	//    begun importing users yet.
	//
	//    * InProgress - The job has started, and users are being imported.
	//
	//    * Stopping - You have stopped the job, but the job has not stopped importing
	//    users yet.
	//
	//    * Stopped - You have stopped the job, and the job has stopped importing
	//    users.
	//
	//    * Succeeded - The job has completed successfully.
	//
	//    * Failed - The job has stopped due to an error.
	//
	//    * Expired - You created a job, but did not start the job within 24-48
	//    hours. All data associated with the job was deleted, and the job cannot
	//    be started.
	Status *string `type:"string" enum:"UserImportJobStatusType"`

	// The user pool ID for the user pool that the users are being imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserImportJobType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserImportJobType) GoString() string {
	return s.String()
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *UserImportJobType) SetCloudWatchLogsRoleArn(v string) *UserImportJobType {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *UserImportJobType) SetCompletionDate(v time.Time) *UserImportJobType {
	s.CompletionDate = &v
	return s
}

// SetCompletionMessage sets the CompletionMessage field's value.
func (s *UserImportJobType) SetCompletionMessage(v string) *UserImportJobType {
	s.CompletionMessage = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *UserImportJobType) SetCreationDate(v time.Time) *UserImportJobType {
	s.CreationDate = &v
	return s
}

// SetFailedUsers sets the FailedUsers field's value.
func (s *UserImportJobType) SetFailedUsers(v int64) *UserImportJobType {
	s.FailedUsers = &v
	return s
}

// SetImportedUsers sets the ImportedUsers field's value.
func (s *UserImportJobType) SetImportedUsers(v int64) *UserImportJobType {
	s.ImportedUsers = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UserImportJobType) SetJobId(v string) *UserImportJobType {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *UserImportJobType) SetJobName(v string) *UserImportJobType {
	s.JobName = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *UserImportJobType) SetPreSignedUrl(v string) *UserImportJobType {
	s.PreSignedUrl = &v
	return s
}

// SetSkippedUsers sets the SkippedUsers field's value.
func (s *UserImportJobType) SetSkippedUsers(v int64) *UserImportJobType {
	s.SkippedUsers = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *UserImportJobType) SetStartDate(v time.Time) *UserImportJobType {
	s.StartDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UserImportJobType) SetStatus(v string) *UserImportJobType {
	s.Status = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UserImportJobType) SetUserPoolId(v string) *UserImportJobType {
	s.UserPoolId = &v
	return s
}

// The user pool add-ons type.
type UserPoolAddOnsType struct {
	_ struct{} `type:"structure"`

	// The advanced security mode.
	//
	// AdvancedSecurityMode is a required field
	AdvancedSecurityMode *string `type:"string" required:"true" enum:"AdvancedSecurityModeType"`
}

// String returns the string representation
func (s UserPoolAddOnsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolAddOnsType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolAddOnsType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPoolAddOnsType"}
	if s.AdvancedSecurityMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AdvancedSecurityMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvancedSecurityMode sets the AdvancedSecurityMode field's value.
func (s *UserPoolAddOnsType) SetAdvancedSecurityMode(v string) *UserPoolAddOnsType {
	s.AdvancedSecurityMode = &v
	return s
}

// The description of the user pool client.
type UserPoolClientDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string"`

	// The client name from the user pool client description.
	ClientName *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to describe the user pool
	// client.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserPoolClientDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolClientDescription) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *UserPoolClientDescription) SetClientId(v string) *UserPoolClientDescription {
	s.ClientId = &v
	return s
}

// SetClientName sets the ClientName field's value.
func (s *UserPoolClientDescription) SetClientName(v string) *UserPoolClientDescription {
	s.ClientName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UserPoolClientDescription) SetUserPoolId(v string) *UserPoolClientDescription {
	s.UserPoolId = &v
	return s
}

// Contains information about a user pool client.
type UserPoolClientType struct {
	_ struct{} `type:"structure"`

	// Set to code to initiate a code grant flow, which provides an authorization
	// code as the response. This code can be exchanged for access tokens with the
	// token endpoint.
	//
	// Set to token to specify that the client should get the access token (and,
	// optionally, ID token, based on scopes) directly.
	AllowedOAuthFlows []*string `type:"list"`

	// Set to TRUE if the client is allowed to follow the OAuth protocol when interacting
	// with Cognito user pools.
	AllowedOAuthFlowsUserPoolClient *bool `type:"boolean"`

	// A list of allowed OAuth scopes. Currently supported values are "phone", "email",
	// "openid", and "Cognito".
	AllowedOAuthScopes []*string `type:"list"`

	// The Amazon Pinpoint analytics configuration for the user pool client.
	AnalyticsConfiguration *AnalyticsConfigurationType `type:"structure"`

	// A list of allowed callback URLs for the identity providers.
	CallbackURLs []*string `type:"list"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string"`

	// The client name from the user pool request of the client type.
	ClientName *string `min:"1" type:"string"`

	// The client secret from the user pool request of the client type.
	ClientSecret *string `min:"1" type:"string"`

	// The date the user pool client was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The default redirect URI. Must be in the CallbackURLs list.
	DefaultRedirectURI *string `min:"1" type:"string"`

	// The explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// The date the user pool client was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []*string `type:"list"`

	// The Read-only attributes.
	ReadAttributes []*string `type:"list"`

	// The time limit, in days, after which the refresh token is no longer valid
	// and cannot be used.
	RefreshTokenValidity *int64 `type:"integer"`

	// A list of provider names for the identity providers that are supported on
	// this client.
	SupportedIdentityProviders []*string `type:"list"`

	// The user pool ID for the user pool client.
	UserPoolId *string `min:"1" type:"string"`

	// The writeable attributes.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s UserPoolClientType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolClientType) GoString() string {
	return s.String()
}

// SetAllowedOAuthFlows sets the AllowedOAuthFlows field's value.
func (s *UserPoolClientType) SetAllowedOAuthFlows(v []*string) *UserPoolClientType {
	s.AllowedOAuthFlows = v
	return s
}

// SetAllowedOAuthFlowsUserPoolClient sets the AllowedOAuthFlowsUserPoolClient field's value.
func (s *UserPoolClientType) SetAllowedOAuthFlowsUserPoolClient(v bool) *UserPoolClientType {
	s.AllowedOAuthFlowsUserPoolClient = &v
	return s
}

// SetAllowedOAuthScopes sets the AllowedOAuthScopes field's value.
func (s *UserPoolClientType) SetAllowedOAuthScopes(v []*string) *UserPoolClientType {
	s.AllowedOAuthScopes = v
	return s
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *UserPoolClientType) SetAnalyticsConfiguration(v *AnalyticsConfigurationType) *UserPoolClientType {
	s.AnalyticsConfiguration = v
	return s
}

// SetCallbackURLs sets the CallbackURLs field's value.
func (s *UserPoolClientType) SetCallbackURLs(v []*string) *UserPoolClientType {
	s.CallbackURLs = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *UserPoolClientType) SetClientId(v string) *UserPoolClientType {
	s.ClientId = &v
	return s
}

// SetClientName sets the ClientName field's value.
func (s *UserPoolClientType) SetClientName(v string) *UserPoolClientType {
	s.ClientName = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *UserPoolClientType) SetClientSecret(v string) *UserPoolClientType {
	s.ClientSecret = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *UserPoolClientType) SetCreationDate(v time.Time) *UserPoolClientType {
	s.CreationDate = &v
	return s
}

// SetDefaultRedirectURI sets the DefaultRedirectURI field's value.
func (s *UserPoolClientType) SetDefaultRedirectURI(v string) *UserPoolClientType {
	s.DefaultRedirectURI = &v
	return s
}

// SetExplicitAuthFlows sets the ExplicitAuthFlows field's value.
func (s *UserPoolClientType) SetExplicitAuthFlows(v []*string) *UserPoolClientType {
	s.ExplicitAuthFlows = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UserPoolClientType) SetLastModifiedDate(v time.Time) *UserPoolClientType {
	s.LastModifiedDate = &v
	return s
}

// SetLogoutURLs sets the LogoutURLs field's value.
func (s *UserPoolClientType) SetLogoutURLs(v []*string) *UserPoolClientType {
	s.LogoutURLs = v
	return s
}

// SetReadAttributes sets the ReadAttributes field's value.
func (s *UserPoolClientType) SetReadAttributes(v []*string) *UserPoolClientType {
	s.ReadAttributes = v
	return s
}

// SetRefreshTokenValidity sets the RefreshTokenValidity field's value.
func (s *UserPoolClientType) SetRefreshTokenValidity(v int64) *UserPoolClientType {
	s.RefreshTokenValidity = &v
	return s
}

// SetSupportedIdentityProviders sets the SupportedIdentityProviders field's value.
func (s *UserPoolClientType) SetSupportedIdentityProviders(v []*string) *UserPoolClientType {
	s.SupportedIdentityProviders = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UserPoolClientType) SetUserPoolId(v string) *UserPoolClientType {
	s.UserPoolId = &v
	return s
}

// SetWriteAttributes sets the WriteAttributes field's value.
func (s *UserPoolClientType) SetWriteAttributes(v []*string) *UserPoolClientType {
	s.WriteAttributes = v
	return s
}

// A user pool description.
type UserPoolDescriptionType struct {
	_ struct{} `type:"structure"`

	// The date the user pool description was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID in a user pool description.
	Id *string `min:"1" type:"string"`

	// The AWS Lambda configuration information in a user pool description.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The date the user pool description was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name in a user pool description.
	Name *string `min:"1" type:"string"`

	// The user pool status in a user pool description.
	Status *string `type:"string" enum:"StatusType"`
}

// String returns the string representation
func (s UserPoolDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolDescriptionType) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *UserPoolDescriptionType) SetCreationDate(v time.Time) *UserPoolDescriptionType {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *UserPoolDescriptionType) SetId(v string) *UserPoolDescriptionType {
	s.Id = &v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *UserPoolDescriptionType) SetLambdaConfig(v *LambdaConfigType) *UserPoolDescriptionType {
	s.LambdaConfig = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UserPoolDescriptionType) SetLastModifiedDate(v time.Time) *UserPoolDescriptionType {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UserPoolDescriptionType) SetName(v string) *UserPoolDescriptionType {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UserPoolDescriptionType) SetStatus(v string) *UserPoolDescriptionType {
	s.Status = &v
	return s
}

// The policy associated with a user pool.
type UserPoolPolicyType struct {
	_ struct{} `type:"structure"`

	// The password policy.
	PasswordPolicy *PasswordPolicyType `type:"structure"`
}

// String returns the string representation
func (s UserPoolPolicyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolPolicyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolPolicyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPoolPolicyType"}
	if s.PasswordPolicy != nil {
		if err := s.PasswordPolicy.Validate(); err != nil {
			invalidParams.AddNested("PasswordPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswordPolicy sets the PasswordPolicy field's value.
func (s *UserPoolPolicyType) SetPasswordPolicy(v *PasswordPolicyType) *UserPoolPolicyType {
	s.PasswordPolicy = v
	return s
}

// A container for information about the user pool.
type UserPoolType struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Specifies the attributes that are aliased in a user pool.
	AliasAttributes []*string `type:"list"`

	// Specifies the attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []*string `type:"list"`

	// The date the user pool was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// Holds the domain prefix if the user pool has a domain associated with it.
	Domain *string `min:"1" type:"string"`

	// The email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// The reason why the email configuration cannot send the messages to your users.
	EmailConfigurationFailure *string `type:"string"`

	// The contents of the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// The subject of the email verification message.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers *int64 `type:"integer"`

	// The ID of the user pool.
	Id *string `min:"1" type:"string"`

	// The AWS Lambda triggers associated with tue user pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The date the user pool was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Can be one of the following values:
	//
	//    * OFF - MFA tokens are not required and cannot be specified during user
	//    registration.
	//
	//    * ON - MFA tokens are required for all user registrations. You can only
	//    specify required when you are initially creating a user pool.
	//
	//    * OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The name of the user pool.
	Name *string `min:"1" type:"string"`

	// The policies associated with the user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A container with the schema attributes of a user pool.
	SchemaAttributes []*SchemaAttributeType `min:"1" type:"list"`

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// The reason why the SMS configuration cannot send the messages to your users.
	SmsConfigurationFailure *string `type:"string"`

	// The contents of the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// The status of a user pool.
	Status *string `type:"string" enum:"StatusType"`

	// The user pool add-ons.
	UserPoolAddOns *UserPoolAddOnsType `type:"structure"`

	// The cost allocation tags for the user pool. For more information, see Adding
	// Cost Allocation Tags to Your User Pool (http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-cost-allocation-tagging.html)
	UserPoolTags map[string]*string `type:"map"`

	// Specifies whether email addresses or phone numbers can be specified as usernames
	// when a user signs up.
	UsernameAttributes []*string `type:"list"`

	// The template for verification messages.
	VerificationMessageTemplate *VerificationMessageTemplateType `type:"structure"`
}

// String returns the string representation
func (s UserPoolType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolType) GoString() string {
	return s.String()
}

// SetAdminCreateUserConfig sets the AdminCreateUserConfig field's value.
func (s *UserPoolType) SetAdminCreateUserConfig(v *AdminCreateUserConfigType) *UserPoolType {
	s.AdminCreateUserConfig = v
	return s
}

// SetAliasAttributes sets the AliasAttributes field's value.
func (s *UserPoolType) SetAliasAttributes(v []*string) *UserPoolType {
	s.AliasAttributes = v
	return s
}

// SetAutoVerifiedAttributes sets the AutoVerifiedAttributes field's value.
func (s *UserPoolType) SetAutoVerifiedAttributes(v []*string) *UserPoolType {
	s.AutoVerifiedAttributes = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *UserPoolType) SetCreationDate(v time.Time) *UserPoolType {
	s.CreationDate = &v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *UserPoolType) SetDeviceConfiguration(v *DeviceConfigurationType) *UserPoolType {
	s.DeviceConfiguration = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UserPoolType) SetDomain(v string) *UserPoolType {
	s.Domain = &v
	return s
}

// SetEmailConfiguration sets the EmailConfiguration field's value.
func (s *UserPoolType) SetEmailConfiguration(v *EmailConfigurationType) *UserPoolType {
	s.EmailConfiguration = v
	return s
}

// SetEmailConfigurationFailure sets the EmailConfigurationFailure field's value.
func (s *UserPoolType) SetEmailConfigurationFailure(v string) *UserPoolType {
	s.EmailConfigurationFailure = &v
	return s
}

// SetEmailVerificationMessage sets the EmailVerificationMessage field's value.
func (s *UserPoolType) SetEmailVerificationMessage(v string) *UserPoolType {
	s.EmailVerificationMessage = &v
	return s
}

// SetEmailVerificationSubject sets the EmailVerificationSubject field's value.
func (s *UserPoolType) SetEmailVerificationSubject(v string) *UserPoolType {
	s.EmailVerificationSubject = &v
	return s
}

// SetEstimatedNumberOfUsers sets the EstimatedNumberOfUsers field's value.
func (s *UserPoolType) SetEstimatedNumberOfUsers(v int64) *UserPoolType {
	s.EstimatedNumberOfUsers = &v
	return s
}

// SetId sets the Id field's value.
func (s *UserPoolType) SetId(v string) *UserPoolType {
	s.Id = &v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *UserPoolType) SetLambdaConfig(v *LambdaConfigType) *UserPoolType {
	s.LambdaConfig = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UserPoolType) SetLastModifiedDate(v time.Time) *UserPoolType {
	s.LastModifiedDate = &v
	return s
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *UserPoolType) SetMfaConfiguration(v string) *UserPoolType {
	s.MfaConfiguration = &v
	return s
}

// SetName sets the Name field's value.
func (s *UserPoolType) SetName(v string) *UserPoolType {
	s.Name = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *UserPoolType) SetPolicies(v *UserPoolPolicyType) *UserPoolType {
	s.Policies = v
	return s
}

// SetSchemaAttributes sets the SchemaAttributes field's value.
func (s *UserPoolType) SetSchemaAttributes(v []*SchemaAttributeType) *UserPoolType {
	s.SchemaAttributes = v
	return s
}

// SetSmsAuthenticationMessage sets the SmsAuthenticationMessage field's value.
func (s *UserPoolType) SetSmsAuthenticationMessage(v string) *UserPoolType {
	s.SmsAuthenticationMessage = &v
	return s
}

// SetSmsConfiguration sets the SmsConfiguration field's value.
func (s *UserPoolType) SetSmsConfiguration(v *SmsConfigurationType) *UserPoolType {
	s.SmsConfiguration = v
	return s
}

// SetSmsConfigurationFailure sets the SmsConfigurationFailure field's value.
func (s *UserPoolType) SetSmsConfigurationFailure(v string) *UserPoolType {
	s.SmsConfigurationFailure = &v
	return s
}

// SetSmsVerificationMessage sets the SmsVerificationMessage field's value.
func (s *UserPoolType) SetSmsVerificationMessage(v string) *UserPoolType {
	s.SmsVerificationMessage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UserPoolType) SetStatus(v string) *UserPoolType {
	s.Status = &v
	return s
}

// SetUserPoolAddOns sets the UserPoolAddOns field's value.
func (s *UserPoolType) SetUserPoolAddOns(v *UserPoolAddOnsType) *UserPoolType {
	s.UserPoolAddOns = v
	return s
}

// SetUserPoolTags sets the UserPoolTags field's value.
func (s *UserPoolType) SetUserPoolTags(v map[string]*string) *UserPoolType {
	s.UserPoolTags = v
	return s
}

// SetUsernameAttributes sets the UsernameAttributes field's value.
func (s *UserPoolType) SetUsernameAttributes(v []*string) *UserPoolType {
	s.UsernameAttributes = v
	return s
}

// SetVerificationMessageTemplate sets the VerificationMessageTemplate field's value.
func (s *UserPoolType) SetVerificationMessageTemplate(v *VerificationMessageTemplateType) *UserPoolType {
	s.VerificationMessageTemplate = v
	return s
}

// The user type.
type UserType struct {
	_ struct{} `type:"structure"`

	// A container with information about the user type attributes.
	Attributes []*AttributeType `type:"list"`

	// Specifies whether the user is enabled.
	Enabled *bool `type:"boolean"`

	// The MFA options for the user.
	MFAOptions []*MFAOptionType `type:"list"`

	// The creation date of the user.
	UserCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last modified date of the user.
	UserLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * COMPROMISED - User is disabled due to a potential security threat.
	//
	//    * UNKNOWN - User status is not known.
	UserStatus *string `type:"string" enum:"UserStatusType"`

	// The user name of the user you wish to describe.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserType) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *UserType) SetAttributes(v []*AttributeType) *UserType {
	s.Attributes = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UserType) SetEnabled(v bool) *UserType {
	s.Enabled = &v
	return s
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *UserType) SetMFAOptions(v []*MFAOptionType) *UserType {
	s.MFAOptions = v
	return s
}

// SetUserCreateDate sets the UserCreateDate field's value.
func (s *UserType) SetUserCreateDate(v time.Time) *UserType {
	s.UserCreateDate = &v
	return s
}

// SetUserLastModifiedDate sets the UserLastModifiedDate field's value.
func (s *UserType) SetUserLastModifiedDate(v time.Time) *UserType {
	s.UserLastModifiedDate = &v
	return s
}

// SetUserStatus sets the UserStatus field's value.
func (s *UserType) SetUserStatus(v string) *UserType {
	s.UserStatus = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UserType) SetUsername(v string) *UserType {
	s.Username = &v
	return s
}

// The template for verification messages.
type VerificationMessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The default email option.
	DefaultEmailOption *string `type:"string" enum:"DefaultEmailOptionType"`

	// The email message template.
	EmailMessage *string `min:"6" type:"string"`

	// The email message template for sending a confirmation link to the user.
	EmailMessageByLink *string `min:"6" type:"string"`

	// The subject line for the email message template.
	EmailSubject *string `min:"1" type:"string"`

	// The subject line for the email message template for sending a confirmation
	// link to the user.
	EmailSubjectByLink *string `min:"1" type:"string"`

	// The SMS message template.
	SmsMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s VerificationMessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerificationMessageTemplateType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerificationMessageTemplateType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerificationMessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailMessageByLink != nil && len(*s.EmailMessageByLink) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailMessageByLink", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.EmailSubjectByLink != nil && len(*s.EmailSubjectByLink) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailSubjectByLink", 1))
	}
	if s.SmsMessage != nil && len(*s.SmsMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultEmailOption sets the DefaultEmailOption field's value.
func (s *VerificationMessageTemplateType) SetDefaultEmailOption(v string) *VerificationMessageTemplateType {
	s.DefaultEmailOption = &v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *VerificationMessageTemplateType) SetEmailMessage(v string) *VerificationMessageTemplateType {
	s.EmailMessage = &v
	return s
}

// SetEmailMessageByLink sets the EmailMessageByLink field's value.
func (s *VerificationMessageTemplateType) SetEmailMessageByLink(v string) *VerificationMessageTemplateType {
	s.EmailMessageByLink = &v
	return s
}

// SetEmailSubject sets the EmailSubject field's value.
func (s *VerificationMessageTemplateType) SetEmailSubject(v string) *VerificationMessageTemplateType {
	s.EmailSubject = &v
	return s
}

// SetEmailSubjectByLink sets the EmailSubjectByLink field's value.
func (s *VerificationMessageTemplateType) SetEmailSubjectByLink(v string) *VerificationMessageTemplateType {
	s.EmailSubjectByLink = &v
	return s
}

// SetSmsMessage sets the SmsMessage field's value.
func (s *VerificationMessageTemplateType) SetSmsMessage(v string) *VerificationMessageTemplateType {
	s.SmsMessage = &v
	return s
}

type VerifySoftwareTokenInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`

	// The friendly device name.
	FriendlyDeviceName *string `type:"string"`

	// The session which should be passed both ways in challenge-response calls
	// to the service.
	Session *string `min:"20" type:"string"`

	// The one time password computed using the secret code returned by
	//
	// UserCode is a required field
	UserCode *string `min:"6" type:"string" required:"true"`
}

// String returns the string representation
func (s VerifySoftwareTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifySoftwareTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifySoftwareTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifySoftwareTokenInput"}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}
	if s.UserCode == nil {
		invalidParams.Add(request.NewErrParamRequired("UserCode"))
	}
	if s.UserCode != nil && len(*s.UserCode) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("UserCode", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *VerifySoftwareTokenInput) SetAccessToken(v string) *VerifySoftwareTokenInput {
	s.AccessToken = &v
	return s
}

// SetFriendlyDeviceName sets the FriendlyDeviceName field's value.
func (s *VerifySoftwareTokenInput) SetFriendlyDeviceName(v string) *VerifySoftwareTokenInput {
	s.FriendlyDeviceName = &v
	return s
}

// SetSession sets the Session field's value.
func (s *VerifySoftwareTokenInput) SetSession(v string) *VerifySoftwareTokenInput {
	s.Session = &v
	return s
}

// SetUserCode sets the UserCode field's value.
func (s *VerifySoftwareTokenInput) SetUserCode(v string) *VerifySoftwareTokenInput {
	s.UserCode = &v
	return s
}

type VerifySoftwareTokenOutput struct {
	_ struct{} `type:"structure"`

	// The session which should be passed both ways in challenge-response calls
	// to the service.
	Session *string `min:"20" type:"string"`

	// The status of the verify software token.
	Status *string `type:"string" enum:"VerifySoftwareTokenResponseType"`
}

// String returns the string representation
func (s VerifySoftwareTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifySoftwareTokenOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *VerifySoftwareTokenOutput) SetSession(v string) *VerifySoftwareTokenOutput {
	s.Session = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VerifySoftwareTokenOutput) SetStatus(v string) *VerifySoftwareTokenOutput {
	s.Status = &v
	return s
}

// Represents the request to verify user attributes.
type VerifyUserAttributeInput struct {
	_ struct{} `type:"structure"`

	// Represents the access token of the request to verify user attributes.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The attribute name in the request to verify user attributes.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The verification code in the request to verify user attributes.
	//
	// Code is a required field
	Code *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyUserAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyUserAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyUserAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyUserAttributeInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.Code != nil && len(*s.Code) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Code", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *VerifyUserAttributeInput) SetAccessToken(v string) *VerifyUserAttributeInput {
	s.AccessToken = &v
	return s
}

// SetAttributeName sets the AttributeName field's value.
func (s *VerifyUserAttributeInput) SetAttributeName(v string) *VerifyUserAttributeInput {
	s.AttributeName = &v
	return s
}

// SetCode sets the Code field's value.
func (s *VerifyUserAttributeInput) SetCode(v string) *VerifyUserAttributeInput {
	s.Code = &v
	return s
}

// A container representing the response from the server from the request to
// verify user attributes.
type VerifyUserAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyUserAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyUserAttributeOutput) GoString() string {
	return s.String()
}

const (
	// AccountTakeoverEventActionTypeBlock is a AccountTakeoverEventActionType enum value
	AccountTakeoverEventActionTypeBlock = "BLOCK"

	// AccountTakeoverEventActionTypeMfaIfConfigured is a AccountTakeoverEventActionType enum value
	AccountTakeoverEventActionTypeMfaIfConfigured = "MFA_IF_CONFIGURED"

	// AccountTakeoverEventActionTypeMfaRequired is a AccountTakeoverEventActionType enum value
	AccountTakeoverEventActionTypeMfaRequired = "MFA_REQUIRED"

	// AccountTakeoverEventActionTypeNoAction is a AccountTakeoverEventActionType enum value
	AccountTakeoverEventActionTypeNoAction = "NO_ACTION"
)

const (
	// AdvancedSecurityModeTypeOff is a AdvancedSecurityModeType enum value
	AdvancedSecurityModeTypeOff = "OFF"

	// AdvancedSecurityModeTypeAudit is a AdvancedSecurityModeType enum value
	AdvancedSecurityModeTypeAudit = "AUDIT"

	// AdvancedSecurityModeTypeEnforced is a AdvancedSecurityModeType enum value
	AdvancedSecurityModeTypeEnforced = "ENFORCED"
)

const (
	// AliasAttributeTypePhoneNumber is a AliasAttributeType enum value
	AliasAttributeTypePhoneNumber = "phone_number"

	// AliasAttributeTypeEmail is a AliasAttributeType enum value
	AliasAttributeTypeEmail = "email"

	// AliasAttributeTypePreferredUsername is a AliasAttributeType enum value
	AliasAttributeTypePreferredUsername = "preferred_username"
)

const (
	// AttributeDataTypeString is a AttributeDataType enum value
	AttributeDataTypeString = "String"

	// AttributeDataTypeNumber is a AttributeDataType enum value
	AttributeDataTypeNumber = "Number"

	// AttributeDataTypeDateTime is a AttributeDataType enum value
	AttributeDataTypeDateTime = "DateTime"

	// AttributeDataTypeBoolean is a AttributeDataType enum value
	AttributeDataTypeBoolean = "Boolean"
)

const (
	// AuthFlowTypeUserSrpAuth is a AuthFlowType enum value
	AuthFlowTypeUserSrpAuth = "USER_SRP_AUTH"

	// AuthFlowTypeRefreshTokenAuth is a AuthFlowType enum value
	AuthFlowTypeRefreshTokenAuth = "REFRESH_TOKEN_AUTH"

	// AuthFlowTypeRefreshToken is a AuthFlowType enum value
	AuthFlowTypeRefreshToken = "REFRESH_TOKEN"

	// AuthFlowTypeCustomAuth is a AuthFlowType enum value
	AuthFlowTypeCustomAuth = "CUSTOM_AUTH"

	// AuthFlowTypeAdminNoSrpAuth is a AuthFlowType enum value
	AuthFlowTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"

	// AuthFlowTypeUserPasswordAuth is a AuthFlowType enum value
	AuthFlowTypeUserPasswordAuth = "USER_PASSWORD_AUTH"
)

const (
	// ChallengeNamePassword is a ChallengeName enum value
	ChallengeNamePassword = "Password"

	// ChallengeNameMfa is a ChallengeName enum value
	ChallengeNameMfa = "Mfa"
)

const (
	// ChallengeNameTypeSmsMfa is a ChallengeNameType enum value
	ChallengeNameTypeSmsMfa = "SMS_MFA"

	// ChallengeNameTypeSoftwareTokenMfa is a ChallengeNameType enum value
	ChallengeNameTypeSoftwareTokenMfa = "SOFTWARE_TOKEN_MFA"

	// ChallengeNameTypeSelectMfaType is a ChallengeNameType enum value
	ChallengeNameTypeSelectMfaType = "SELECT_MFA_TYPE"

	// ChallengeNameTypeMfaSetup is a ChallengeNameType enum value
	ChallengeNameTypeMfaSetup = "MFA_SETUP"

	// ChallengeNameTypePasswordVerifier is a ChallengeNameType enum value
	ChallengeNameTypePasswordVerifier = "PASSWORD_VERIFIER"

	// ChallengeNameTypeCustomChallenge is a ChallengeNameType enum value
	ChallengeNameTypeCustomChallenge = "CUSTOM_CHALLENGE"

	// ChallengeNameTypeDeviceSrpAuth is a ChallengeNameType enum value
	ChallengeNameTypeDeviceSrpAuth = "DEVICE_SRP_AUTH"

	// ChallengeNameTypeDevicePasswordVerifier is a ChallengeNameType enum value
	ChallengeNameTypeDevicePasswordVerifier = "DEVICE_PASSWORD_VERIFIER"

	// ChallengeNameTypeAdminNoSrpAuth is a ChallengeNameType enum value
	ChallengeNameTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"

	// ChallengeNameTypeNewPasswordRequired is a ChallengeNameType enum value
	ChallengeNameTypeNewPasswordRequired = "NEW_PASSWORD_REQUIRED"
)

const (
	// ChallengeResponseSuccess is a ChallengeResponse enum value
	ChallengeResponseSuccess = "Success"

	// ChallengeResponseFailure is a ChallengeResponse enum value
	ChallengeResponseFailure = "Failure"
)

const (
	// CompromisedCredentialsEventActionTypeBlock is a CompromisedCredentialsEventActionType enum value
	CompromisedCredentialsEventActionTypeBlock = "BLOCK"

	// CompromisedCredentialsEventActionTypeNoAction is a CompromisedCredentialsEventActionType enum value
	CompromisedCredentialsEventActionTypeNoAction = "NO_ACTION"
)

const (
	// DefaultEmailOptionTypeConfirmWithLink is a DefaultEmailOptionType enum value
	DefaultEmailOptionTypeConfirmWithLink = "CONFIRM_WITH_LINK"

	// DefaultEmailOptionTypeConfirmWithCode is a DefaultEmailOptionType enum value
	DefaultEmailOptionTypeConfirmWithCode = "CONFIRM_WITH_CODE"
)

const (
	// DeliveryMediumTypeSms is a DeliveryMediumType enum value
	DeliveryMediumTypeSms = "SMS"

	// DeliveryMediumTypeEmail is a DeliveryMediumType enum value
	DeliveryMediumTypeEmail = "EMAIL"
)

const (
	// DeviceRememberedStatusTypeRemembered is a DeviceRememberedStatusType enum value
	DeviceRememberedStatusTypeRemembered = "remembered"

	// DeviceRememberedStatusTypeNotRemembered is a DeviceRememberedStatusType enum value
	DeviceRememberedStatusTypeNotRemembered = "not_remembered"
)

const (
	// DomainStatusTypeCreating is a DomainStatusType enum value
	DomainStatusTypeCreating = "CREATING"

	// DomainStatusTypeDeleting is a DomainStatusType enum value
	DomainStatusTypeDeleting = "DELETING"

	// DomainStatusTypeUpdating is a DomainStatusType enum value
	DomainStatusTypeUpdating = "UPDATING"

	// DomainStatusTypeActive is a DomainStatusType enum value
	DomainStatusTypeActive = "ACTIVE"

	// DomainStatusTypeFailed is a DomainStatusType enum value
	DomainStatusTypeFailed = "FAILED"
)

const (
	// EventFilterTypeSignIn is a EventFilterType enum value
	EventFilterTypeSignIn = "SIGN_IN"

	// EventFilterTypePasswordChange is a EventFilterType enum value
	EventFilterTypePasswordChange = "PASSWORD_CHANGE"

	// EventFilterTypeSignUp is a EventFilterType enum value
	EventFilterTypeSignUp = "SIGN_UP"
)

const (
	// EventResponseTypeSuccess is a EventResponseType enum value
	EventResponseTypeSuccess = "Success"

	// EventResponseTypeFailure is a EventResponseType enum value
	EventResponseTypeFailure = "Failure"
)

const (
	// EventTypeSignIn is a EventType enum value
	EventTypeSignIn = "SignIn"

	// EventTypeSignUp is a EventType enum value
	EventTypeSignUp = "SignUp"

	// EventTypeForgotPassword is a EventType enum value
	EventTypeForgotPassword = "ForgotPassword"
)

const (
	// ExplicitAuthFlowsTypeAdminNoSrpAuth is a ExplicitAuthFlowsType enum value
	ExplicitAuthFlowsTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"

	// ExplicitAuthFlowsTypeCustomAuthFlowOnly is a ExplicitAuthFlowsType enum value
	ExplicitAuthFlowsTypeCustomAuthFlowOnly = "CUSTOM_AUTH_FLOW_ONLY"

	// ExplicitAuthFlowsTypeUserPasswordAuth is a ExplicitAuthFlowsType enum value
	ExplicitAuthFlowsTypeUserPasswordAuth = "USER_PASSWORD_AUTH"
)

const (
	// FeedbackValueTypeValid is a FeedbackValueType enum value
	FeedbackValueTypeValid = "Valid"

	// FeedbackValueTypeInvalid is a FeedbackValueType enum value
	FeedbackValueTypeInvalid = "Invalid"
)

const (
	// IdentityProviderTypeTypeSaml is a IdentityProviderTypeType enum value
	IdentityProviderTypeTypeSaml = "SAML"

	// IdentityProviderTypeTypeFacebook is a IdentityProviderTypeType enum value
	IdentityProviderTypeTypeFacebook = "Facebook"

	// IdentityProviderTypeTypeGoogle is a IdentityProviderTypeType enum value
	IdentityProviderTypeTypeGoogle = "Google"

	// IdentityProviderTypeTypeLoginWithAmazon is a IdentityProviderTypeType enum value
	IdentityProviderTypeTypeLoginWithAmazon = "LoginWithAmazon"
)

const (
	// MessageActionTypeResend is a MessageActionType enum value
	MessageActionTypeResend = "RESEND"

	// MessageActionTypeSuppress is a MessageActionType enum value
	MessageActionTypeSuppress = "SUPPRESS"
)

const (
	// OAuthFlowTypeCode is a OAuthFlowType enum value
	OAuthFlowTypeCode = "code"

	// OAuthFlowTypeImplicit is a OAuthFlowType enum value
	OAuthFlowTypeImplicit = "implicit"

	// OAuthFlowTypeClientCredentials is a OAuthFlowType enum value
	OAuthFlowTypeClientCredentials = "client_credentials"
)

const (
	// RiskDecisionTypeNoRisk is a RiskDecisionType enum value
	RiskDecisionTypeNoRisk = "NoRisk"

	// RiskDecisionTypeAccountTakeover is a RiskDecisionType enum value
	RiskDecisionTypeAccountTakeover = "AccountTakeover"

	// RiskDecisionTypeBlock is a RiskDecisionType enum value
	RiskDecisionTypeBlock = "Block"
)

const (
	// RiskLevelTypeLow is a RiskLevelType enum value
	RiskLevelTypeLow = "Low"

	// RiskLevelTypeMedium is a RiskLevelType enum value
	RiskLevelTypeMedium = "Medium"

	// RiskLevelTypeHigh is a RiskLevelType enum value
	RiskLevelTypeHigh = "High"
)

const (
	// StatusTypeEnabled is a StatusType enum value
	StatusTypeEnabled = "Enabled"

	// StatusTypeDisabled is a StatusType enum value
	StatusTypeDisabled = "Disabled"
)

const (
	// UserImportJobStatusTypeCreated is a UserImportJobStatusType enum value
	UserImportJobStatusTypeCreated = "Created"

	// UserImportJobStatusTypePending is a UserImportJobStatusType enum value
	UserImportJobStatusTypePending = "Pending"

	// UserImportJobStatusTypeInProgress is a UserImportJobStatusType enum value
	UserImportJobStatusTypeInProgress = "InProgress"

	// UserImportJobStatusTypeStopping is a UserImportJobStatusType enum value
	UserImportJobStatusTypeStopping = "Stopping"

	// UserImportJobStatusTypeExpired is a UserImportJobStatusType enum value
	UserImportJobStatusTypeExpired = "Expired"

	// UserImportJobStatusTypeStopped is a UserImportJobStatusType enum value
	UserImportJobStatusTypeStopped = "Stopped"

	// UserImportJobStatusTypeFailed is a UserImportJobStatusType enum value
	UserImportJobStatusTypeFailed = "Failed"

	// UserImportJobStatusTypeSucceeded is a UserImportJobStatusType enum value
	UserImportJobStatusTypeSucceeded = "Succeeded"
)

const (
	// UserPoolMfaTypeOff is a UserPoolMfaType enum value
	UserPoolMfaTypeOff = "OFF"

	// UserPoolMfaTypeOn is a UserPoolMfaType enum value
	UserPoolMfaTypeOn = "ON"

	// UserPoolMfaTypeOptional is a UserPoolMfaType enum value
	UserPoolMfaTypeOptional = "OPTIONAL"
)

const (
	// UserStatusTypeUnconfirmed is a UserStatusType enum value
	UserStatusTypeUnconfirmed = "UNCONFIRMED"

	// UserStatusTypeConfirmed is a UserStatusType enum value
	UserStatusTypeConfirmed = "CONFIRMED"

	// UserStatusTypeArchived is a UserStatusType enum value
	UserStatusTypeArchived = "ARCHIVED"

	// UserStatusTypeCompromised is a UserStatusType enum value
	UserStatusTypeCompromised = "COMPROMISED"

	// UserStatusTypeUnknown is a UserStatusType enum value
	UserStatusTypeUnknown = "UNKNOWN"

	// UserStatusTypeResetRequired is a UserStatusType enum value
	UserStatusTypeResetRequired = "RESET_REQUIRED"

	// UserStatusTypeForceChangePassword is a UserStatusType enum value
	UserStatusTypeForceChangePassword = "FORCE_CHANGE_PASSWORD"
)

const (
	// UsernameAttributeTypePhoneNumber is a UsernameAttributeType enum value
	UsernameAttributeTypePhoneNumber = "phone_number"

	// UsernameAttributeTypeEmail is a UsernameAttributeType enum value
	UsernameAttributeTypeEmail = "email"
)

const (
	// VerifiedAttributeTypePhoneNumber is a VerifiedAttributeType enum value
	VerifiedAttributeTypePhoneNumber = "phone_number"

	// VerifiedAttributeTypeEmail is a VerifiedAttributeType enum value
	VerifiedAttributeTypeEmail = "email"
)

const (
	// VerifySoftwareTokenResponseTypeSuccess is a VerifySoftwareTokenResponseType enum value
	VerifySoftwareTokenResponseTypeSuccess = "SUCCESS"

	// VerifySoftwareTokenResponseTypeError is a VerifySoftwareTokenResponseType enum value
	VerifySoftwareTokenResponseTypeError = "ERROR"
)
