# vhs

# AWS Accounts

For development, use
[twitch-vodsvc-dev](https://isengard.amazon.com/federate?account=151062794160&role=Admin).

# Prerequisites

1. Install tools: `brew install direnv jq httpie awscli dep`
2. [Hook direnv into your shell](https://github.com/direnv/direnv#setup)
3. Allow .envrc: `direnv allow .`

# Development

1. Create build pipeline: `make buildstack`
2. Locate the CodePipeline `vhs-${USER}` and watch the application being
   created. This may take a few minutes due to the CloudFront distribution.
3. Once the application stack has been created, load up environment variables:
   `eval $(make env)`
4. Test it out!

    `http post ${VHS_URL}/uploads`

## Local Execution

1. Setup environment: `eval $(make env)`
2. Run: `go run src/api/get_upload/get_upload.go id=12345`

## Testing

Counterfeiter is used for mocks

1. Run: `make test`

## Adding new API endpoints

1. Write your Lambda Go function in `src/api`
2. Add a new `AWS::Serverless::Function` and `AWS::Lambda::Permission` to `serverless.yaml`
3. Define the endpoint in `swagger.yaml` and an associated response definition

## Create or Update a Customer Stack

First, ensure all changes have been built: `make build`

Pick a name for the new stack, e.g. `export STACK_NAME=amzn-music`.

Then, deploy or update the stack using CloudFormation:
```
aws cloudformation deploy \
  --template-file build/serverless/transformed.yaml \
  --stack-name ${STACK_NAME} \
  --capabilities CAPABILITY_IAM \
  --parameter-overrides \
    EnvironmentName=${STACK_NAME} \
    VideoBucketName=${STACK_NAME}.videos \
    UploadBucketName=${STACK_NAME}.uploads \
    EnvironmentType=customer
```

# TODO

* Add Viewcounts to REST API (or to a Pubsub stream)
* Set up VPC Peering/Direct Link so we can query video services
* Caching on calls to Usher (ex. GetStream)
* Improve usher client: Add context support and breakers where applicable
* Log stack traces and error message into Cloudwatch on error
* Deletion worker mechanism
* Integrate with AWS IAM auth
* CloudWatch logs video/upload audit logger
* Write status updates to SNS queue
* verify/manage playback token
* Collect upload and playback metrics
* create manifest from video endpoint (highlights)
* create storyboards


# Build and Deploy

* Modify github-codecommit to push to multiple aws accounts
* Move customer stacks to production account
* Add jitter to customer pipeline
* Add validation test to customer pipeline
* Enable lambda canary deployments

# Nice to Have

* More configurable transcodes (low-res first)
* Re-transcodes
* Integrate AWS SDK with Xray
* Make database queryable (s3 + athena?)
* Only update lambda functions if their md5s change
* Make CORS configuration generic
* Enable caching of read-only APIs
* Add Batch Get operation

## Troubleshooting

1. If you use [aws-vault](https://github.com/99designs/aws-vault), credentials may not get set correctly via the Makefile. Add credentials to your `env` manually.
