package main

import (
	"context"
	"errors"
	"time"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/lambda"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-lambda-go/events"
	"go.uber.org/zap"
)

var (
	logger     *zap.SugaredLogger  = vhslog.Logger
	videoTable dynamodb.VideoTable = dynamodb.NewVideoTable()
)

const (
	defaultDeleteDuration = 5 * time.Minute
)

func main() {
	lambda.StartAPIGateway(DeleteVideo)
}

func DeleteVideo(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	deleteTime := time.Now().Add(defaultDeleteDuration)
	err := videoTable.SetVideoDeleteTime(ctx, id, deleteTime)
	if err != nil {
		return nil, httpserver.InternalServerError(errors.New("Unable to set delete time on video"))
	}

	return nil, nil
}
