package main

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/lambda"
	"code.justin.tv/vodsvc/vhs/src/types"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-lambda-go/events"
	"go.uber.org/zap"
)

var (
	logger      *zap.SugaredLogger   = vhslog.Logger
	uploadTable dynamodb.UploadTable = dynamodb.NewUploadTable()
)

func main() {
	lambda.StartAPIGateway(GetUpload)
}

func GetUpload(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	return getUpload(ctx, id)
}

func getUpload(ctx context.Context, id string) (types.Upload, *httpserver.HTTPError) {
	upload, err := uploadTable.GetUpload(ctx, id)
	if err != nil {
		return upload, httpserver.InternalServerError(err)
	}

	if upload.Id == "" {
		return upload, httpserver.NotFound("Upload not found: id=" + id)
	}

	return upload, nil
}
