package main

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/lambda"
	"code.justin.tv/vodsvc/vhs/src/types"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-lambda-go/events"
	"go.uber.org/zap"
)

var (
	logger     *zap.SugaredLogger  = vhslog.Logger
	videoTable dynamodb.VideoTable = dynamodb.NewVideoTable()
)

func main() {
	lambda.StartAPIGateway(GetVideo)
}

func GetVideo(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	id, ok := r.PathParameters["id"]
	if !ok {
		return nil, httpserver.BadRequest("'id' is a required parameter.")
	}

	return getVideo(ctx, id)
}

func getVideo(ctx context.Context, id string) (types.Video, *httpserver.HTTPError) {
	video, err := videoTable.GetVideo(ctx, id)
	if err != nil {
		return video, httpserver.InternalServerError(err)
	}

	if video.Id == "" {
		return video, httpserver.NotFound("Video not found: id=" + id)
	}

	return video, nil
}
