package main

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/lambda"
	"code.justin.tv/vodsvc/vhs/src/types"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-lambda-go/events"
	"go.uber.org/zap"
)

var (
	logger      *zap.SugaredLogger   = vhslog.Logger
	uploadTable dynamodb.UploadTable = dynamodb.NewUploadTable()
)

func main() {
	lambda.StartAPIGateway(ListUploads)
}

func ListUploads(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	paginationToken := r.QueryStringParameters["paginationToken"]

	uploads, lastKey, err := uploadTable.ListUploads(ctx, paginationToken)
	if err != nil {
		return nil, httpserver.InternalServerError(err)
	}

	return &types.ListUploadsResponse{Uploads: uploads, PaginationToken: lastKey, Count: len(uploads)}, nil
}
