package main

import (
	"context"

	"code.justin.tv/vodsvc/httpserver"
	"code.justin.tv/vodsvc/vhs/src/dynamodb"
	"code.justin.tv/vodsvc/vhs/src/lambda"
	"code.justin.tv/vodsvc/vhs/src/types"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-lambda-go/events"
	"go.uber.org/zap"
)

var (
	logger     *zap.SugaredLogger  = vhslog.Logger
	videoTable dynamodb.VideoTable = dynamodb.NewVideoTable()
)

func main() {
	lambda.StartAPIGateway(ListVideos)
}

func ListVideos(ctx context.Context, r events.APIGatewayProxyRequest) (interface{}, *httpserver.HTTPError) {
	paginationToken := r.QueryStringParameters["paginationToken"]

	videos, lastKey, err := videoTable.ListVideos(ctx, paginationToken)
	if err != nil {
		return nil, httpserver.InternalServerError(err)
	}

	return &types.ListVideosResponse{Videos: videos, PaginationToken: lastKey, Count: len(videos)}, nil
}
