package dynamodb

import (
	"context"
	"strconv"
	"time"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (d *ddb) CreateUpload(ctx context.Context, id, s3Bucket, s3Prefix, videoBucket, sourceFile string) (types.Upload, error) {
	now := now()
	now3339 := now.Format(time.RFC3339)
	expireTime := now.Add(7 * 24 * time.Hour).Unix()
	input := &dynamodb.PutItemInput{
		TableName: aws.String(d.table),
		Item: map[string]*dynamodb.AttributeValue{
			"Id":          {S: aws.String(id)},
			"LastUpdated": {S: aws.String(now3339)},
			"S3Bucket":    {S: aws.String(s3Bucket)},
			"S3Prefix":    {S: aws.String(s3Prefix)},
			"VideoBucket": {S: aws.String(videoBucket)},
			"SourceFile":  {S: aws.String(sourceFile)},
			"Size":        {N: aws.String("0")},
			"Status":      {S: aws.String(types.StatusCreated)},
			"TTL":         {N: aws.String(strconv.FormatInt(expireTime, 10))},
			"StatusTimes": {
				M: map[string]*dynamodb.AttributeValue{
					types.StatusCreated: {S: aws.String(now3339)},
				},
			},
		},
	}

	_, err := d.client.PutItemWithContext(ctx, input)

	statusTimes := map[string]time.Time{types.StatusCreated: now}
	u := types.Upload{
		Id:          id,
		LastUpdated: now,
		S3Bucket:    s3Bucket,
		S3Prefix:    s3Prefix,
		VideoBucket: videoBucket,
		SourceFile:  sourceFile,
		Status:      types.StatusCreated,
		StatusTimes: statusTimes,
	}

	return u, err
}
