package dynamodb

import (
	"context"
	"time"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) CreateVideo(ctx context.Context, video types.Video) error {
	now := now()
	now3339 := now.Format(time.RFC3339)
	video.CreateTime = now

	item, err := dynamodbattribute.MarshalMap(video)
	if err != nil {
		return err
	}

	item["CreateTime"] = &dynamodb.AttributeValue{S: aws.String(now3339)}

	renditions, err := dynamodbattribute.MarshalList(video.Renditions)
	if err != nil {
		return err
	}
	item["Renditions"] = &dynamodb.AttributeValue{L: renditions}

	thumbnails, err := dynamodbattribute.MarshalList(video.Thumbnails)
	if err != nil {
		return err
	}
	item["Thumbnails"] = &dynamodb.AttributeValue{L: thumbnails}

	input := &dynamodb.PutItemInput{
		TableName: aws.String(d.table),
		Item:      item,
	}

	_, err = d.client.PutItemWithContext(ctx, input)

	return err
}
